/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtPlaceHolderStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J=\u0010\b\u001a\n \n*\u0004\u0018\u0001H\tH\t\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u000e\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u001c\u001a\u00020\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinPlaceHolderStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinPlaceHolderStub;)V", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "addAnnotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "addModifier", "", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "getContainingClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getOrCreateConstructorKeyword", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "removeModifier", "removeRedundantConstructorKeywordAndSpace", "psi"})
public final class KtPrimaryConstructor
extends KtConstructor<KtPrimaryConstructor> {
    public KtPrimaryConstructor(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    public KtPrimaryConstructor(@NotNull KotlinPlaceHolderStub<KtPrimaryConstructor> stub) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        KtPlaceHolderStubElementType<KtPrimaryConstructor> ktPlaceHolderStubElementType = KtStubElementTypes.PRIMARY_CONSTRUCTOR;
        Intrinsics.checkNotNullExpressionValue(ktPlaceHolderStubElementType, (String)"PRIMARY_CONSTRUCTOR");
        super(stub, ktPlaceHolderStubElementType);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitPrimaryConstructor(this, data);
    }

    @Override
    @NotNull
    public KtClassOrObject getContainingClassOrObject() {
        PsiElement psiElement = this.getParent();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
        }
        return (KtClassOrObject)psiElement;
    }

    private final PsiElement getOrCreateConstructorKeyword() {
        PsiElement psiElement;
        PsiElement psiElement2 = this.getConstructorKeyword();
        if (psiElement2 == null) {
            PsiElement psiElement3 = KtPsiFactoryKt.KtPsiFactory$default(this, false, 2, null).createConstructorKeyword();
            KtParameterList ktParameterList = this.getValueParameterList();
            Intrinsics.checkNotNull((Object)ktParameterList);
            PsiElement psiElement4 = this.addBefore(psiElement3, ktParameterList);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"addBefore(KtPsiFactory(t\u2026(), valueParameterList!!)");
            psiElement = psiElement4;
        } else {
            psiElement = psiElement2;
        }
        return psiElement;
    }

    public final void removeRedundantConstructorKeywordAndSpace() {
        PsiElement psiElement = this.getConstructorKeyword();
        if (psiElement != null) {
            psiElement.delete();
        }
        if (this.getPrevSibling() instanceof PsiWhiteSpace) {
            this.getPrevSibling().delete();
        }
    }

    @Override
    public void addModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        KtModifierList modifierList2 = this.getModifierList();
        if (modifierList2 != null) {
            PsiElement psiElement;
            AddRemoveModifierKt.addModifier(modifierList2, modifier);
            if (this.getModifierList() == null && (psiElement = this.getConstructorKeyword()) != null) {
                psiElement.delete();
            }
        } else {
            if (Intrinsics.areEqual((Object)modifier, (Object)KtTokens.PUBLIC_KEYWORD)) {
                return;
            }
            KtModifierList newModifierList = KtPsiFactoryKt.KtPsiFactory$default(this, false, 2, null).createModifierList(modifier);
            this.addBefore(newModifierList, this.getOrCreateConstructorKeyword());
        }
    }

    @Override
    public void removeModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        super.removeModifier(modifier);
        if (this.getModifierList() == null) {
            this.removeRedundantConstructorKeywordAndSpace();
        }
    }

    @Override
    @NotNull
    public KtAnnotationEntry addAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter((Object)annotationEntry, (String)"annotationEntry");
        KtModifierList modifierList2 = this.getModifierList();
        if (modifierList2 != null) {
            PsiElement psiElement = modifierList2.addBefore(annotationEntry, modifierList2.getFirstChild());
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            }
            ktAnnotationEntry = (KtAnnotationEntry)psiElement;
        } else {
            List<KtAnnotationEntry> list2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"project");
            KtPsiFactory ktPsiFactory = new KtPsiFactory((Project)((Object)list2), false, 2, null);
            list2 = annotationEntry.getText();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"annotationEntry.text");
            KtModifierList newModifierList = ktPsiFactory.createModifierList((String)((Object)list2));
            PsiElement psiElement = this.addBefore(newModifierList, this.getOrCreateConstructorKeyword());
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtModifierList");
            }
            list2 = ((KtModifierList)psiElement).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"addBefore(newModifierLis\u2026erList).annotationEntries");
            Object object = CollectionsKt.first(list2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            val newMod\u2026Entries.first()\n        }");
            ktAnnotationEntry = (KtAnnotationEntry)object;
        }
        return ktAnnotationEntry;
    }
}

