/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.vfs.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.rubygrapefruit.platform.internal.jni.InotifyInstanceLimitTooLowException;
import net.rubygrapefruit.platform.internal.jni.InotifyWatchesLimitTooLowException;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.vfs.impl.AbstractVirtualFileSystem;
import org.gradle.internal.vfs.impl.VfsRootReference;
import org.gradle.internal.watch.WatchingNotSupportedException;
import org.gradle.internal.watch.registry.FileWatcherRegistry;
import org.gradle.internal.watch.registry.FileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.SnapshotCollectingDiffListener;
import org.gradle.internal.watch.registry.impl.DaemonDocumentationIndex;
import org.gradle.internal.watch.vfs.BuildFinishedFileSystemWatchingBuildOperationType;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.gradle.internal.watch.vfs.BuildStartedFileSystemWatchingBuildOperationType;
import org.gradle.internal.watch.vfs.FileSystemWatchingStatistics;
import org.gradle.internal.watch.vfs.VfsLogging;
import org.gradle.internal.watch.vfs.WatchLogging;
import org.gradle.internal.watch.vfs.WatchMode;
import org.gradle.internal.watch.vfs.WatchableFileSystemDetector;
import org.gradle.internal.watch.vfs.impl.DefaultFileSystemWatchingStatistics;
import org.gradle.internal.watch.vfs.impl.LocationsWrittenByCurrentBuild;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchingVirtualFileSystem
extends AbstractVirtualFileSystem
implements BuildLifecycleAwareVirtualFileSystem,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchingVirtualFileSystem.class);
    private static final String FILE_WATCHING_ERROR_MESSAGE_DURING_BUILD = "Unable to watch the file system for changes";
    private static final String FILE_WATCHING_ERROR_MESSAGE_AT_END_OF_BUILD = "Gradle was unable to watch the file system for changes";
    private final FileWatcherRegistryFactory watcherRegistryFactory;
    private final DaemonDocumentationIndex daemonDocumentationIndex;
    private final LocationsWrittenByCurrentBuild locationsWrittenByCurrentBuild;
    private final Set<File> watchableHierarchies = new HashSet<File>();
    private final WatchableFileSystemDetector watchableFileSystemDetector;
    private FileWatcherRegistry watchRegistry;
    private Exception reasonForNotWatchingFiles;

    public WatchingVirtualFileSystem(FileWatcherRegistryFactory watcherRegistryFactory, VfsRootReference rootReference, DaemonDocumentationIndex daemonDocumentationIndex, LocationsWrittenByCurrentBuild locationsWrittenByCurrentBuild, WatchableFileSystemDetector watchableFileSystemDetector) {
        super(rootReference);
        this.watcherRegistryFactory = watcherRegistryFactory;
        this.daemonDocumentationIndex = daemonDocumentationIndex;
        this.locationsWrittenByCurrentBuild = locationsWrittenByCurrentBuild;
        this.watchableFileSystemDetector = watchableFileSystemDetector;
    }

    protected SnapshotHierarchy updateNotifyingListeners(AbstractVirtualFileSystem.UpdateFunction updateFunction) {
        if (this.watchRegistry == null) {
            return updateFunction.update(SnapshotHierarchy.NodeDiffListener.NOOP);
        }
        SnapshotCollectingDiffListener diffListener = new SnapshotCollectingDiffListener();
        SnapshotHierarchy newRoot = updateFunction.update((SnapshotHierarchy.NodeDiffListener)diffListener);
        return this.withWatcherChangeErrorHandling(newRoot, () -> diffListener.publishSnapshotDiff((removedSnapshots, addedSnapshots) -> this.watchRegistry.virtualFileSystemContentsChanged(removedSnapshots, addedSnapshots, newRoot)));
    }

    @Override
    public boolean afterBuildStarted(final WatchMode watchMode, final VfsLogging vfsLogging, final WatchLogging watchLogging, BuildOperationRunner buildOperationRunner) {
        this.reasonForNotWatchingFiles = null;
        this.rootReference.update(currentRoot -> (SnapshotHierarchy)buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<SnapshotHierarchy>(){

            public SnapshotHierarchy call(BuildOperationContext context) {
                if (watchMode.isEnabled()) {
                    DefaultFileSystemWatchingStatistics statisticsSinceLastBuild;
                    SnapshotHierarchy newRoot;
                    if (WatchingVirtualFileSystem.this.watchRegistry == null) {
                        context.setStatus("Starting file system watching");
                        WatchingVirtualFileSystem.this.startWatching(currentRoot);
                        newRoot = currentRoot.empty();
                        statisticsSinceLastBuild = null;
                    } else {
                        FileWatcherRegistry.FileWatchingStatistics statistics = WatchingVirtualFileSystem.this.watchRegistry.getAndResetStatistics();
                        newRoot = WatchingVirtualFileSystem.this.hasDroppedStateBecauseOfErrorsReceivedWhileWatching(statistics) ? WatchingVirtualFileSystem.this.stopWatchingAndInvalidateHierarchyAfterError(currentRoot) : WatchingVirtualFileSystem.this.watchRegistry.buildStarted(currentRoot);
                        statisticsSinceLastBuild = new DefaultFileSystemWatchingStatistics(statistics, newRoot);
                        if (vfsLogging == VfsLogging.VERBOSE) {
                            LOGGER.warn("Received {} file system events since last build while watching {} hierarchies", (Object)statisticsSinceLastBuild.getNumberOfReceivedEvents(), (Object)statisticsSinceLastBuild.getNumberOfWatchedHierarchies());
                            LOGGER.warn("Virtual file system retained information about {} files, {} directories and {} missing files since last build", new Object[]{statisticsSinceLastBuild.getRetainedRegularFiles(), statisticsSinceLastBuild.getRetainedDirectories(), statisticsSinceLastBuild.getRetainedMissingFiles()});
                        }
                    }
                    if (WatchingVirtualFileSystem.this.watchRegistry != null) {
                        WatchingVirtualFileSystem.this.watchRegistry.setDebugLoggingEnabled(watchLogging == WatchLogging.DEBUG);
                    }
                    context.setResult((Object)new BuildStartedFileSystemWatchingBuildOperationType.Result(){

                        @Override
                        public boolean isWatchingEnabled() {
                            return true;
                        }

                        @Override
                        public boolean isStartedWatching() {
                            return statisticsSinceLastBuild == null;
                        }

                        @Override
                        public FileSystemWatchingStatistics getStatistics() {
                            return statisticsSinceLastBuild;
                        }
                    });
                    return newRoot;
                }
                context.setResult((Object)BuildStartedFileSystemWatchingBuildOperationType.Result.WATCHING_DISABLED);
                return WatchingVirtualFileSystem.this.stopWatchingAndInvalidateHierarchy(currentRoot);
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Build started for file system watching").details((Object)BuildStartedFileSystemWatchingBuildOperationType.Details.INSTANCE);
            }
        }));
        return this.watchRegistry != null;
    }

    @Override
    public void registerWatchableHierarchy(File watchableHierarchy) {
        this.rootReference.update(currentRoot -> {
            if (this.watchRegistry == null) {
                this.watchableHierarchies.add(watchableHierarchy);
                return currentRoot;
            }
            return this.withWatcherChangeErrorHandling((SnapshotHierarchy)currentRoot, () -> this.watchRegistry.registerWatchableHierarchy(watchableHierarchy, (SnapshotHierarchy)currentRoot));
        });
    }

    @Override
    public void beforeBuildFinished(final WatchMode watchMode, final VfsLogging vfsLogging, WatchLogging watchLogging, BuildOperationRunner buildOperationRunner, final int maximumNumberOfWatchedHierarchies) {
        this.rootReference.update(currentRoot -> (SnapshotHierarchy)buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<SnapshotHierarchy>(){

            public SnapshotHierarchy call(BuildOperationContext context) {
                WatchingVirtualFileSystem.this.watchableHierarchies.clear();
                if (watchMode.isEnabled()) {
                    SnapshotHierarchy newRoot;
                    DefaultFileSystemWatchingStatistics statisticsDuringBuild;
                    if (WatchingVirtualFileSystem.this.reasonForNotWatchingFiles != null) {
                        WatchingVirtualFileSystem.this.logWatchingError(WatchingVirtualFileSystem.this.reasonForNotWatchingFiles, WatchingVirtualFileSystem.FILE_WATCHING_ERROR_MESSAGE_AT_END_OF_BUILD);
                        WatchingVirtualFileSystem.this.reasonForNotWatchingFiles = null;
                    }
                    if (WatchingVirtualFileSystem.this.watchRegistry == null) {
                        statisticsDuringBuild = null;
                        newRoot = currentRoot.empty();
                    } else {
                        FileWatcherRegistry.FileWatchingStatistics statistics = WatchingVirtualFileSystem.this.watchRegistry.getAndResetStatistics();
                        newRoot = WatchingVirtualFileSystem.this.hasDroppedStateBecauseOfErrorsReceivedWhileWatching(statistics) ? WatchingVirtualFileSystem.this.stopWatchingAndInvalidateHierarchyAfterError(currentRoot) : WatchingVirtualFileSystem.this.withWatcherChangeErrorHandling(currentRoot, () -> WatchingVirtualFileSystem.this.watchRegistry.buildFinished(currentRoot, watchMode, maximumNumberOfWatchedHierarchies));
                        statisticsDuringBuild = new DefaultFileSystemWatchingStatistics(statistics, newRoot);
                        if (vfsLogging == VfsLogging.VERBOSE) {
                            LOGGER.warn("Received {} file system events during the current build while watching {} hierarchies", (Object)statisticsDuringBuild.getNumberOfReceivedEvents(), (Object)statisticsDuringBuild.getNumberOfWatchedHierarchies());
                            LOGGER.warn("Virtual file system retains information about {} files, {} directories and {} missing files until next build", new Object[]{statisticsDuringBuild.getRetainedRegularFiles(), statisticsDuringBuild.getRetainedDirectories(), statisticsDuringBuild.getRetainedMissingFiles()});
                        }
                    }
                    final boolean stoppedWatchingDuringTheBuild = WatchingVirtualFileSystem.this.watchRegistry == null;
                    context.setResult((Object)new BuildFinishedFileSystemWatchingBuildOperationType.Result(){

                        @Override
                        public boolean isWatchingEnabled() {
                            return true;
                        }

                        @Override
                        public boolean isStoppedWatchingDuringTheBuild() {
                            return stoppedWatchingDuringTheBuild;
                        }

                        @Override
                        public FileSystemWatchingStatistics getStatistics() {
                            return statisticsDuringBuild;
                        }
                    });
                    return newRoot;
                }
                context.setResult((Object)BuildFinishedFileSystemWatchingBuildOperationType.Result.WATCHING_DISABLED);
                return currentRoot.empty();
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Build finished for file system watching").details((Object)BuildFinishedFileSystemWatchingBuildOperationType.Details.INSTANCE);
            }
        }));
    }

    private void startWatching(SnapshotHierarchy currentRoot) {
        try {
            this.watchRegistry = this.watcherRegistryFactory.createFileWatcherRegistry(new FileWatcherRegistry.ChangeHandler(){

                @Override
                public void handleChange(FileWatcherRegistry.Type type, Path path) {
                    try {
                        String absolutePath = path.toString();
                        if (!WatchingVirtualFileSystem.this.locationsWrittenByCurrentBuild.wasLocationWritten(absolutePath)) {
                            WatchingVirtualFileSystem.this.rootReference.update(root -> WatchingVirtualFileSystem.this.updateNotifyingListeners(diffListener -> root.invalidate(absolutePath, (SnapshotHierarchy.NodeDiffListener)new VfsChangeLoggingNodeDiffListener(type, path, diffListener))));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while processing file events", (Throwable)e);
                        WatchingVirtualFileSystem.this.stopWatchingAndInvalidateHierarchyAfterError();
                    }
                }

                @Override
                public void stopWatchingAfterError() {
                    WatchingVirtualFileSystem.this.stopWatchingAndInvalidateHierarchyAfterError();
                }
            });
            this.watchableHierarchies.forEach(watchableHierarchy -> this.watchRegistry.registerWatchableHierarchy((File)watchableHierarchy, currentRoot));
            this.watchableHierarchies.clear();
        }
        catch (Exception ex) {
            this.logWatchingError(ex, FILE_WATCHING_ERROR_MESSAGE_DURING_BUILD);
            this.closeUnderLock();
        }
    }

    private SnapshotHierarchy withWatcherChangeErrorHandling(SnapshotHierarchy currentRoot, Runnable runnable) {
        return this.withWatcherChangeErrorHandling(currentRoot, () -> {
            runnable.run();
            return currentRoot;
        });
    }

    private SnapshotHierarchy withWatcherChangeErrorHandling(SnapshotHierarchy currentRoot, Supplier<SnapshotHierarchy> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception ex) {
            this.logWatchingError(ex, FILE_WATCHING_ERROR_MESSAGE_DURING_BUILD);
            return this.stopWatchingAndInvalidateHierarchyAfterError(currentRoot);
        }
    }

    private void logWatchingError(Exception exception, String fileWatchingErrorMessage) {
        if (exception instanceof InotifyInstanceLimitTooLowException) {
            LOGGER.warn("{}. The inotify instance limit is too low. See {} for more details.", (Object)fileWatchingErrorMessage, (Object)this.daemonDocumentationIndex.getLinkToSection("sec:inotify_instances_limit"));
        } else if (exception instanceof InotifyWatchesLimitTooLowException) {
            LOGGER.warn("{}. The inotify watches limit is too low.", (Object)fileWatchingErrorMessage);
        } else if (exception instanceof WatchingNotSupportedException) {
            LOGGER.warn("{}. {}.", (Object)fileWatchingErrorMessage, (Object)exception.getMessage());
        } else {
            LOGGER.warn(fileWatchingErrorMessage, (Throwable)exception);
        }
        this.reasonForNotWatchingFiles = exception;
    }

    private void stopWatchingAndInvalidateHierarchyAfterError() {
        this.rootReference.update(this::stopWatchingAndInvalidateHierarchyAfterError);
    }

    private SnapshotHierarchy stopWatchingAndInvalidateHierarchyAfterError(SnapshotHierarchy currentRoot) {
        LOGGER.error("Stopping file watching and invalidating VFS after an error happened");
        return this.stopWatchingAndInvalidateHierarchy(currentRoot);
    }

    private SnapshotHierarchy stopWatchingAndInvalidateHierarchy(SnapshotHierarchy currentRoot) {
        if (this.watchRegistry != null) {
            try {
                FileWatcherRegistry toBeClosed = this.watchRegistry;
                this.watchRegistry = null;
                toBeClosed.close();
            }
            catch (IOException ex) {
                LOGGER.error("Unable to close file watcher registry", (Throwable)ex);
            }
        }
        return currentRoot.empty();
    }

    private boolean hasDroppedStateBecauseOfErrorsReceivedWhileWatching(FileWatcherRegistry.FileWatchingStatistics statistics) {
        if (statistics.isUnknownEventEncountered()) {
            LOGGER.warn("Dropped VFS state due to lost state");
            return true;
        }
        if (statistics.getErrorWhileReceivingFileChanges().isPresent()) {
            LOGGER.warn("Dropped VFS state due to error while receiving file changes", statistics.getErrorWhileReceivingFileChanges().get());
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.rootReference.update(currentRoot -> {
            this.closeUnderLock();
            return currentRoot.empty();
        });
    }

    private void closeUnderLock() {
        if (this.watchRegistry != null) {
            try {
                this.watchRegistry.close();
            }
            catch (IOException ex) {
                LOGGER.error("Couldn't close watch service", (Throwable)ex);
            }
            finally {
                this.watchRegistry = null;
            }
        }
    }

    private static class VfsChangeLoggingNodeDiffListener
    implements SnapshotHierarchy.NodeDiffListener {
        private final FileWatcherRegistry.Type type;
        private final Path path;
        private final SnapshotHierarchy.NodeDiffListener delegate;
        private boolean alreadyLogged;

        public VfsChangeLoggingNodeDiffListener(FileWatcherRegistry.Type type, Path path, SnapshotHierarchy.NodeDiffListener delegate) {
            this.type = type;
            this.path = path;
            this.delegate = delegate;
        }

        public void nodeRemoved(FileSystemNode node) {
            this.maybeLogVfsChangeMessage();
            this.delegate.nodeRemoved(node);
        }

        public void nodeAdded(FileSystemNode node) {
            this.maybeLogVfsChangeMessage();
            this.delegate.nodeAdded(node);
        }

        private void maybeLogVfsChangeMessage() {
            if (!this.alreadyLogged) {
                this.alreadyLogged = true;
                LOGGER.debug("Handling VFS change {} {}", (Object)this.type, (Object)this.path);
            }
        }
    }
}

