/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.serialization;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.IrFileSerializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFlags;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrConstructorCall;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrVariable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.serialization.IrCarrierSerializer;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.serialization.deserialization.ProtoEnumFlags;
import org.jetbrains.kotlin.serialization.deserialization.ProtoEnumFlagsUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u001cH\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020,H\u0016J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u000201H\u0016J\u0010\u00102\u001a\u0002032\u0006\u0010\u000f\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u000206H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/ir/serialization/IrCarrierSerializerImpl;", "Lorg/jetbrains/kotlin/ir/serialization/IrCarrierSerializer;", "fileSerializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "bodyIndex", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;Lkotlin/jvm/functions/Function1;)V", "getBodyIndex", "()Lkotlin/jvm/functions/Function1;", "getFileSerializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "serializeAnnotation", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrConstructorCall;", "value", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "serializeBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "serializeBody", "serializeClass", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "serializeExpressionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "serializeField", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "serializeIsExternalClass", "", "serializeIsExternalField", "serializeIsExternalFunction", "serializeIsExternalProperty", "serializeModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "serializeOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "serializeParentSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "serializePropertySymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "serializeSimpleFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "serializeSimpleFunctionSymbol", "serializeSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "serializeType", "serializeTypeParameter", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "serializeValueParameter", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "serializeVariable", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrVariable;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "serializeVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "ir.tree.persistent"})
public final class IrCarrierSerializerImpl
extends IrCarrierSerializer {
    @NotNull
    private final IrFileSerializer fileSerializer;
    @NotNull
    private final Function1<IrBody, Integer> bodyIndex;

    public IrCarrierSerializerImpl(@NotNull IrFileSerializer fileSerializer, @NotNull Function1<? super IrBody, Integer> bodyIndex) {
        Intrinsics.checkNotNullParameter((Object)fileSerializer, (String)"fileSerializer");
        Intrinsics.checkNotNullParameter(bodyIndex, (String)"bodyIndex");
        this.fileSerializer = fileSerializer;
        this.bodyIndex = bodyIndex;
    }

    @NotNull
    public final IrFileSerializer getFileSerializer() {
        return this.fileSerializer;
    }

    @NotNull
    public final Function1<IrBody, Integer> getBodyIndex() {
        return this.bodyIndex;
    }

    @Override
    public long serializeParentSymbol(@NotNull IrSymbol value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value2);
    }

    @Override
    public int serializeOrigin(@NotNull IrDeclarationOrigin value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeIrDeclarationOrigin(value2);
    }

    @Override
    @NotNull
    public IrConstructorCall serializeAnnotation(@NotNull org.jetbrains.kotlin.ir.expressions.IrConstructorCall value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeConstructorCall(value2);
    }

    @Override
    public int serializeBody(@NotNull IrBody value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return ((Number)this.bodyIndex.invoke((Object)value2)).intValue();
    }

    @Override
    public int serializeBlockBody(@NotNull IrBlockBody value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.serializeBody(value2);
    }

    @Override
    public int serializeExpressionBody(@NotNull IrExpressionBody value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.serializeBody(value2);
    }

    @Override
    public long serializeValueParameter(@NotNull IrValueParameterSymbol value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value2);
    }

    @Override
    public long serializeTypeParameter(@NotNull IrTypeParameterSymbol value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value2);
    }

    @Override
    public int serializeSuperType(@NotNull IrType value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeIrType(value2);
    }

    @Override
    public int serializeType(@NotNull IrType value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeIrType(value2);
    }

    @Override
    public long serializeClass(@NotNull IrClassSymbol value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value2);
    }

    @Override
    public long serializePropertySymbol(@NotNull IrPropertySymbol value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value2);
    }

    @Override
    public long serializeSimpleFunction(@NotNull IrSimpleFunctionSymbol value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value2);
    }

    @Override
    public long serializeSimpleFunctionSymbol(@NotNull IrSimpleFunctionSymbol value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value2);
    }

    @Override
    public long serializeField(@NotNull IrFieldSymbol value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeIrSymbol(value2);
    }

    @Override
    @NotNull
    public IrVariable serializeVariable(@NotNull org.jetbrains.kotlin.ir.declarations.IrVariable value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.fileSerializer.serializeIrVariable(value2);
    }

    @Override
    public long serializeVisibility(@NotNull DescriptorVisibility value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return Flags.VISIBILITY.toFlags(ProtoEnumFlagsUtilsKt.descriptorVisibility(ProtoEnumFlags.INSTANCE, value2));
    }

    @Override
    public long serializeModality(@NotNull Modality value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        return Flags.MODALITY.toFlags(ProtoEnumFlags.INSTANCE.modality(value2));
    }

    @Override
    public long serializeIsExternalClass(boolean value2) {
        return IrFlags.IS_EXTERNAL_CLASS.toFlags(value2);
    }

    @Override
    public long serializeIsExternalField(boolean value2) {
        return IrFlags.IS_EXTERNAL_FIELD.toFlags(value2);
    }

    @Override
    public long serializeIsExternalFunction(boolean value2) {
        return IrFlags.IS_EXTERNAL_FUNCTION.toFlags(value2);
    }

    @Override
    public long serializeIsExternalProperty(boolean value2) {
        return IrFlags.IS_EXTERNAL_PROPERTY.toFlags(value2);
    }
}

