/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.PropertyLazyInitLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.PersistentApiKt;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrElementBase;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\fH\u0002\u001a\u001c\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\f\u0010\u001e\u001a\u00020\u0018*\u00020\u0005H\u0002\u001a\f\u0010\u001f\u001a\u00020\t*\u00020\u0005H\u0002\u001a\f\u0010 \u001a\u00020\t*\u00020\u0004H\u0002\u001a)\u0010!\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0019\u0010\"\u001a\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00040#\u00a2\u0006\u0002\b$H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"compatibleOrigins", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "correspondingProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getCorrespondingProperty", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "allFieldsInFilePure", "", "fieldToInitializer", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "calculateFieldToExpression", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "declarations", "createIrGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "field", "createIrSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "expression", "addInitialization", "", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "initCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "assertCompatibleDeclaration", "isCompatibleDeclaration", "isForLazyInit", "propertyWithPersistentSafe", "transform", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "backend.js"})
public final class PropertyLazyInitLoweringKt {
    @NotNull
    private static final List<IrDeclarationOriginImpl> compatibleOrigins;

    private static final void addInitialization(IrBody $this$addInitialization, IrCall initCall, IrSimpleFunction container2) {
        IrBody irBody = $this$addInitialization;
        if (irBody instanceof IrExpressionBody) {
            Object[] objectArray = new IrExpression[]{initCall, ((IrExpressionBody)$this$addInitialization).getExpression()};
            ((IrExpressionBody)$this$addInitialization).setExpression(JsIrBuilder.INSTANCE.buildComposite(container2.getReturnType(), CollectionsKt.listOf((Object[])objectArray)));
        } else if (irBody instanceof IrBlockBody) {
            ((IrBlockBody)$this$addInitialization).getStatements().add(0, initCall);
        }
    }

    private static final IrGetField createIrGetField(IrField field) {
        return JsIrBuilder.buildGetField$default(JsIrBuilder.INSTANCE, (IrFieldSymbol)field.getSymbol(), null, null, null, 12, null);
    }

    private static final IrSetField createIrSetField(IrField field, IrExpression expression2) {
        return JsIrBuilder.buildSetField$default(JsIrBuilder.INSTANCE, (IrFieldSymbol)field.getSymbol(), null, expression2, expression2.getType(), null, 16, null);
    }

    private static final boolean allFieldsInFilePure(Collection<? extends IrExpression> fieldToInitializer) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = fieldToInitializer;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IrExpression it = (IrExpression)element$iv;
                    boolean bl2 = false;
                    if (MiscKt.isPure$default(it, true, false, 2, null)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final Map<IrField, IrExpression> calculateFieldToExpression(Collection<? extends IrDeclaration> declarations2) {
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)declarations2), (Function1)calculateFieldToExpression.1.INSTANCE), (Function1)calculateFieldToExpression.2.INSTANCE)), (Function1)calculateFieldToExpression.3.INSTANCE)), (Function1)calculateFieldToExpression.4.INSTANCE), (Function1)calculateFieldToExpression.5.INSTANCE), (Function1)calculateFieldToExpression.6.INSTANCE));
    }

    private static final boolean isForLazyInit(IrProperty $this$isForLazyInit) {
        return IrUtilsKt.isTopLevel($this$isForLazyInit) && !$this$isForLazyInit.isConst();
    }

    private static final IrProperty getCorrespondingProperty(IrDeclaration $this$correspondingProperty) {
        IrProperty irProperty2;
        if (!($this$correspondingProperty instanceof IrSimpleFunction || $this$correspondingProperty instanceof IrField || $this$correspondingProperty instanceof IrProperty)) {
            return null;
        }
        IrDeclaration irDeclaration2 = $this$correspondingProperty;
        if (irDeclaration2 instanceof IrProperty) {
            irProperty2 = (IrProperty)$this$correspondingProperty;
        } else if (irDeclaration2 instanceof IrSimpleFunction) {
            irProperty2 = PropertyLazyInitLoweringKt.propertyWithPersistentSafe($this$correspondingProperty, (Function1<? super IrDeclaration, ? extends IrProperty>)((Function1)new Function1<IrDeclaration, IrProperty>($this$correspondingProperty){
                final /* synthetic */ IrDeclaration $this_correspondingProperty;
                {
                    this.$this_correspondingProperty = $receiver;
                    super(1);
                }

                @Nullable
                public final IrProperty invoke(@NotNull IrDeclaration irDeclaration2) {
                    Intrinsics.checkNotNullParameter((Object)irDeclaration2, (String)"<this>");
                    IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)this.$this_correspondingProperty).getCorrespondingPropertySymbol();
                    return irPropertySymbol == null ? null : (IrProperty)irPropertySymbol.getOwner();
                }
            }));
        } else if (irDeclaration2 instanceof IrField) {
            irProperty2 = PropertyLazyInitLoweringKt.propertyWithPersistentSafe($this$correspondingProperty, (Function1<? super IrDeclaration, ? extends IrProperty>)((Function1)new Function1<IrDeclaration, IrProperty>($this$correspondingProperty){
                final /* synthetic */ IrDeclaration $this_correspondingProperty;
                {
                    this.$this_correspondingProperty = $receiver;
                    super(1);
                }

                @Nullable
                public final IrProperty invoke(@NotNull IrDeclaration irDeclaration2) {
                    Intrinsics.checkNotNullParameter((Object)irDeclaration2, (String)"<this>");
                    IrPropertySymbol irPropertySymbol = ((IrField)this.$this_correspondingProperty).getCorrespondingPropertySymbol();
                    return irPropertySymbol == null ? null : (IrProperty)irPropertySymbol.getOwner();
                }
            }));
        } else {
            String string2 = "Can be only IrProperty, IrSimpleFunction or IrField";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return irProperty2;
    }

    private static final IrProperty propertyWithPersistentSafe(IrDeclaration $this$propertyWithPersistentSafe, Function1<? super IrDeclaration, ? extends IrProperty> transform2) {
        int n;
        PersistentIrElementBase persistentIrElementBase = $this$propertyWithPersistentSafe instanceof PersistentIrElementBase ? (PersistentIrElementBase)((Object)$this$propertyWithPersistentSafe) : null;
        return (persistentIrElementBase == null ? 0 : (n = persistentIrElementBase.getCreatedOn())) <= PersistentApiKt.getStageController().getCurrentStage() ? (IrProperty)transform2.invoke((Object)$this$propertyWithPersistentSafe) : null;
    }

    private static final boolean isCompatibleDeclaration(IrDeclaration $this$isCompatibleDeclaration) {
        return CollectionsKt.contains((Iterable)compatibleOrigins, (Object)$this$isCompatibleDeclaration.getOrigin());
    }

    private static final void assertCompatibleDeclaration(IrDeclaration $this$assertCompatibleDeclaration) {
        boolean bl;
        int n;
        int n2;
        Boolean bl2;
        PersistentIrElementBase persistentIrElementBase;
        PersistentIrElementBase persistentIrElementBase2 = persistentIrElementBase = $this$assertCompatibleDeclaration instanceof PersistentIrElementBase ? (PersistentIrElementBase)((Object)$this$assertCompatibleDeclaration) : null;
        if (persistentIrElementBase == null) {
            bl2 = null;
        } else {
            n = n2 = persistentIrElementBase.getCreatedOn();
            bl = false;
            boolean bl3 = false;
            int it = n;
            boolean bl4 = false;
            bl2 = it == 0;
        }
        boolean bl5 = !Intrinsics.areEqual(bl2, (Object)false);
        n2 = 0;
        n = 0;
        if (_Assertions.ENABLED && !bl5) {
            bl = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }

    public static final /* synthetic */ boolean access$isCompatibleDeclaration(IrDeclaration $receiver) {
        return PropertyLazyInitLoweringKt.isCompatibleDeclaration($receiver);
    }

    public static final /* synthetic */ void access$assertCompatibleDeclaration(IrDeclaration $receiver) {
        PropertyLazyInitLoweringKt.assertCompatibleDeclaration($receiver);
    }

    public static final /* synthetic */ void access$addInitialization(IrBody $receiver, IrCall initCall, IrSimpleFunction container2) {
        PropertyLazyInitLoweringKt.addInitialization($receiver, initCall, container2);
    }

    public static final /* synthetic */ IrProperty access$getCorrespondingProperty(IrDeclaration $receiver) {
        return PropertyLazyInitLoweringKt.getCorrespondingProperty($receiver);
    }

    public static final /* synthetic */ Map access$calculateFieldToExpression(Collection declarations2) {
        return PropertyLazyInitLoweringKt.calculateFieldToExpression(declarations2);
    }

    public static final /* synthetic */ boolean access$allFieldsInFilePure(Collection fieldToInitializer) {
        return PropertyLazyInitLoweringKt.allFieldsInFilePure(fieldToInitializer);
    }

    public static final /* synthetic */ IrSetField access$createIrSetField(IrField field, IrExpression expression2) {
        return PropertyLazyInitLoweringKt.createIrSetField(field, expression2);
    }

    public static final /* synthetic */ IrGetField access$createIrGetField(IrField field) {
        return PropertyLazyInitLoweringKt.createIrGetField(field);
    }

    public static final /* synthetic */ boolean access$isForLazyInit(IrProperty $receiver) {
        return PropertyLazyInitLoweringKt.isForLazyInit($receiver);
    }

    static {
        Object[] objectArray = new IrDeclarationOriginImpl[]{IrDeclarationOrigin.DEFINED.INSTANCE, IrDeclarationOrigin.DELEGATED_PROPERTY_ACCESSOR.INSTANCE, IrDeclarationOrigin.PROPERTY_DELEGATE.INSTANCE, IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE, IrDeclarationOrigin.PROPERTY_BACKING_FIELD.INSTANCE};
        compatibleOrigins = CollectionsKt.listOf((Object[])objectArray);
    }
}

