/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import com.google.common.base.Preconditions;
import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskReference;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.util.Path;

public class IncludedRootBuild
implements IncludedBuild {
    private final CompositeBuildParticipantBuildState rootBuild;

    public IncludedRootBuild(CompositeBuildParticipantBuildState rootBuild) {
        this.rootBuild = rootBuild;
    }

    public CompositeBuildParticipantBuildState getRootBuild() {
        return this.rootBuild;
    }

    public String getName() {
        return this.rootBuild.getLoadedSettings().getRootProject().getName();
    }

    public File getProjectDir() {
        return this.rootBuild.getBuildRootDir();
    }

    public TaskReference task(String path) {
        Preconditions.checkArgument((boolean)path.startsWith(":"), (String)"Task path '%s' is not a qualified task path (e.g. ':task' or ':project:task').", (Object)path);
        return new IncludedRootBuildTaskReference(this.rootBuild, path);
    }

    private static class IncludedRootBuildTaskReference
    implements TaskReference,
    TaskDependencyContainer {
        private final String taskPath;
        private final CompositeBuildParticipantBuildState rootBuildState;

        public IncludedRootBuildTaskReference(CompositeBuildParticipantBuildState rootBuildState, String taskPath) {
            this.rootBuildState = rootBuildState;
            this.taskPath = taskPath;
        }

        public String getName() {
            return Path.path((String)this.taskPath).getName();
        }

        public BuildIdentifier getBuildIdentifier() {
            return this.rootBuildState.getBuildIdentifier();
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add((Object)this.resolveTask());
        }

        private Task resolveTask() {
            return this.rootBuildState.getBuild().getRootProject().getTasks().getByPath(this.taskPath);
        }
    }
}

