/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.lower.WasmCallableReferenceLoweringKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0016H\u0016J\f\u0010\u0017\u001a\u00020\n*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmCallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "ignoredFunctionReferences", "", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "isIgnored", "", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;)Z", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "visitFunctionReference", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "isSuspendCallableReference", "FunctionReferenceBuilder", "backend.wasm"})
public final class WasmCallableReferenceLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final Set<IrFunctionReference> ignoredFunctionReferences;

    public WasmCallableReferenceLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        boolean bl = false;
        this.ignoredFunctionReferences = new LinkedHashSet();
    }

    private final boolean isIgnored(IrFunctionReference $this$isIgnored) {
        return (!IrTypeUtilsKt.isFunctionOrKFunction($this$isIgnored.getType()) || this.ignoredFunctionReferences.contains($this$isIgnored)) && !this.isSuspendCallableReference($this$isIgnored);
    }

    private final boolean isSuspendCallableReference(IrFunctionReference $this$isSuspendCallableReference) {
        return org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend($this$isSuspendCallableReference) && $this$isSuspendCallableReference.getOrigin() == null;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!WasmCallableReferenceLoweringKt.isLambda(expression2.getOrigin())) {
            return super.visitBlock(expression2);
        }
        IrFunctionReference reference = (IrFunctionReference)CollectionsKt.last(expression2.getStatements());
        if (this.isIgnored(reference)) {
            return super.visitBlock(expression2);
        }
        Iterable $this$forEach$iv = CollectionsKt.dropLast(expression2.getStatements(), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement it = (IrStatement)element$iv;
            boolean bl = false;
            it.transform(this, null);
        }
        IrElementTransformerVoidKt.transformChildrenVoid(reference, this);
        return new FunctionReferenceBuilder(reference, null, 2, null).build();
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        return this.isIgnored(expression2) ? (IrExpression)expression2 : new FunctionReferenceBuilder(expression2, null, 2, null).build();
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getOperator() == IrTypeOperator.SAM_CONVERSION) {
            IrFunctionReference irFunctionReference;
            IrExpression invokable = expression2.getArgument();
            if (invokable instanceof IrFunctionReference) {
                irFunctionReference = (IrFunctionReference)invokable;
            } else if (invokable instanceof IrBlock && WasmCallableReferenceLoweringKt.isLambda(((IrBlock)invokable).getOrigin()) && CollectionsKt.last(((IrBlock)invokable).getStatements()) instanceof IrFunctionReference) {
                Iterable $this$forEach$iv = CollectionsKt.dropLast(((IrBlock)invokable).getStatements(), (int)1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrStatement it = (IrStatement)element$iv;
                    boolean bl = false;
                    it.transform(this, null);
                }
                irFunctionReference = (IrFunctionReference)CollectionsKt.last(((IrBlock)invokable).getStatements());
            } else {
                return super.visitTypeOperator(expression2);
            }
            IrFunctionReference reference = irFunctionReference;
            this.transformChildrenVoid(reference);
            return new FunctionReferenceBuilder(reference, expression2.getTypeOperand()).build();
        }
        return super.visitTypeOperator(expression2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001f\u001a\u00020\fJ\b\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0016\u0010&\u001a\u00020'*\u00020#2\b\u0010(\u001a\u0004\u0018\u00010%H\u0002J\f\u0010)\u001a\u00020'*\u00020#H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00050\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmCallableReferenceLowering$FunctionReferenceBuilder;", "", "irFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/backend/wasm/lower/WasmCallableReferenceLowering;Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "argumentTypes", "", "boundReceiver", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "functionReferenceClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "functionSuperClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getIrFunctionReference", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "isLambda", "", "parameterTypes", "getSamSuperType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "superMethod", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "typeArgumentsMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "build", "createConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "createInvokeMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "receiverVar", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "createFunctionReferenceInvokeMethod", "", "receiver", "createLambdaInvokeMethod", "backend.wasm"})
    private final class FunctionReferenceBuilder {
        @NotNull
        private final IrFunctionReference irFunctionReference;
        @Nullable
        private final IrType samSuperType;
        private final boolean isLambda;
        @NotNull
        private final IrFunction callee;
        @Nullable
        private final Pair<IrValueParameter, IrExpression> boundReceiver;
        @NotNull
        private final List<IrType> parameterTypes;
        @NotNull
        private final List<IrType> argumentTypes;
        @NotNull
        private final Map<IrTypeParameterSymbol, IrType> typeArgumentsMap;
        @NotNull
        private final IrClassSymbol functionSuperClass;
        @NotNull
        private final IrSimpleFunctionSymbol superMethod;
        @NotNull
        private final IrClass functionReferenceClass;

        /*
         * WARNING - void declaration
         */
        public FunctionReferenceBuilder(@Nullable IrFunctionReference irFunctionReference, IrType samSuperType) {
            void $this$functionReferenceClass_u24lambda_u2d3;
            void $this$functionReferenceClass_u24lambda_u2d2;
            void $this$single$iv;
            Collection<IrType> collection;
            void $this$mapTo$iv$iv;
            Sequence<IrSimpleFunctionSymbol> $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)WasmCallableReferenceLowering.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)irFunctionReference, (String)"irFunctionReference");
            this.irFunctionReference = irFunctionReference;
            this.samSuperType = samSuperType;
            this.isLambda = WasmCallableReferenceLoweringKt.isLambda(this.irFunctionReference.getOrigin());
            this.callee = ((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner();
            this.boundReceiver = (Pair)CollectionsKt.singleOrNull(IrUtilsKt.getArgumentsWithIr(this.irFunctionReference));
            Object object = ((IrSimpleType)this.irFunctionReference.getType()).getArguments();
            FunctionReferenceBuilder functionReferenceBuilder = this;
            boolean $i$f$map22 = false;
            IrClassBuilder irClassBuilder = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                IrType irType = ((IrTypeProjection)it).getType();
                collection.add(irType);
            }
            collection = (List)destination$iv$iv;
            functionReferenceBuilder.parameterTypes = collection;
            this.argumentTypes = CollectionsKt.dropLast(this.parameterTypes, (int)1);
            this.typeArgumentsMap = IrUtilsKt.getTypeSubstitutionMap(this.irFunctionReference);
            IrType $i$f$map22 = this.samSuperType;
            Sequence<IrSimpleFunctionSymbol> sequence2 = $this$map$iv = $i$f$map22 == null ? null : IrTypesKt.getClassOrNull($i$f$map22);
            this.functionSuperClass = $this$map$iv == null ? (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(this.irFunctionReference) ? WasmCallableReferenceLowering.this.context.getIr().getSymbols().suspendFunctionN(this.argumentTypes.size()) : WasmCallableReferenceLowering.this.context.getIr().getSymbols().functionN(this.argumentTypes.size())) : $this$map$iv;
            $this$map$iv = IrUtilsKt.getFunctions(this.functionSuperClass);
            functionReferenceBuilder = this;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                boolean bl3 = false;
                if (!(((IrSimpleFunction)it.getOwner()).getModality() == Modality.ABSTRACT)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            collection = single$iv;
            functionReferenceBuilder.superMethod = (IrSimpleFunctionSymbol)((Object)collection);
            IrFactory $this$buildClass$iv = WasmCallableReferenceLowering.this.context.getIrFactory();
            boolean $i$f$buildClass = false;
            irClassBuilder = new IrClassBuilder();
            boolean bl = false;
            $i$f$mapTo22 = false;
            IrClassBuilder $this$buildClass_u24lambda_u2d2$iv = irClassBuilder;
            boolean bl2 = false;
            IrClassBuilder bl3 = $this$buildClass_u24lambda_u2d2$iv;
            functionReferenceBuilder = this;
            boolean bl4 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)$this$functionReferenceClass_u24lambda_u2d2, this.getIrFunctionReference());
            Object object2 = DescriptorVisibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"LOCAL");
            $this$functionReferenceClass_u24lambda_u2d2.setVisibility((DescriptorVisibility)object2);
            object2 = SpecialNames.NO_NAME_PROVIDED;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"NO_NAME_PROVIDED");
            $this$functionReferenceClass_u24lambda_u2d2.setName((Name)object2);
            collection = Unit.INSTANCE;
            object = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u2d2$iv);
            WasmCallableReferenceLowering wasmCallableReferenceLowering = WasmCallableReferenceLowering.this;
            boolean bl5 = false;
            bl = false;
            Object $i$f$mapTo22 = object;
            boolean bl6 = false;
            IrDeclarationParent irDeclarationParent = wasmCallableReferenceLowering.getCurrentDeclarationParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent);
            $this$functionReferenceClass_u24lambda_u2d3.setParent(irDeclarationParent);
            if (this.getSamSuperType() == null) {
                irDeclarationParent = $this$functionReferenceClass_u24lambda_u2d3;
                ((IrClass)irDeclarationParent).setSuperTypes(CollectionsKt.plus((Collection)((IrClass)irDeclarationParent).getSuperTypes(), (Object)IrTypesKt.typeWith((IrClassifierSymbol)this.functionSuperClass, this.parameterTypes)));
            }
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$functionReferenceClass_u24lambda_u2d3);
            IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$functionReferenceClass_u24lambda_u2d3, this.getIrFunctionReference());
            if (this.isLambda) {
                $this$functionReferenceClass_u24lambda_u2d3.setMetadata(((IrFunctionSymbol)this.getIrFunctionReference().getSymbol()).getOwner().getMetadata());
            }
            collection = Unit.INSTANCE;
            functionReferenceBuilder.functionReferenceClass = object;
        }

        public /* synthetic */ FunctionReferenceBuilder(IrFunctionReference irFunctionReference, IrType irType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                irType = null;
            }
            this(irFunctionReference, irType);
        }

        @NotNull
        public final IrFunctionReference getIrFunctionReference() {
            return this.irFunctionReference;
        }

        @Nullable
        public final IrType getSamSuperType() {
            return this.samSuperType;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrExpression build() {
            void $this$build_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4;
            void this_$iv$iv;
            BackendContext backendContext = WasmCallableReferenceLowering.this.context;
            Object object = WasmCallableReferenceLowering.this.getCurrentScope();
            Intrinsics.checkNotNull((Object)object);
            object = LowerUtilsKt.createIrBuilder$default(backendContext, ((ScopeWithIr)object).getScope().getScopeOwnerSymbol(), 0, 0, 6, null);
            boolean bl = false;
            boolean bl2 = false;
            Object $this$build_u24lambda_u2d6 = object;
            boolean bl3 = false;
            IrBuilderWithScope $this$irBlock_u24default$iv = (IrBuilderWithScope)$this$build_u24lambda_u2d6;
            int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$build_u24lambda_u2d6_u24lambda_u2d5 = this_$iv$iv;
            boolean bl4 = false;
            IrConstructor constructor2 = this.createConstructor();
            this.createInvokeMethod(this.getSamSuperType() != null && this.boundReceiver != null ? ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$build_u24lambda_u2d6_u24lambda_u2d5, (IrExpression)this.boundReceiver.getSecond(), null, null, false, 14, null) : null);
            $this$build_u24lambda_u2d6_u24lambda_u2d5.unaryPlus(this.functionReferenceClass);
            IrConstructorCall irConstructorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$build_u24lambda_u2d6_u24lambda_u2d5, (IrConstructorSymbol)constructor2.getSymbol());
            boolean bl5 = false;
            boolean bl6 = false;
            IrConstructorCall irConstructorCall2 = irConstructorCall;
            void var21_21 = $this$build_u24lambda_u2d6_u24lambda_u2d5;
            boolean bl7 = false;
            if ($this$build_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.getValueArgumentsCount() > 0) {
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                Intrinsics.checkNotNull(pair);
                $this$build_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.putValueArgument(0, (IrExpression)pair.getSecond());
            }
            Unit unit = Unit.INSTANCE;
            var21_21.unaryPlus(irConstructorCall);
            return this_$iv$iv.doBuild();
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor() {
            void $this$createConstructor_u24lambda_u2d11_u24lambda_u2d10;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            IrConstructor irConstructor2;
            Object param;
            IrClass $this$addConstructor$iv = this.functionReferenceClass;
            boolean $i$f$addConstructor = false;
            IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            boolean bl = false;
            boolean bl2 = false;
            Object $this$buildConstructor_u24lambda_u2d22$iv$iv = irFunctionBuilder;
            int n2 = 0;
            IrFunctionBuilder $this$addConstructor_u24lambda_u2d23$iv2 = $this$buildConstructor_u24lambda_u2d22$iv$iv;
            boolean bl3 = false;
            IrFunctionBuilder $this$createConstructor_u24lambda_u2d7 = $this$addConstructor_u24lambda_u2d23$iv2;
            boolean bl4 = false;
            $this$createConstructor_u24lambda_u2d7.setReturnType(IrUtilsKt.getDefaultType(this.functionReferenceClass));
            $this$createConstructor_u24lambda_u2d7.setPrimary(true);
            $this$addConstructor_u24lambda_u2d23$iv2.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
            IrConstructor irConstructor3 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2d22$iv$iv);
            boolean bl5 = false;
            boolean bl6 = false;
            IrConstructor constructor$iv = irConstructor3;
            boolean bl7 = false;
            $this$addConstructor$iv.getDeclarations().add(constructor$iv);
            constructor$iv.setParent($this$addConstructor$iv);
            IrConstructor irConstructor4 = irConstructor3;
            WasmCallableReferenceLowering wasmCallableReferenceLowering = WasmCallableReferenceLowering.this;
            boolean bl8 = false;
            bl5 = false;
            IrConstructor $this$createConstructor_u24lambda_u2d11 = irConstructor4;
            boolean bl9 = false;
            if (this.getSamSuperType() == null && (bl7 = this.boundReceiver) != null && ($this$buildConstructor_u24lambda_u2d22$iv$iv = (IrValueParameter)bl7.getFirst()) != null) {
                Object n2 = $this$buildConstructor_u24lambda_u2d22$iv$iv;
                boolean $this$addConstructor_u24lambda_u2d23$iv2 = false;
                bl3 = false;
                param = n2;
                boolean bl10 = false;
                irConstructor2 = $this$createConstructor_u24lambda_u2d11;
                irConstructor2.setValueParameters(CollectionsKt.plus((Collection)irConstructor2.getValueParameters(), (Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)param, $this$createConstructor_u24lambda_u2d11, null, 0, 0, 0, null, null, IrTypeUtilsKt.substitute(((IrValueDeclaration)param).getType(), this.typeArgumentsMap), null, null, false, false, false, 8058, null)));
            }
            IrConstructor constructor2 = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)wasmCallableReferenceLowering.context.getIrBuiltIns().getAnyClass().getOwner()));
            $this$buildConstructor_u24lambda_u2d22$iv$iv = LowerUtilsKt.createIrBuilder$default(wasmCallableReferenceLowering.context, $this$createConstructor_u24lambda_u2d11.getSymbol(), 0, 0, 6, null);
            n2 = $this$createConstructor_u24lambda_u2d11.getStartOffset();
            int endOffset$iv = $this$createConstructor_u24lambda_u2d11.getEndOffset();
            boolean $i$f$irBlockBody = false;
            param = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            irConstructor2 = this_$iv$iv;
            IrConstructor irConstructor5 = $this$createConstructor_u24lambda_u2d11;
            boolean bl11 = false;
            IrDelegatingConstructorCall irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$createConstructor_u24lambda_u2d11_u24lambda_u2d10, constructor2);
            boolean bl12 = false;
            boolean bl13 = false;
            IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall;
            void var21_32 = $this$createConstructor_u24lambda_u2d11_u24lambda_u2d10;
            boolean bl14 = false;
            Unit unit = Unit.INSTANCE;
            var21_32.unaryPlus(irDelegatingConstructorCall);
            $this$createConstructor_u24lambda_u2d11_u24lambda_u2d10.unaryPlus(new IrInstanceInitializerCallImpl($this$createConstructor_u24lambda_u2d11_u24lambda_u2d10.getStartOffset(), $this$createConstructor_u24lambda_u2d11_u24lambda_u2d10.getEndOffset(), (IrClassSymbol)this.functionReferenceClass.getSymbol(), $this$createConstructor_u24lambda_u2d11_u24lambda_u2d10.getContext().getIrBuiltIns().getUnitType()));
            Unit unit2 = Unit.INSTANCE;
            irConstructor5.setBody(this_$iv$iv.doBuild());
            return irConstructor4;
        }

        private final IrSimpleFunction createInvokeMethod(IrValueDeclaration receiverVar) {
            IrClass $this$addFunction$iv = this.functionReferenceClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d18$iv$iv$iv = irFunctionBuilder;
            boolean bl3 = false;
            IrFunctionBuilder $this$createInvokeMethod_u24lambda_u2d12 = $this$buildFun_u24lambda_u2d18$iv$iv$iv;
            boolean bl4 = false;
            IrElementBuilderKt.setSourceRange($this$createInvokeMethod_u24lambda_u2d12, this.isLambda ? (IrElement)this.callee : (IrElement)this.getIrFunctionReference());
            $this$createInvokeMethod_u24lambda_u2d12.setName(((IrSimpleFunction)this.superMethod.getOwner()).getName());
            $this$createInvokeMethod_u24lambda_u2d12.setReturnType(this.callee.getReturnType());
            $this$createInvokeMethod_u24lambda_u2d12.setSuspend(AdditionalIrUtilsKt.isSuspend(this.callee));
            $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2d18$iv$iv$iv);
            boolean bl5 = false;
            boolean bl6 = false;
            Object function$iv$iv = $this$buildFun$iv$iv$iv;
            boolean bl7 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            Object object = $this$buildFun$iv$iv$iv;
            boolean bl8 = false;
            boolean bl9 = false;
            Object $this$createInvokeMethod_u24lambda_u2d13 = object;
            boolean bl10 = false;
            Object object2 = $this$createInvokeMethod_u24lambda_u2d13;
            object2.setOverriddenSymbols(CollectionsKt.plus((Collection)object2.getOverriddenSymbols(), (Object)this.superMethod));
            object2 = IrUtilsKt.getParentAsClass((IrDeclaration)$this$createInvokeMethod_u24lambda_u2d13).getThisReceiver();
            Intrinsics.checkNotNull((Object)object2);
            ((IrFunction)$this$createInvokeMethod_u24lambda_u2d13).setDispatchReceiverParameter(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)object2, (IrFunction)$this$createInvokeMethod_u24lambda_u2d13, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null));
            if (this.isLambda) {
                this.createLambdaInvokeMethod((IrSimpleFunction)$this$createInvokeMethod_u24lambda_u2d13);
            } else {
                this.createFunctionReferenceInvokeMethod((IrSimpleFunction)$this$createInvokeMethod_u24lambda_u2d13, receiverVar);
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLambdaInvokeMethod(IrSimpleFunction $this$createLambdaInvokeMethod) {
            void $this$associateTo$iv$iv;
            IrSimpleFunction irSimpleFunction = $this$createLambdaInvokeMethod;
            irSimpleFunction.setAnnotations(CollectionsKt.plus((Collection)irSimpleFunction.getAnnotations(), (Iterable)this.callee.getAnnotations()));
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)IrUtilsKt.getExplicitParameters(this.callee));
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                IndexedValue $dstr$index$param = (IndexedValue)element$iv$iv;
                boolean bl = false;
                int index2 = $dstr$index$param.component1();
                IrValueParameter param = (IrValueParameter)$dstr$index$param.component2();
                Pair pair = TuplesKt.to((Object)param, (Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(param, $this$createLambdaInvokeMethod, null, index2, 0, 0, null, null, null, null, null, false, false, false, 8186, null));
                boolean bl2 = false;
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map valueParameterMap = destination$iv$iv;
            IrSimpleFunction irSimpleFunction2 = $this$createLambdaInvokeMethod;
            irSimpleFunction2.setValueParameters(CollectionsKt.plus((Collection)irSimpleFunction2.getValueParameters(), (Iterable)valueParameterMap.values()));
            $this$createLambdaInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo(this.callee, $this$createLambdaInvokeMethod, valueParameterMap));
        }

        /*
         * WARNING - void declaration
         */
        private final void createFunctionReferenceInvokeMethod(IrSimpleFunction $this$createFunctionReferenceInvokeMethod, IrValueDeclaration receiver) {
            void $this$createFunctionReferenceInvokeMethod_u24lambda_u2d18_u24lambda_u2d17;
            void $this$createFunctionReferenceInvokeMethod_u24lambda_u2d18;
            Iterator<IrValueParameter> iterator2;
            Object $this$addValueParameter_u24lambda_u2d31$iv;
            boolean bl;
            boolean bl2;
            Object object;
            Object argumentType;
            Object object2 = this.argumentTypes.iterator();
            int n = 0;
            while (object2.hasNext()) {
                int index2 = n++;
                argumentType = object2.next();
                IrFunction $this$addValueParameter$iv = $this$createFunctionReferenceInvokeMethod;
                boolean $i$f$addValueParameter = false;
                object = new IrValueParameterBuilder();
                bl2 = false;
                bl = false;
                $this$addValueParameter_u24lambda_u2d31$iv = object;
                boolean bl3 = false;
                IrValueParameterBuilder $this$createFunctionReferenceInvokeMethod_u24lambda_u2d15 = $this$addValueParameter_u24lambda_u2d31$iv;
                boolean bl4 = false;
                Name name = Name.identifier(Intrinsics.stringPlus((String)"p", (Object)index2));
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"p$index\")");
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d15.setName(name);
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d15.setType((IrType)argumentType);
                if (((IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2d31$iv).getIndex() == -1) {
                    ((IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2d31$iv).setIndex($this$addValueParameter$iv.getValueParameters().size());
                }
                iterator2 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), (IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2d31$iv, $this$addValueParameter$iv);
                boolean bl5 = false;
                boolean bl6 = false;
                Iterator<IrValueParameter> valueParameter$iv = iterator2;
                boolean bl7 = false;
                $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), valueParameter$iv));
            }
            object2 = LowerUtilsKt.createIrBuilder$default(WasmCallableReferenceLowering.this.context, $this$createFunctionReferenceInvokeMethod.getSymbol(), 0, 0, 6, null);
            n = 0;
            boolean bl8 = false;
            argumentType = object2;
            IrSimpleFunction irSimpleFunction = $this$createFunctionReferenceInvokeMethod;
            boolean bl9 = false;
            int unboundIndex = 0;
            object = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d18, this.callee);
            bl2 = false;
            bl = false;
            $this$addValueParameter_u24lambda_u2d31$iv = object;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d18;
            boolean bl10 = false;
            Object bl4 = this.typeArgumentsMap;
            boolean bl11 = false;
            iterator2 = bl4.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object3 = bl4 = iterator2.next();
                boolean bl12 = false;
                IrTypeParameterSymbol typeParameter = (IrTypeParameterSymbol)object3.getKey();
                Object object4 = bl4;
                boolean bl13 = false;
                IrType typeArgument = (IrType)object4.getValue();
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d18_u24lambda_u2d17.putTypeArgument(((IrTypeParameter)typeParameter.getOwner()).getIndex(), typeArgument);
            }
            for (IrValueParameter parameter : IrUtilsKt.getExplicitParameters(this.callee)) {
                IrGetValueImpl irGetValueImpl;
                IrGetValueImpl irGetValueImpl2;
                Object object5 = this.boundReceiver;
                if (Intrinsics.areEqual((Object)(object5 == null ? null : (IrValueParameter)object5.getFirst()), (Object)parameter)) {
                    object5 = receiver;
                    if (object5 == null) {
                        String string2 = "Binding receivers is not supported yet";
                        boolean bl14 = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    irGetValueImpl2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d18, object5);
                } else if (AdditionalIrUtilsKt.isVararg(parameter) && unboundIndex < this.argumentTypes.size() && Intrinsics.areEqual((Object)parameter.getType(), (Object)$this$createFunctionReferenceInvokeMethod.getValueParameters().get(unboundIndex).getType())) {
                    int n2 = unboundIndex;
                    unboundIndex = n2 + 1;
                    irGetValueImpl2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d18, $this$createFunctionReferenceInvokeMethod.getValueParameters().get(n2));
                } else {
                    if (AdditionalIrUtilsKt.isVararg(parameter) && (unboundIndex < this.argumentTypes.size() || !IrUtilsKt.hasDefaultValue(parameter))) {
                        boolean bl15 = false;
                        throw (Throwable)new NotImplementedError(null, 1, null);
                    }
                    if (unboundIndex >= this.argumentTypes.size()) {
                        irGetValueImpl2 = null;
                    } else {
                        int n3 = unboundIndex;
                        unboundIndex = n3 + 1;
                        irGetValueImpl2 = irGetValueImpl = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d18, $this$createFunctionReferenceInvokeMethod.getValueParameters().get(n3));
                    }
                }
                if (irGetValueImpl == null) continue;
                IrGetValueImpl irGetValueImpl3 = irGetValueImpl;
                boolean bl16 = false;
                boolean bl17 = false;
                IrGetValueImpl it = irGetValueImpl3;
                boolean bl18 = false;
                IrMemberAccessExpressionKt.putArgument((IrMemberAccessExpression)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d18_u24lambda_u2d17, this.callee, parameter, it);
            }
            Unit unit = Unit.INSTANCE;
            IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody(irBuilderWithScope, (IrExpression)object);
            irSimpleFunction.setBody(irExpressionBody);
        }
    }
}

