/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.internal.file.copy.RenamingCopyAction;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.internal.Transformers;
import org.gradle.util.internal.ConfigureUtil;

public class War
extends Jar {
    public static final String WAR_EXTENSION = "war";
    private File webXml;
    private FileCollection classpath;
    private final DefaultCopySpec webInf;
    private final DirectoryProperty webAppDirectory;

    public War() {
        this.getArchiveExtension().set((Object)WAR_EXTENSION);
        this.setMetadataCharset("UTF-8");
        this.webInf = (DefaultCopySpec)this.getRootSpec().addChildBeforeSpec(this.getMainSpec()).into((Object)"WEB-INF");
        this.webInf.into((Object)"classes", spec -> spec.from(new Object[]{() -> {
            FileCollection classpath = this.getClasspath();
            return classpath != null ? classpath.filter(SerializableLambdas.spec(File::isDirectory)) : Collections.emptyList();
        }}));
        this.webInf.into((Object)"lib", spec -> spec.from(new Object[]{() -> {
            FileCollection classpath = this.getClasspath();
            return classpath != null ? classpath.filter(SerializableLambdas.spec(File::isFile)) : Collections.emptyList();
        }}));
        CopySpecInternal renameSpec = this.webInf.addChild();
        renameSpec.into((Object)"");
        renameSpec.from(new Object[]{this::getWebXml});
        renameSpec.appendCachingSafeCopyAction((Action)new RenamingCopyAction(Transformers.constant((Object)"web.xml")));
        this.webAppDirectory = this.getObjectFactory().directoryProperty();
    }

    @Inject
    public ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Internal
    public CopySpec getWebInf() {
        return this.webInf.addChild();
    }

    public CopySpec webInf(Closure configureClosure) {
        return (CopySpec)ConfigureUtil.configure((Closure)configureClosure, (Object)this.getWebInf());
    }

    public CopySpec webInf(Action<? super CopySpec> configureAction) {
        CopySpec webInf = this.getWebInf();
        configureAction.execute((Object)webInf);
        return webInf;
    }

    @Nullable
    @Optional
    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.setClasspath((Object)classpath);
    }

    public void setClasspath(Object classpath) {
        this.classpath = this.getProject().files(new Object[]{classpath});
    }

    public void classpath(Object ... classpath) {
        FileCollection oldClasspath = this.getClasspath();
        this.classpath = this.getProject().files(new Object[]{oldClasspath != null ? oldClasspath : new ArrayList(), classpath});
    }

    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    public File getWebXml() {
        return this.webXml;
    }

    public void setWebXml(@Nullable File webXml) {
        this.webXml = webXml;
    }

    @Incubating
    @Internal
    public DirectoryProperty getWebAppDirectory() {
        return this.webAppDirectory;
    }
}

