/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFakeOverrideFunction;
import org.jetbrains.kotlin.ir.declarations.IrFakeOverrideProperty;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.overrides.DeepCopyIrTreeWithSymbolsForFakeOverrides;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H$J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0017H$R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/overrides/FakeOverrideBuilderStrategy;", "", "()V", "propertyOverriddenSymbols", "", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getPropertyOverriddenSymbols", "()Ljava/util/Map;", "fakeOverrideMember", "superType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "member", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "linkFakeOverride", "", "fakeOverride", "linkFunctionFakeOverride", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFakeOverrideFunction;", "linkPropertyFakeOverride", "Lorg/jetbrains/kotlin/ir/declarations/IrFakeOverrideProperty;", "ir.tree"})
public abstract class FakeOverrideBuilderStrategy {
    @NotNull
    private final Map<IrOverridableMember, List<IrSymbol>> propertyOverriddenSymbols;

    public FakeOverrideBuilderStrategy() {
        boolean bl = false;
        this.propertyOverriddenSymbols = new LinkedHashMap();
    }

    @NotNull
    public IrOverridableMember fakeOverrideMember(@NotNull IrType superType, @NotNull IrOverridableMember member2, @NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)member2, (String)"member");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        boolean bl = superType instanceof IrSimpleType;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl42 = false;
            String string2 = "superType is " + superType + ", expected IrSimpleType";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        IrClassifierSymbol classifier2 = ((IrSimpleType)superType).getClassifier();
        bl2 = classifier2 instanceof IrClassSymbol;
        bl3 = false;
        boolean bl42 = false;
        if (!bl2) {
            boolean bl5 = false;
            String bl42 = Intrinsics.stringPlus((String)"superType classifier is not IrClassSymbol: ", (Object)classifier2);
            throw (Throwable)new IllegalArgumentException(bl42.toString());
        }
        List<IrTypeParameter> typeParameters2 = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)((IrClassSymbol)classifier2).getOwner());
        List<IrTypeArgument> superArguments = ((IrSimpleType)superType).getArguments();
        bl42 = typeParameters2.size() == superArguments.size();
        int bl5 = 0;
        if (_Assertions.ENABLED && !bl42) {
            boolean $i$a$-assert-FakeOverrideBuilderStrategy$fakeOverrideMember$42 = false;
            String $i$a$-assert-FakeOverrideBuilderStrategy$fakeOverrideMember$42 = "typeParameters = " + typeParameters2 + " size != typeArguments = " + superArguments + " size ";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FakeOverrideBuilderStrategy$fakeOverrideMember$42));
        }
        bl5 = 0;
        Map substitutionMap = new LinkedHashMap();
        bl5 = 0;
        int $i$a$-assert-FakeOverrideBuilderStrategy$fakeOverrideMember$42 = typeParameters2.size() + -1;
        if (bl5 <= $i$a$-assert-FakeOverrideBuilderStrategy$fakeOverrideMember$42) {
            do {
                int i = bl5++;
                IrTypeParameter tp = typeParameters2.get(i);
                IrTypeArgument ta = superArguments.get(i);
                boolean bl6 = ta instanceof IrTypeProjection;
                boolean bl7 = false;
                boolean bl8 = false;
                if (!bl6) {
                    boolean bl9 = false;
                    String string3 = "Unexpected super type argument: " + ta + " @ " + i;
                    throw (Throwable)new IllegalArgumentException(string3.toString());
                }
                bl6 = ((IrTypeProjection)ta).getVariance() == Variance.INVARIANT;
                bl7 = false;
                if (_Assertions.ENABLED && !bl6) {
                    boolean bl10 = false;
                    String string4 = "Unexpected variance in super type argument: " + (Object)((Object)((IrTypeProjection)ta).getVariance()) + " @" + i;
                    throw (Throwable)((Object)new AssertionError((Object)string4));
                }
                Map map = substitutionMap;
                IrTypeParameterSymbol irTypeParameterSymbol = (IrTypeParameterSymbol)tp.getSymbol();
                IrType irType = ((IrTypeProjection)ta).getType();
                boolean bl11 = false;
                map.put(irTypeParameterSymbol, irType);
            } while (bl5 <= $i$a$-assert-FakeOverrideBuilderStrategy$fakeOverrideMember$42);
        }
        DeepCopyIrTreeWithSymbolsForFakeOverrides copier2 = new DeepCopyIrTreeWithSymbolsForFakeOverrides(substitutionMap);
        IrOverridableMember deepCopyFakeOverride = (IrOverridableMember)copier2.copy(member2, clazz);
        deepCopyFakeOverride.setParent(clazz);
        return deepCopyFakeOverride;
    }

    public final void linkFakeOverride(@NotNull IrOverridableMember fakeOverride) {
        Intrinsics.checkNotNullParameter((Object)fakeOverride, (String)"fakeOverride");
        IrOverridableMember irOverridableMember = fakeOverride;
        if (irOverridableMember instanceof IrFakeOverrideFunction) {
            this.linkFunctionFakeOverride((IrFakeOverrideFunction)((Object)fakeOverride));
        } else if (irOverridableMember instanceof IrFakeOverrideProperty) {
            this.linkPropertyFakeOverride((IrFakeOverrideProperty)((Object)fakeOverride));
        } else {
            String string2 = Intrinsics.stringPlus((String)"Unexpected fake override: ", (Object)fakeOverride);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    }

    protected abstract void linkFunctionFakeOverride(@NotNull IrFakeOverrideFunction var1);

    protected abstract void linkPropertyFakeOverride(@NotNull IrFakeOverrideProperty var1);

    @NotNull
    public final Map<IrOverridableMember, List<IrSymbol>> getPropertyOverriddenSymbols() {
        return this.propertyOverriddenSymbols;
    }
}

