/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.plugins.GroovyJarFile;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.gradle.util.internal.VersionNumber;

public class GroovyRuntime {
    private static final VersionNumber GROOVY_VERSION_WITH_SEPARATE_ANT = VersionNumber.parse((String)"2.0");
    private static final VersionNumber GROOVY_VERSION_REQUIRING_TEMPLATES = VersionNumber.parse((String)"2.5");
    private static final List<String> GROOVY3_LIBS = Arrays.asList("groovy", "groovy-ant", "groovy-astbuilder", "groovy-console", "groovy-datetime", "groovy-dateutil", "groovy-nio", "groovy-sql", "groovy-test", "groovy-templates", "groovy-json", "groovy-xml", "groovy-groovydoc");
    private final Project project;
    private final JvmEcosystemUtilities jvmEcosystemUtilities;

    public GroovyRuntime(Project project) {
        this.project = project;
        this.jvmEcosystemUtilities = (JvmEcosystemUtilities)((ProjectInternal)project).getServices().get(JvmEcosystemUtilities.class);
    }

    public FileCollection inferGroovyClasspath(final Iterable<File> classpath) {
        return new LazilyInitializedFileCollection(){

            public String getDisplayName() {
                return "Groovy runtime classpath";
            }

            public FileCollection createDelegate() {
                GroovyJarFile groovyJar = GroovyRuntime.findGroovyJarFile(classpath);
                if (groovyJar == null) {
                    throw new GradleException(String.format("Cannot infer Groovy class path because no Groovy Jar was found on class path: %s", Iterables.toString((Iterable)classpath)));
                }
                if (groovyJar.isGroovyAll()) {
                    return GroovyRuntime.this.project.getLayout().files(new Object[]{groovyJar.getFile()});
                }
                VersionNumber groovyVersion = groovyJar.getVersion();
                if (groovyVersion.getMajor() == 3) {
                    return this.inferGroovy3Classpath(groovyVersion);
                }
                String notation = groovyJar.getDependencyNotation();
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                dependencies.add(GroovyRuntime.this.project.getDependencies().create((Object)notation));
                if (groovyVersion.compareTo(GROOVY_VERSION_WITH_SEPARATE_ANT) >= 0) {
                    this.addGroovyDependency(notation, dependencies, "groovy-ant");
                }
                if (groovyVersion.compareTo(GROOVY_VERSION_REQUIRING_TEMPLATES) >= 0) {
                    this.addGroovyDependency(notation, dependencies, "groovy-templates");
                }
                return GroovyRuntime.this.detachedRuntimeClasspath(dependencies.toArray(new Dependency[0]));
            }

            private void addGroovyDependency(String groovyDependencyNotion, List<Dependency> dependencies, String otherDependency) {
                dependencies.add(GroovyRuntime.this.project.getDependencies().create((Object)groovyDependencyNotion.replace(":groovy:", ":" + otherDependency + ":")));
            }

            private FileCollection inferGroovy3Classpath(VersionNumber groovyVersion) {
                Set groovyJarNames = GROOVY3_LIBS.stream().map(libName -> libName + "-" + groovyVersion + ".jar").collect(Collectors.toSet());
                List groovyClasspath = StreamSupport.stream(classpath.spliterator(), false).filter(f -> groovyJarNames.contains(f.getName())).collect(Collectors.toList());
                if (groovyClasspath.size() == GROOVY3_LIBS.size()) {
                    return GroovyRuntime.this.project.getLayout().files(new Object[]{groovyClasspath});
                }
                return GroovyRuntime.this.detachedRuntimeClasspath((Dependency[])GROOVY3_LIBS.stream().map(libName -> GroovyRuntime.this.project.getDependencies().create((Object)("org.codehaus.groovy:" + libName + ":" + groovyVersion))).toArray(Dependency[]::new));
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                if (classpath instanceof Buildable) {
                    context.add((Object)classpath);
                }
            }
        };
    }

    private Configuration detachedRuntimeClasspath(Dependency ... dependencies) {
        Configuration classpath = this.project.getConfigurations().detachedConfiguration(dependencies);
        this.jvmEcosystemUtilities.configureAsRuntimeClasspath(classpath);
        return classpath;
    }

    @Nullable
    private static GroovyJarFile findGroovyJarFile(Iterable<File> classpath) {
        for (File file : classpath) {
            GroovyJarFile groovyJar = GroovyJarFile.parse(file);
            if (groovyJar == null) continue;
            return groovyJar;
        }
        return null;
    }
}

