/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.CompilerApiData;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingData;

public class ClassSetAnalysis {
    private final ClassSetAnalysisData classAnalysis;
    private final AnnotationProcessingData annotationProcessingData;
    private final CompilerApiData compilerApiData;
    private final ImmutableSetMultimap<String, String> classDependenciesFromAnnotationProcessing;
    private final ImmutableSetMultimap<String, GeneratedResource> resourceDependenciesFromAnnotationProcessing;

    public ClassSetAnalysis(ClassSetAnalysisData classAnalysis) {
        this(classAnalysis, new AnnotationProcessingData(), CompilerApiData.unavailable());
    }

    public ClassSetAnalysis(ClassSetAnalysisData classAnalysis, AnnotationProcessingData annotationProcessingData, CompilerApiData compilerApiData) {
        this.classAnalysis = classAnalysis;
        this.annotationProcessingData = annotationProcessingData;
        this.compilerApiData = compilerApiData;
        ImmutableSetMultimap.Builder classDependenciesFromAnnotationProcessing = ImmutableSetMultimap.builder();
        for (Map.Entry<String, Set<String>> entry : annotationProcessingData.getGeneratedTypesByOrigin().entrySet()) {
            for (String generated : entry.getValue()) {
                String origin = entry.getKey();
                classDependenciesFromAnnotationProcessing.put((Object)origin, (Object)generated);
                classDependenciesFromAnnotationProcessing.put((Object)generated, (Object)origin);
            }
        }
        this.classDependenciesFromAnnotationProcessing = classDependenciesFromAnnotationProcessing.build();
        ImmutableSetMultimap.Builder resourceDependenciesFromAnnotationProcessing = ImmutableSetMultimap.builder();
        for (Map.Entry<String, Set<GeneratedResource>> entry : annotationProcessingData.getGeneratedResourcesByOrigin().entrySet()) {
            for (GeneratedResource generated : entry.getValue()) {
                String origin = entry.getKey();
                resourceDependenciesFromAnnotationProcessing.put((Object)origin, (Object)generated);
            }
        }
        this.resourceDependenciesFromAnnotationProcessing = resourceDependenciesFromAnnotationProcessing.build();
    }

    public ClassSetDiff findChangesSince(ClassSetAnalysis other) {
        DependentsSet directChanges = this.classAnalysis.getChangedClassesSince(other.classAnalysis);
        if (directChanges.isDependencyToAll()) {
            return new ClassSetDiff(directChanges, Collections.emptyMap());
        }
        DependentsSet transitiveChanges = other.findTransitiveDependents(directChanges.getAllDependentClasses(), Collections.emptyMap());
        if (transitiveChanges.isDependencyToAll()) {
            return new ClassSetDiff(transitiveChanges, Collections.emptyMap());
        }
        DependentsSet allChanges = DependentsSet.merge(Arrays.asList(directChanges, transitiveChanges));
        Map<String, IntSet> changedConstants = this.findChangedConstants(other, allChanges);
        return new ClassSetDiff(allChanges, changedConstants);
    }

    private Map<String, IntSet> findChangedConstants(ClassSetAnalysis other, DependentsSet affectedClasses) {
        if (affectedClasses.isDependencyToAll()) {
            return Collections.emptyMap();
        }
        Set<String> dependentClasses = affectedClasses.getAllDependentClasses();
        HashMap<String, IntSet> result = new HashMap<String, IntSet>(dependentClasses.size());
        for (String affectedClass : dependentClasses) {
            IntOpenHashSet difference = new IntOpenHashSet((IntCollection)other.getConstants(affectedClass));
            difference.removeAll((IntCollection)this.getConstants(affectedClass));
            result.put(affectedClass, (IntSet)difference);
        }
        return result;
    }

    public DependentsSet findTransitiveDependents(Collection<String> classes, Map<String, IntSet> constants) {
        if (classes.isEmpty()) {
            return DependentsSet.empty();
        }
        HashSet<String> accessibleResultClasses = new HashSet<String>();
        HashSet<String> privateResultClasses = new HashSet<String>();
        HashSet<GeneratedResource> resultResources = new HashSet<GeneratedResource>();
        for (String cls : classes) {
            DependentsSet d = this.findTransitiveDependents(cls, constants.getOrDefault(cls, IntSets.emptySet()));
            if (d.isDependencyToAll()) {
                return d;
            }
            if (d.isEmpty()) continue;
            Set<String> accessibleDependentClasses = d.getAccessibleDependentClasses();
            Set<String> privateDependentClasses = d.getPrivateDependentClasses();
            Set<GeneratedResource> dependentResources = d.getDependentResources();
            accessibleResultClasses.addAll(accessibleDependentClasses);
            privateResultClasses.addAll(privateDependentClasses);
            resultResources.addAll(dependentResources);
        }
        return DependentsSet.dependents(privateResultClasses, accessibleResultClasses, resultResources);
    }

    public DependentsSet findTransitiveDependents(String className, IntSet constants) {
        String fullRebuildCause = this.annotationProcessingData.getFullRebuildCause();
        if (fullRebuildCause != null) {
            return DependentsSet.dependencyToAll(fullRebuildCause);
        }
        DependentsSet deps = this.getDependents(className);
        if (deps.isDependencyToAll()) {
            return deps;
        }
        if (!constants.isEmpty() && !this.compilerApiData.isSupportsConstantsMapping()) {
            return DependentsSet.dependencyToAll("an inlineable constant in '" + className + "' has changed");
        }
        Set<String> classesDependingOnAllOthers = this.annotationProcessingData.participatesInClassGeneration(className) ? this.annotationProcessingData.getGeneratedTypesDependingOnAllOthers() : Collections.emptySet();
        Set resourcesDependingOnAllOthers = this.annotationProcessingData.participatesInResourceGeneration(className) ? this.annotationProcessingData.getGeneratedResourcesDependingOnAllOthers() : Collections.emptySet();
        ObjectOpenHashSet accessibleConstantDependents = new ObjectOpenHashSet(this.compilerApiData.getConstantDependentsForClass(className).getAccessibleDependentClasses());
        ObjectOpenHashSet privateConstantDependents = new ObjectOpenHashSet(this.compilerApiData.getConstantDependentsForClass(className).getPrivateDependentClasses());
        this.processTransitiveConstantDependentClasses((Set<Object>)new ObjectOpenHashSet(Collections.singleton(className)), (Set<String>)privateConstantDependents, (Set<String>)accessibleConstantDependents);
        if (!deps.hasDependentClasses() && classesDependingOnAllOthers.isEmpty() && resourcesDependingOnAllOthers.isEmpty() && accessibleConstantDependents.isEmpty() && privateConstantDependents.isEmpty()) {
            return deps;
        }
        HashSet<String> dependents = new HashSet<String>(deps.getAccessibleDependentClasses());
        HashSet<String> privateResultClasses = new HashSet<String>();
        HashSet<String> accessibleResultClasses = new HashSet<String>();
        HashSet<GeneratedResource> resultResources = new HashSet<GeneratedResource>(resourcesDependingOnAllOthers);
        this.processDependentClasses(new HashSet<String>(), privateResultClasses, accessibleResultClasses, resultResources, deps.getPrivateDependentClasses(), dependents);
        this.processDependentClasses(new HashSet<String>(), privateResultClasses, accessibleResultClasses, resultResources, Collections.emptySet(), classesDependingOnAllOthers);
        this.processDependentClasses(new HashSet<String>(), privateResultClasses, accessibleResultClasses, resultResources, (Iterable<String>)privateConstantDependents, (Iterable<String>)accessibleConstantDependents);
        accessibleResultClasses.remove(className);
        privateResultClasses.remove(className);
        return DependentsSet.dependents(privateResultClasses, accessibleResultClasses, resultResources);
    }

    public Set<String> getTypesToReprocess() {
        return this.annotationProcessingData.getAggregatedTypes().stream().map(this.annotationProcessingData::getOriginOf).collect(Collectors.toSet());
    }

    public boolean isDependencyToAll(String className) {
        return this.classAnalysis.getDependents(className).isDependencyToAll();
    }

    private void processDependentClasses(Set<String> visitedClasses, Set<String> privateResultClasses, Set<String> accessibleResultClasses, Set<GeneratedResource> resultResources, Iterable<String> privateDependentClasses, Iterable<String> accessibleDependentClasses) {
        for (String privateDependentClass : privateDependentClasses) {
            if (!visitedClasses.add(privateDependentClass)) continue;
            privateResultClasses.add(privateDependentClass);
            DependentsSet currentDependents = this.getDependents(privateDependentClass);
            if (currentDependents.isDependencyToAll()) continue;
            resultResources.addAll(currentDependents.getDependentResources());
        }
        this.processTransitiveDependentClasses(visitedClasses, accessibleResultClasses, resultResources, accessibleDependentClasses);
    }

    private void processTransitiveDependentClasses(Set<String> visitedClasses, Set<String> accessibleResultClasses, Set<GeneratedResource> resultResources, Iterable<String> accessibleDependentClasses) {
        ArrayDeque<String> remainingAccessibleDependentClasses = new ArrayDeque<String>();
        for (String accessibleDependentClass : accessibleDependentClasses) {
            remainingAccessibleDependentClasses.add(accessibleDependentClass);
        }
        while (!remainingAccessibleDependentClasses.isEmpty()) {
            String accessibleDependentClass = (String)remainingAccessibleDependentClasses.pop();
            if (!visitedClasses.add(accessibleDependentClass)) continue;
            accessibleResultClasses.add(accessibleDependentClass);
            DependentsSet currentDependents = this.getDependents(accessibleDependentClass);
            if (currentDependents.isDependencyToAll()) continue;
            resultResources.addAll(currentDependents.getDependentResources());
            remainingAccessibleDependentClasses.addAll(currentDependents.getAccessibleDependentClasses());
        }
    }

    private DependentsSet getDependents(String className) {
        DependentsSet dependents = this.classAnalysis.getDependents(className);
        if (dependents.isDependencyToAll()) {
            return dependents;
        }
        ImmutableSet annotationProcessingClassDeps = this.classDependenciesFromAnnotationProcessing.get((Object)className);
        ImmutableSet annotationProcessingResourceDeps = this.resourceDependenciesFromAnnotationProcessing.get((Object)className);
        if (annotationProcessingClassDeps.isEmpty() && annotationProcessingResourceDeps.isEmpty()) {
            return dependents;
        }
        return DependentsSet.dependents(dependents.getPrivateDependentClasses(), (Set<String>)Sets.union(dependents.getAccessibleDependentClasses(), (Set)annotationProcessingClassDeps), (Set<GeneratedResource>)Sets.union(dependents.getDependentResources(), (Set)annotationProcessingResourceDeps));
    }

    private void processTransitiveConstantDependentClasses(Set<Object> visited, Set<String> privateConstantDependents, Set<String> accessibleConstantDependents) {
        ArrayDeque<String> remainingAccessibleDependentClasses = new ArrayDeque<String>(accessibleConstantDependents);
        while (!remainingAccessibleDependentClasses.isEmpty()) {
            String accessibleDependentClass = (String)remainingAccessibleDependentClasses.pop();
            if (!visited.add(accessibleDependentClass)) continue;
            accessibleConstantDependents.add(accessibleDependentClass);
            DependentsSet constantDependents = this.compilerApiData.getConstantDependentsForClass(accessibleDependentClass);
            privateConstantDependents.addAll(constantDependents.getPrivateDependentClasses());
            remainingAccessibleDependentClasses.addAll(constantDependents.getAccessibleDependentClasses());
        }
    }

    public IntSet getConstants(String className) {
        return this.classAnalysis.getConstants(className);
    }

    public static final class ClassSetDiff {
        private final DependentsSet dependents;
        private final Map<String, IntSet> constants;

        public ClassSetDiff(DependentsSet dependents, Map<String, IntSet> constants) {
            this.dependents = dependents;
            this.constants = constants;
        }

        public DependentsSet getDependents() {
            return this.dependents;
        }

        public Map<String, IntSet> getConstants() {
            return this.constants;
        }
    }
}

