/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.internal.InternalBuildFinishedListener;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.scopes.BuildScopeServices;

public class DefaultBuildLifecycleController
implements BuildLifecycleController {
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildListener buildListener;
    private final BuildCompletionListener buildCompletionListener;
    private final InternalBuildFinishedListener buildFinishedListener;
    private final BuildWorkExecutor buildExecuter;
    private final BuildScopeServices buildServices;
    private final GradleInternal gradle;
    private final BuildModelController modelController;
    private State state = State.Created;
    @Nullable
    private RuntimeException stageFailure;

    public DefaultBuildLifecycleController(GradleInternal gradle, BuildModelController buildModelController, ExceptionAnalyser exceptionAnalyser, BuildListener buildListener, BuildCompletionListener buildCompletionListener, InternalBuildFinishedListener buildFinishedListener, BuildWorkExecutor buildExecuter, BuildScopeServices buildServices) {
        this.gradle = gradle;
        this.modelController = buildModelController;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.buildExecuter = buildExecuter;
        this.buildCompletionListener = buildCompletionListener;
        this.buildFinishedListener = buildFinishedListener;
        this.buildServices = buildServices;
    }

    @Override
    public GradleInternal getGradle() {
        if (this.state == State.Finished) {
            throw new IllegalStateException("Cannot use Gradle object after build has finished.");
        }
        return this.gradle;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.withModel(BuildModelController::getLoadedSettings);
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        return this.withModel(BuildModelController::getConfiguredModel);
    }

    @Override
    public void scheduleTasks(Iterable<String> taskPaths) {
        this.withModel(buildModelController -> {
            this.state = State.TaskGraph;
            buildModelController.scheduleTasks(taskPaths);
            return null;
        });
    }

    @Override
    public void scheduleRequestedTasks() {
        this.withModel(buildModelController -> {
            this.state = State.TaskGraph;
            buildModelController.scheduleRequestedTasks();
            return null;
        });
    }

    @Override
    public void executeTasks() {
        this.withModel(buildModelController -> {
            this.runWork();
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T withModel(Function<BuildModelController, T> action) {
        if (this.stageFailure != null) {
            throw new IllegalStateException("Cannot do further work as this build has failed.", this.stageFailure);
        }
        if (this.state == State.Finished) {
            throw new IllegalStateException("Cannot do further work as this build has finished.");
        }
        try {
            try {
                BuildModelController t = action.apply(this.modelController);
                return (T)t;
            }
            finally {
                if (this.state == State.Created) {
                    this.state = State.Configure;
                }
            }
        }
        catch (Throwable t2) {
            this.stageFailure = this.exceptionAnalyser.transform(t2);
            throw this.stageFailure;
        }
    }

    @Override
    public void finishBuild(@Nullable Throwable failure, Consumer<? super Throwable> collector) {
        if (this.state == State.Created) {
            this.state = State.Finished;
            return;
        }
        if (this.state == State.Finished) {
            return;
        }
        Throwable reportableFailure = failure;
        if (reportableFailure == null && this.stageFailure != null) {
            reportableFailure = this.stageFailure;
        }
        BuildResult buildResult = new BuildResult(this.state.getDisplayName(), (Gradle)this.gradle, reportableFailure);
        try {
            this.buildListener.buildFinished(buildResult);
            this.buildFinishedListener.buildFinished((GradleInternal)buildResult.getGradle(), buildResult.getFailure() != null);
        }
        catch (Throwable t) {
            collector.accept(t);
        }
        this.state = State.Finished;
        this.stageFailure = null;
    }

    private void runWork() {
        ArrayList taskFailures = new ArrayList();
        this.buildExecuter.execute(this.gradle, taskFailures);
        if (!taskFailures.isEmpty()) {
            throw new MultipleBuildFailures(taskFailures);
        }
    }

    @Override
    public void addListener(Object listener) {
        this.gradle.addListener(listener);
    }

    public void stop() {
        if (this.state != State.Created && this.state != State.Finished) {
            throw new IllegalStateException("This build has not been finished.");
        }
        try {
            CompositeStoppable.stoppable((Object[])new Object[]{this.buildServices}).stop();
        }
        finally {
            this.buildCompletionListener.completed();
        }
    }

    private static enum State {
        Created,
        Configure,
        TaskGraph,
        Finished;


        String getDisplayName() {
            if (TaskGraph == this) {
                return "Build";
            }
            return "Configure";
        }
    }
}

