/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderFactoryImpl;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.lightTree.converter.DeclarationsConverter;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.parsing.KotlinLightParser;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/LightTree2Fir;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;", "stubMode", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;Z)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "buildFirFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "code", "", "fileName", "buildLightTree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "Companion", "light-tree2fir"})
public final class LightTree2Fir {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirScopeProvider scopeProvider;
    private final boolean stubMode;
    @NotNull
    private static final KotlinParserDefinition parserDefinition = new KotlinParserDefinition();
    @NotNull
    private static final KotlinLexer lexer = new KotlinLexer();

    public LightTree2Fir(@NotNull FirSession session2, @NotNull FirScopeProvider scopeProvider2, boolean stubMode) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeProvider2, (String)"scopeProvider");
        this.session = session2;
        this.scopeProvider = scopeProvider2;
        this.stubMode = stubMode;
    }

    public /* synthetic */ LightTree2Fir(FirSession firSession, FirScopeProvider firScopeProvider, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(firSession, firScopeProvider, bl);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        File file2 = path2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"path.toFile()");
        return this.buildFirFile(file2);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string2 = FileUtil.loadFile(file2, "UTF-8", true);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"loadFile(file, CharsetToolkit.UTF8, true)");
        boolean bl = false;
        String code = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        string2 = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
        return this.buildFirFile(code, string2);
    }

    @NotNull
    public final FlyweightCapableTreeStructure<LighterASTNode> buildLightTree(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Object object = new PsiBuilderFactoryImpl().createBuilder(parserDefinition, (Lexer)lexer, code);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PsiBuilderFactoryImpl().createBuilder(parserDefinition, lexer, code)");
        PsiBuilder builder2 = object;
        KotlinLightParser.parse(builder2);
        object = builder2.getLightTree();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.lightTree");
        return object;
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull String code, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        FlyweightCapableTreeStructure<LighterASTNode> lightTree = this.buildLightTree(code);
        DeclarationsConverter declarationsConverter = new DeclarationsConverter(this.session, this.scopeProvider, this.stubMode, lightTree, 0, null, 48, null);
        LighterASTNode lighterASTNode2 = lightTree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)lighterASTNode2, (String)"lightTree.root");
        return declarationsConverter.convertFile(lighterASTNode2, fileName);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/LightTree2Fir$Companion;", "", "()V", "lexer", "Lorg/jetbrains/kotlin/lexer/KotlinLexer;", "parserDefinition", "Lorg/jetbrains/kotlin/parsing/KotlinParserDefinition;", "buildLightTreeBlockExpression", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "code", "", "buildLightTreeLambdaExpression", "light-tree2fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FlyweightCapableTreeStructure<LighterASTNode> buildLightTreeBlockExpression(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Object object = new PsiBuilderFactoryImpl().createBuilder(parserDefinition, (Lexer)lexer, code);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PsiBuilderFactoryImpl().createBuilder(parserDefinition, lexer, code)");
            PsiBuilder builder2 = object;
            KotlinLightParser.parseBlockExpression(builder2);
            object = builder2.getLightTree();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.lightTree");
            return object;
        }

        @NotNull
        public final FlyweightCapableTreeStructure<LighterASTNode> buildLightTreeLambdaExpression(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Object object = new PsiBuilderFactoryImpl().createBuilder(parserDefinition, (Lexer)lexer, code);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PsiBuilderFactoryImpl().createBuilder(parserDefinition, lexer, code)");
            PsiBuilder builder2 = object;
            KotlinLightParser.parseLambdaExpression(builder2);
            object = builder2.getLightTree();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.lightTree");
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

