/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.util.ArrayList;
import java.util.List;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.build.event.BuildEventListenerFactory;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.tooling.internal.provider.SessionScopeBuildActionExecutor;
import org.gradle.tooling.internal.provider.SubscribableBuildAction;

public class SubscribableBuildActionExecuter
implements SessionScopeBuildActionExecutor {
    private final BuildEventConsumer eventConsumer;
    private final BuildActionExecuter<BuildActionParameters, BuildSessionContext> delegate;
    private final ListenerManager listenerManager;
    private final BuildOperationListenerManager buildOperationListenerManager;
    private final List<Object> listeners = new ArrayList<Object>();
    private final BuildEventListenerFactory factory;

    public SubscribableBuildActionExecuter(ListenerManager listenerManager, BuildOperationListenerManager buildOperationListenerManager, BuildEventListenerFactory factory, BuildEventConsumer eventConsumer, BuildActionExecuter<BuildActionParameters, BuildSessionContext> delegate) {
        this.listenerManager = listenerManager;
        this.buildOperationListenerManager = buildOperationListenerManager;
        this.factory = factory;
        this.eventConsumer = eventConsumer;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildSessionContext buildSession) {
        if (action instanceof SubscribableBuildAction) {
            SubscribableBuildAction subscribableBuildAction = (SubscribableBuildAction)action;
            this.registerListenersForClientSubscriptions(subscribableBuildAction.getClientSubscriptions(), this.eventConsumer);
        }
        try {
            BuildActionResult buildActionResult = this.delegate.execute(action, actionParameters, buildSession);
            return buildActionResult;
        }
        finally {
            for (Object listener : this.listeners) {
                this.listenerManager.removeListener(listener);
                if (!(listener instanceof BuildOperationListener)) continue;
                this.buildOperationListenerManager.removeListener((BuildOperationListener)listener);
            }
            this.listeners.clear();
        }
    }

    private void registerListenersForClientSubscriptions(BuildEventSubscriptions clientSubscriptions, BuildEventConsumer eventConsumer) {
        for (Object listener : this.factory.createListeners(clientSubscriptions, eventConsumer)) {
            this.registerListener(listener);
        }
    }

    private void registerListener(Object listener) {
        this.listeners.add(listener);
        this.listenerManager.addListener(listener);
        if (listener instanceof BuildOperationListener) {
            this.buildOperationListenerManager.addListener((BuildOperationListener)listener);
        }
    }
}

