/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.DefaultTestClassScanner;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.processors.MaxNParallelTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.PatternMatchTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.RestartEveryNTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.RunPreviousFailedFirstTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.TestMainAction;
import org.gradle.api.internal.tasks.testing.worker.ForkingTestClassProcessor;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.time.Clock;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class DefaultTestExecuter
implements TestExecuter<JvmTestExecutionSpec> {
    private static final Logger LOGGER = Logging.getLogger(DefaultTestExecuter.class);
    private final WorkerProcessFactory workerFactory;
    private final ActorFactory actorFactory;
    private final ModuleRegistry moduleRegistry;
    private final WorkerLeaseRegistry workerLeaseRegistry;
    private final int maxWorkerCount;
    private final Clock clock;
    private final DocumentationRegistry documentationRegistry;
    private final DefaultTestFilter testFilter;
    private TestClassProcessor processor;

    public DefaultTestExecuter(WorkerProcessFactory workerFactory, ActorFactory actorFactory, ModuleRegistry moduleRegistry, WorkerLeaseRegistry workerLeaseRegistry, int maxWorkerCount, Clock clock, DocumentationRegistry documentationRegistry, DefaultTestFilter testFilter) {
        this.workerFactory = workerFactory;
        this.actorFactory = actorFactory;
        this.moduleRegistry = moduleRegistry;
        this.workerLeaseRegistry = workerLeaseRegistry;
        this.maxWorkerCount = maxWorkerCount;
        this.clock = clock;
        this.documentationRegistry = documentationRegistry;
        this.testFilter = testFilter;
    }

    public void execute(final JvmTestExecutionSpec testExecutionSpec, TestResultProcessor testResultProcessor) {
        DefaultTestClassScanner detector;
        TestFramework testFramework = testExecutionSpec.getTestFramework();
        final WorkerTestClassProcessorFactory testInstanceFactory = testFramework.getProcessorFactory();
        final WorkerLeaseRegistry.WorkerLease currentWorkerLease = this.workerLeaseRegistry.getCurrentWorkerLease();
        ImmutableSet classpath = ImmutableSet.copyOf(testExecutionSpec.getClasspath());
        ImmutableSet modulePath = ImmutableSet.copyOf(testExecutionSpec.getModulePath());
        List<String> testWorkerImplementationModules = testFramework.getTestWorkerImplementationModules();
        Factory<TestClassProcessor> forkingProcessorFactory = new Factory<TestClassProcessor>((Set)classpath, (Set)modulePath, testWorkerImplementationModules, testFramework){
            final /* synthetic */ Set val$classpath;
            final /* synthetic */ Set val$modulePath;
            final /* synthetic */ List val$testWorkerImplementationModules;
            final /* synthetic */ TestFramework val$testFramework;
            {
                this.val$classpath = set;
                this.val$modulePath = set2;
                this.val$testWorkerImplementationModules = list;
                this.val$testFramework = testFramework;
            }

            public TestClassProcessor create() {
                return new ForkingTestClassProcessor(currentWorkerLease, DefaultTestExecuter.this.workerFactory, testInstanceFactory, testExecutionSpec.getJavaForkOptions(), (Iterable)this.val$classpath, (Iterable)this.val$modulePath, this.val$testWorkerImplementationModules, this.val$testFramework.getWorkerConfigurationAction(), DefaultTestExecuter.this.moduleRegistry, DefaultTestExecuter.this.documentationRegistry);
            }
        };
        Factory<TestClassProcessor> reforkingProcessorFactory = new Factory<TestClassProcessor>((Factory)forkingProcessorFactory, testExecutionSpec){
            final /* synthetic */ Factory val$forkingProcessorFactory;
            final /* synthetic */ JvmTestExecutionSpec val$testExecutionSpec;
            {
                this.val$forkingProcessorFactory = factory;
                this.val$testExecutionSpec = jvmTestExecutionSpec;
            }

            public TestClassProcessor create() {
                return new RestartEveryNTestClassProcessor(this.val$forkingProcessorFactory, this.val$testExecutionSpec.getForkEvery());
            }
        };
        this.processor = new PatternMatchTestClassProcessor(this.testFilter, (TestClassProcessor)new RunPreviousFailedFirstTestClassProcessor(testExecutionSpec.getPreviousFailedTestClasses(), (TestClassProcessor)new MaxNParallelTestClassProcessor(this.getMaxParallelForks(testExecutionSpec), (Factory)reforkingProcessorFactory, this.actorFactory)));
        FileTree testClassFiles = testExecutionSpec.getCandidateClassFiles();
        if (testExecutionSpec.isScanForTestClasses() && testFramework.getDetector() != null) {
            TestFrameworkDetector testFrameworkDetector = testFramework.getDetector();
            testFrameworkDetector.setTestClasses(testExecutionSpec.getTestClassesDirs().getFiles());
            testFrameworkDetector.setTestClasspath((Set<File>)classpath);
            detector = new DefaultTestClassScanner(testClassFiles, testFrameworkDetector, this.processor);
        } else {
            detector = new DefaultTestClassScanner(testClassFiles, null, this.processor);
        }
        new TestMainAction((Runnable)detector, this.processor, testResultProcessor, this.clock, (Object)testExecutionSpec.getPath(), "Gradle Test Run " + testExecutionSpec.getIdentityPath()).run();
    }

    public void stopNow() {
        if (this.processor != null) {
            this.processor.stopNow();
        }
    }

    private int getMaxParallelForks(JvmTestExecutionSpec testExecutionSpec) {
        int maxParallelForks = testExecutionSpec.getMaxParallelForks();
        if (maxParallelForks > this.maxWorkerCount) {
            LOGGER.info("{}.maxParallelForks ({}) is larger than max-workers ({}), forcing it to {}", new Object[]{testExecutionSpec.getPath(), maxParallelForks, this.maxWorkerCount, this.maxWorkerCount});
            maxParallelForks = this.maxWorkerCount;
        }
        return maxParallelForks;
    }
}

