/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.maven;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.buildinit.plugins.internal.BuildConverter;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;
import org.gradle.util.IncubationLogger;
import org.gradle.workers.WorkerExecutor;
import org.gradleinternal.buildinit.plugins.internal.maven.Maven2GradleWorkAction;
import org.gradleinternal.buildinit.plugins.internal.maven.MavenConversionException;

public class PomProjectInitDescriptor
implements BuildConverter {
    private static final String MAVEN_VERSION = "3.6.3";
    private static final String MAVEN_WAGON_VERSION = "3.4.2";
    private static final String AETHER_VERSION = "1.1.0";
    private final MavenSettingsProvider settingsProvider;
    private final DocumentationRegistry documentationRegistry;
    private final WorkerExecutor executor;
    private FileCollection mavenClasspath;

    public PomProjectInitDescriptor(MavenSettingsProvider mavenSettingsProvider, DocumentationRegistry documentationRegistry, WorkerExecutor executor) {
        this.settingsProvider = mavenSettingsProvider;
        this.documentationRegistry = documentationRegistry;
        this.executor = executor;
    }

    @Override
    public String getId() {
        return "pom";
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.BASIC;
    }

    @Override
    public Language getLanguage() {
        return Language.NONE;
    }

    @Override
    public Set<ModularizationOption> getModularizationOptions() {
        return Collections.singleton(ModularizationOption.SINGLE_PROJECT);
    }

    @Override
    public String getSourceBuildDescription() {
        return "Maven";
    }

    @Override
    public void configureClasspath(ProjectInternal.DetachedResolver detachedResolver, ObjectFactory objects) {
        DependencyHandler dependencies = detachedResolver.getDependencies();
        Configuration config = detachedResolver.getConfigurations().detachedConfiguration(new Dependency[]{dependencies.create((Object)"org.apache.maven:maven-core:3.6.3"), dependencies.create((Object)"org.apache.maven:maven-plugin-api:3.6.3"), dependencies.create((Object)"org.apache.maven:maven-compat:3.6.3"), dependencies.create((Object)"org.apache.maven.wagon:wagon-http:3.4.2"), dependencies.create((Object)"org.apache.maven.wagon:wagon-provider-api:3.4.2"), dependencies.create((Object)"org.eclipse.aether:aether-connector-basic:1.1.0"), dependencies.create((Object)"org.eclipse.aether:aether-transport-wagon:1.1.0")});
        config.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objects.named(Usage.class, "java-runtime")));
        detachedResolver.getRepositories().mavenCentral();
        this.mavenClasspath = config;
    }

    @Override
    public void generate(InitSettings initSettings) {
        IncubationLogger.incubatingFeatureUsed((String)"Maven to Gradle conversion");
        try {
            Settings settings = this.settingsProvider.buildSettings();
            this.executor.classLoaderIsolation(config -> config.getClasspath().from(new Object[]{this.mavenClasspath})).submit(Maven2GradleWorkAction.class, params -> {
                params.getWorkingDir().set((Object)initSettings.getTarget());
                params.getDsl().set((Object)initSettings.getDsl());
                params.getMavenSettings().set((Object)settings);
            });
        }
        catch (SettingsBuildingException exception) {
            throw new MavenConversionException(String.format("Could not convert Maven POM %s to a Gradle build.", initSettings.getTarget().file("pom.xml").getAsFile()), exception);
        }
    }

    @Override
    public boolean supportsProjectName() {
        return false;
    }

    @Override
    public boolean canApplyToCurrentDirectory(Directory current) {
        return current.file("pom.xml").getAsFile().isFile();
    }

    @Override
    public Set<BuildInitDsl> getDsls() {
        return new TreeSet<BuildInitDsl>(Arrays.asList(BuildInitDsl.values()));
    }

    @Override
    public BuildInitDsl getDefaultDsl() {
        return BuildInitDsl.GROOVY;
    }

    @Override
    public boolean supportsPackage() {
        return false;
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return BuildInitTestFramework.NONE;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return Collections.singleton(BuildInitTestFramework.NONE);
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        return Optional.of(this.documentationRegistry.getDocumentationFor("migrating_from_maven"));
    }
}

