/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u0006*\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedClassConstructorCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "report", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "toRegularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/name/ClassId;", "checkers"})
public final class FirSealedClassConstructorCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSealedClassConstructorCallChecker INSTANCE = new FirSealedClassConstructorCallChecker();

    private FirSealedClassConstructorCallChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        Object object;
        FirConstructor firConstructor;
        FirResolvedNamedReference firResolvedNamedReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Object $this$safeAs$iv = expression2.getCalleeReference();
        boolean $i$f$safeAs = false;
        Object object2 = $this$safeAs$iv;
        if (!(object2 instanceof FirResolvedNamedReference)) {
            object2 = null;
        }
        ClassId $this$safeAs$iv2 = (firResolvedNamedReference = (FirResolvedNamedReference)object2) == null ? null : (($this$safeAs$iv = firResolvedNamedReference.getResolvedSymbol()) == null ? null : (ClassId)((AbstractFirBasedSymbol)$this$safeAs$iv).getFir());
        boolean $i$f$safeAs2 = false;
        ClassId classId = $this$safeAs$iv2;
        if (!(classId instanceof FirConstructor)) {
            classId = null;
        }
        if ((firConstructor = (FirConstructor)((Object)classId)) == null) {
            return;
        }
        FirConstructor constructorFir = firConstructor;
        FirTypeRef $this$safeAs$iv3 = constructorFir.getReturnTypeRef();
        boolean $i$f$safeAs3 = false;
        FirTypeRef firTypeRef = $this$safeAs$iv3;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        ConeKotlinType $this$safeAs$iv4 = ($i$f$safeAs = (FirResolvedTypeRef)firTypeRef) == null ? null : $i$f$safeAs.getType();
        boolean $i$f$safeAs4 = false;
        ConeKotlinType coneKotlinType = $this$safeAs$iv4;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ClassId classId2 = (object = (ConeClassLikeType)coneKotlinType) == null ? null : ($this$safeAs$iv2 = (coneClassLikeLookupTag = ((ConeClassLikeType)object).getLookupTag()) == null ? null : coneClassLikeLookupTag.getClassId());
        if ($this$safeAs$iv2 == null) {
            return;
        }
        ClassId typeClassId = $this$safeAs$iv2;
        object = this.toRegularClass(typeClassId, context2);
        if (object == null) {
            return;
        }
        Object typeFir = object;
        if (((FirRegularClass)typeFir).getStatus().getModality() == Modality.SEALED) {
            this.report(reporter, expression2.getCalleeReference().getSource());
        }
    }

    private final FirRegularClass toRegularClass(ClassId $this$toRegularClass, CheckerContext context2) {
        FirRegularClass firRegularClass;
        if (!$this$toRegularClass.isLocal()) {
            FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getFirSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName($this$toRegularClass);
            FirClassLikeDeclaration $this$safeAs$iv = firClassLikeSymbol == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir();
            boolean $i$f$safeAs = false;
            FirClassLikeDeclaration firClassLikeDeclaration = $this$safeAs$iv;
            if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
                firClassLikeDeclaration = null;
            }
            firRegularClass = (FirRegularClass)firClassLikeDeclaration;
        } else {
            FirDeclaration firDeclaration;
            block6: {
                List<FirDeclaration> $this$lastOrNull$iv = context2.getContainingDeclarations();
                boolean $i$f$lastOrNull = false;
                ListIterator<FirDeclaration> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    FirRegularClass firRegularClass2;
                    FirDeclaration element$iv;
                    FirDeclaration it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    FirDeclaration $this$safeAs$iv = it;
                    boolean $i$f$safeAs = false;
                    FirDeclaration firDeclaration2 = $this$safeAs$iv;
                    if (!(firDeclaration2 instanceof FirRegularClass)) {
                        firDeclaration2 = null;
                    }
                    if (!Intrinsics.areEqual((Object)((firRegularClass2 = (FirRegularClass)firDeclaration2) == null ? null : FirDeclarationUtilKt.getClassId(firRegularClass2)), (Object)$this$toRegularClass)) continue;
                    firDeclaration = element$iv;
                    break block6;
                }
                firDeclaration = null;
            }
            FirDeclaration $this$safeAs$iv = firDeclaration;
            boolean $i$f$safeAs = false;
            FirDeclaration firDeclaration3 = $this$safeAs$iv;
            if (!(firDeclaration3 instanceof FirRegularClass)) {
                firDeclaration3 = null;
            }
            firRegularClass = (FirRegularClass)firDeclaration3;
        }
        return firRegularClass;
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getSEALED_CLASS_CONSTRUCTOR_CALL().on(it));
        }
    }
}

