/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.dsl.ComponentMetadataHandlerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultSourceSetContainer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.component.external.model.JavaEcosystemVariantDerivationStrategy;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;

public class JvmEcosystemPlugin
implements Plugin<Project> {
    private final ObjectFactory objectFactory;
    private final JvmPluginServices jvmPluginServices;

    @Inject
    public JvmEcosystemPlugin(ObjectFactory objectFactory, JvmPluginServices jvmPluginServices) {
        this.objectFactory = objectFactory;
        this.jvmPluginServices = jvmPluginServices;
    }

    public void apply(Project project) {
        ProjectInternal p = (ProjectInternal)project;
        SourceSetContainer sourceSets = this.createSourceSets(p);
        this.configureVariantDerivationStrategy(p);
        this.configureSchema(p);
        this.jvmPluginServices.inject(p, sourceSets);
    }

    private SourceSetContainer createSourceSets(ProjectInternal p) {
        DefaultSourceSetContainer sourceSets = (DefaultSourceSetContainer)this.objectFactory.newInstance(DefaultSourceSetContainer.class, new Object[0]);
        p.getExtensions().add(SourceSetContainer.class, "sourceSets", (Object)sourceSets);
        return sourceSets;
    }

    private void configureVariantDerivationStrategy(ProjectInternal project) {
        ComponentMetadataHandlerInternal metadataHandler = (ComponentMetadataHandlerInternal)project.getDependencies().getComponents();
        metadataHandler.setVariantDerivationStrategy((VariantDerivationStrategy)JavaEcosystemVariantDerivationStrategy.getInstance());
    }

    private void configureSchema(ProjectInternal project) {
        AttributesSchema attributesSchema = project.getDependencies().getAttributesSchema();
        JavaEcosystemSupport.configureSchema((AttributesSchema)attributesSchema, (ObjectFactory)this.objectFactory);
        ((ArtifactTypeDefinition)project.getDependencies().getArtifactTypes().create("jar")).getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.objectFactory.named(Usage.class, "java-runtime"))).attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.objectFactory.named(LibraryElements.class, "jar")));
    }
}

