/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;

public class ClassDependentsAccumulator {
    private final Set<String> dependenciesToAll = new HashSet<String>();
    private final Map<String, Set<String>> privateDependents = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> accessibleDependents = new HashMap<String, Set<String>>();
    private final ImmutableMap.Builder<String, IntSet> classesToConstants = ImmutableMap.builder();
    private final Set<String> seenClasses = new HashSet<String>();
    private String fullRebuildCause;

    public void addClass(ClassAnalysis classAnalysis) {
        this.addClass(classAnalysis.getClassName(), classAnalysis.isDependencyToAll(), classAnalysis.getPrivateClassDependencies(), classAnalysis.getAccessibleClassDependencies(), classAnalysis.getConstants());
    }

    public void addClass(String className, boolean dependencyToAll, Iterable<String> privateClassDependencies, Iterable<String> accessibleClassDependencies, IntSet constants) {
        if (this.seenClasses.contains(className)) {
            return;
        }
        this.seenClasses.add(className);
        if (!constants.isEmpty()) {
            this.classesToConstants.put((Object)className, (Object)constants);
        }
        if (dependencyToAll) {
            this.dependenciesToAll.add(className);
            this.privateDependents.remove(className);
            this.accessibleDependents.remove(className);
        }
        for (String dependency : privateClassDependencies) {
            if (dependency.equals(className) || this.dependenciesToAll.contains(dependency)) continue;
            this.addDependency(this.privateDependents, dependency, className);
        }
        for (String dependency : accessibleClassDependencies) {
            if (dependency.equals(className) || this.dependenciesToAll.contains(dependency)) continue;
            this.addDependency(this.accessibleDependents, dependency, className);
        }
    }

    private Set<String> rememberClass(Map<String, Set<String>> dependents, String className) {
        Set<String> d = dependents.get(className);
        if (d == null) {
            d = new HashSet<String>();
            dependents.put(className, d);
        }
        return d;
    }

    @VisibleForTesting
    Map<String, DependentsSet> getDependentsMap() {
        if (this.dependenciesToAll.isEmpty() && this.privateDependents.isEmpty() && this.accessibleDependents.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String s : this.dependenciesToAll) {
            builder.put((Object)s, (Object)DependentsSet.dependencyToAll());
        }
        HashSet<String> collected = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : this.accessibleDependents.entrySet()) {
            if (!collected.add(entry.getKey())) continue;
            builder.put((Object)entry.getKey(), (Object)DependentsSet.dependentClasses(this.privateDependents.getOrDefault(entry.getKey(), Collections.emptySet()), entry.getValue()));
        }
        for (Map.Entry<String, Set<String>> entry : this.privateDependents.entrySet()) {
            if (!collected.add(entry.getKey())) continue;
            builder.put((Object)entry.getKey(), (Object)DependentsSet.dependentClasses(entry.getValue(), this.accessibleDependents.getOrDefault(entry.getKey(), Collections.emptySet())));
        }
        return builder.build();
    }

    @VisibleForTesting
    Map<String, IntSet> getClassesToConstants() {
        return this.classesToConstants.build();
    }

    private void addDependency(Map<String, Set<String>> dependentsMap, String dependency, String dependent) {
        Set<String> dependents = this.rememberClass(dependentsMap, dependency);
        dependents.add(dependent);
    }

    public void fullRebuildNeeded(String fullRebuildCause) {
        this.fullRebuildCause = fullRebuildCause;
    }

    public ClassSetAnalysisData getAnalysis() {
        return new ClassSetAnalysisData((Set<String>)ImmutableSet.copyOf(this.seenClasses), this.getDependentsMap(), this.getClassesToConstants(), this.fullRebuildCause);
    }
}

