/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.HashSet;
import java.util.Set;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.provider.BuildModelAction;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;

public class BuildModelActionRunner
implements BuildActionRunner {
    public BuildActionRunner.Result run(BuildAction action, BuildController buildController) {
        if (!(action instanceof BuildModelAction)) {
            return BuildActionRunner.Result.nothing();
        }
        BuildModelAction buildModelAction = (BuildModelAction)action;
        GradleInternal gradle = buildController.getGradle();
        BuildResultAdapter listener = new BuildResultAdapter(gradle, buildModelAction);
        RuntimeException buildFailure = null;
        RuntimeException clientFailure = null;
        try {
            gradle.addBuildListener((BuildListener)listener);
            if (buildModelAction.isModelRequest()) {
                gradle.getStartParameter().setConfigureOnDemand(false);
            }
            if (buildModelAction.isRunTasks()) {
                buildController.run();
            } else {
                buildController.configure();
            }
        }
        catch (RuntimeException e) {
            buildFailure = e;
            clientFailure = e;
        }
        if (listener.modelFailure != null) {
            clientFailure = (RuntimeException)new InternalUnsupportedModelException().initCause((Throwable)listener.modelFailure);
        }
        if (buildFailure != null) {
            return BuildActionRunner.Result.failed((Throwable)buildFailure, (RuntimeException)clientFailure);
        }
        return BuildActionRunner.Result.of((Object)listener.result);
    }

    private static class BuildResultAdapter
    extends InternalBuildAdapter {
        private final GradleInternal gradle;
        private final BuildModelAction buildModelAction;
        private Object result;
        private RuntimeException modelFailure;

        private BuildResultAdapter(GradleInternal gradle, BuildModelAction buildModelAction) {
            this.gradle = gradle;
            this.buildModelAction = buildModelAction;
        }

        public void projectsEvaluated(Gradle gradle) {
            if (this.buildModelAction.isModelRequest()) {
                this.forceFullConfiguration((GradleInternal)gradle, new HashSet<GradleInternal>());
            }
        }

        public void buildFinished(BuildResult result) {
            if (result.getFailure() == null) {
                this.result = this.buildModel(this.gradle, this.buildModelAction);
            }
        }

        private Object buildModel(GradleInternal gradle, BuildModelAction buildModelAction) {
            String modelName = buildModelAction.getModelName();
            ToolingModelBuilderLookup.Builder builder = this.getModelBuilder(modelName, gradle);
            return builder.build(null);
        }

        private void forceFullConfiguration(GradleInternal gradle, Set<GradleInternal> alreadyConfigured) {
            ((ProjectConfigurer)gradle.getServices().get(ProjectConfigurer.class)).configureHierarchyFully(gradle.getRootProject());
            for (IncludedBuild includedBuild : gradle.getIncludedBuilds()) {
                GradleInternal build;
                if (!(includedBuild instanceof IncludedBuildState) || alreadyConfigured.contains(build = ((IncludedBuildState)includedBuild).getConfiguredBuild())) continue;
                alreadyConfigured.add(build);
                this.forceFullConfiguration(build, alreadyConfigured);
            }
        }

        private ToolingModelBuilderLookup.Builder getModelBuilder(String modelName, GradleInternal gradle) {
            ToolingModelBuilderLookup builderRegistry = BuildResultAdapter.getToolingModelBuilderRegistry(gradle);
            try {
                return builderRegistry.locateForClientOperation(modelName, false, gradle);
            }
            catch (UnknownModelException e) {
                this.modelFailure = e;
                throw e;
            }
        }

        private static ToolingModelBuilderLookup getToolingModelBuilderRegistry(GradleInternal gradle) {
            return (ToolingModelBuilderLookup)gradle.getDefaultProject().getServices().get(ToolingModelBuilderLookup.class);
        }
    }
}

