/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016R\u0018\u0010\b\u001a\f\u0012\b\u0012\u00060\nR\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0018\u00010\nR\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope;", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "parent", "description", "", "useParentScopeStack", "", "(Lorg/jetbrains/kotlin/js/backend/ast/JsScope;Ljava/lang/String;Z)V", "labelScopes", "Ljava/util/Stack;", "Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$LabelScope;", "topLabelScope", "getTopLabelScope", "()Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$LabelScope;", "enterLabel", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "label", "outputName", "exitLabel", "", "findLabel", "Companion", "LabelScope", "js.ast"})
public class JsDeclarationScope
extends JsScope {
    private final Stack<LabelScope> labelScopes;
    private static final Set<String> RESERVED_WORDS;
    @NotNull
    public static final Companion Companion;

    private final LabelScope getTopLabelScope() {
        Collection collection = this.labelScopes;
        boolean bl = false;
        return !collection.isEmpty() ? this.labelScopes.peek() : null;
    }

    @NotNull
    public JsName enterLabel(@NotNull String label, @NotNull String outputName) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)outputName, (String)"outputName");
        LabelScope scope2 = new LabelScope(this.getTopLabelScope(), label, outputName);
        this.labelScopes.push(scope2);
        return scope2.getLabelName();
    }

    public void exitLabel() {
        Collection collection = this.labelScopes;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl3 = false;
            String string2 = "No scope to exit from";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this.labelScopes.pop();
    }

    @Nullable
    public JsName findLabel(@NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        LabelScope labelScope = this.getTopLabelScope();
        return labelScope != null ? labelScope.findName(label) : null;
    }

    public JsDeclarationScope(@NotNull JsScope parent2, @NotNull String description2, boolean useParentScopeStack) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        super(parent2, description2);
        this.labelScopes = parent2 instanceof JsDeclarationScope && useParentScopeStack ? ((JsDeclarationScope)parent2).labelScopes : new Stack();
    }

    public /* synthetic */ JsDeclarationScope(JsScope jsScope, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(jsScope, string2, bl);
    }

    static {
        Companion = new Companion(null);
        RESERVED_WORDS = SetsKt.setOf((Object[])new String[]{"await", "break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "const", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield", "null", "true", "false", "eval", "arguments", "NaN", "isNaN", "Infinity", "undefined", "Error", "Object", "Math", "String", "Number", "Boolean", "Date", "Array", "RegExp", "JSON", "require", "define", "module", "window", "self", "Kotlin"});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$LabelScope;", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "parent", "Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope;", "ident", "", "outputIdent", "(Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope;Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$LabelScope;Ljava/lang/String;Ljava/lang/String;)V", "getIdent", "()Ljava/lang/String;", "labelName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getLabelName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "findOwnName", "name", "hasOwnName", "", "js.ast"})
    private final class LabelScope
    extends JsScope {
        private final JsName labelName;
        private final String ident;

        @NotNull
        public final JsName getLabelName() {
            return this.labelName;
        }

        @Override
        @Nullable
        protected JsName findOwnName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Intrinsics.areEqual((Object)name, (Object)this.ident) ? this.labelName : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasOwnName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (Companion.getRESERVED_WORDS().contains(name)) return true;
            if (Intrinsics.areEqual((Object)name, (Object)this.ident)) return true;
            JsName jsName = this.labelName;
            if (Intrinsics.areEqual((Object)name, (Object)(jsName != null ? jsName.getIdent() : null))) return true;
            JsScope jsScope = this.getParent();
            if (jsScope == null) return false;
            boolean bl = jsScope.hasOwnName(name);
            if (!bl) return false;
            return true;
        }

        @NotNull
        public final String getIdent() {
            return this.ident;
        }

        public LabelScope(@NotNull LabelScope parent2, @NotNull String ident, String outputIdent) {
            Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
            Intrinsics.checkNotNullParameter((Object)outputIdent, (String)"outputIdent");
            super(parent2, "Label scope for " + ident);
            this.ident = ident;
            this.labelName = new JsName(outputIdent, true);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$Companion;", "", "()V", "RESERVED_WORDS", "", "", "getRESERVED_WORDS", "()Ljava/util/Set;", "js.ast"})
    public static final class Companion {
        @NotNull
        public final Set<String> getRESERVED_WORDS() {
            return RESERVED_WORDS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

