/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;

public class DefaultArtifactIdentifier
implements ArtifactIdentifier {
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final String name;
    private final String type;
    private final String extension;
    private final String classifier;

    public DefaultArtifactIdentifier(ModuleVersionIdentifier moduleVersionIdentifier, String name, String type, @Nullable String extension, @Nullable String classifier) {
        this.moduleVersionIdentifier = moduleVersionIdentifier;
        this.name = name;
        this.type = type;
        this.extension = extension;
        this.classifier = classifier;
    }

    public DefaultArtifactIdentifier(DefaultModuleComponentArtifactIdentifier id) {
        this(DefaultModuleVersionIdentifier.newId(id.getComponentIdentifier()), id.getName().getName(), id.getName().getType(), id.getName().getExtension(), id.getName().getClassifier());
    }

    public ModuleVersionIdentifier getModuleVersionIdentifier() {
        return this.moduleVersionIdentifier;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String toString() {
        return String.format("module: %s, name: %s, ext: %s, classifier: %s", this.moduleVersionIdentifier, this.name, this.extension, this.classifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultArtifactIdentifier)) {
            return false;
        }
        DefaultArtifactIdentifier that = (DefaultArtifactIdentifier)o;
        if (!Objects.equals(this.classifier, that.classifier)) {
            return false;
        }
        if (!Objects.equals(this.extension, that.extension)) {
            return false;
        }
        if (!Objects.equals(this.moduleVersionIdentifier, that.moduleVersionIdentifier)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        int result = this.moduleVersionIdentifier != null ? this.moduleVersionIdentifier.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result;
    }
}

