/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirBlockImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.TransformData;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u001a;\u0010\u0017\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001c2\b\u0010\u001d\u001a\u0004\u0018\u0001H\u00182\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 \u001a\u0018\u0010!\u001a\u00020\"2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0018\u0010#\u001a\u00020$2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0012\u0010%\u001a\u00020&*\u00020'2\u0006\u0010(\u001a\u00020&\u001a\f\u0010)\u001a\u0004\u0018\u00010**\u00020\u0001\u001a\u0010\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010,*\u00020\u0001\u001a+\u0010-\u001a\u00020'\"\u0004\b\u0000\u0010.*\u00020'2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.002\u0006\u00101\u001a\u0002H.\u00a2\u0006\u0002\u00102\u001a8\u00103\u001a\u00020'\"\u0004\b\u0000\u0010.*\u00020'2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.002\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u0002H.0705\"\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"$\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00108\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00108\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00068"}, d2={"argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "getArgument", "(Lorg/jetbrains/kotlin/fir/expressions/FirCall;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "argumentMapping", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getArgumentMapping", "(Lorg/jetbrains/kotlin/fir/expressions/FirCall;)Ljava/util/Map;", "arguments", "", "getArguments", "(Lorg/jetbrains/kotlin/fir/expressions/FirCall;)Ljava/util/List;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "getClassId", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;)Lorg/jetbrains/kotlin/name/ClassId;", "coneClassLikeType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "getConeClassLikeType", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "buildConstOrErrorExpression", "T", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "kind", "Lorg/jetbrains/kotlin/fir/expressions/FirConstKind;", "value", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "(Lorg/jetbrains/kotlin/fir/FirSourceElement;Lorg/jetbrains/kotlin/fir/expressions/FirConstKind;Ljava/lang/Object;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "buildErrorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "buildErrorLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "replaceFirstStatement", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "statement", "toResolvedCallableReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "toResolvedCallableSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "transformAllStatementsExceptLast", "D", "transformer", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "data", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "transformStatementsIndexed", "dataProducer", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/fir/visitors/TransformData;", "tree"})
public final class FirExpressionUtilKt {
    @Nullable
    public static final ConeClassLikeType getConeClassLikeType(@NotNull FirAnnotationCall $this$coneClassLikeType) {
        int $i$f$getConeClassLikeType = 0;
        Intrinsics.checkNotNullParameter((Object)$this$coneClassLikeType, (String)"$this$coneClassLikeType");
        FirTypeRef firTypeRef = $this$coneClassLikeType.getAnnotationTypeRef();
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (ConeClassLikeType)coneKotlinType;
    }

    @Nullable
    public static final ClassId getClassId(@NotNull FirAnnotationCall $this$classId) {
        Object object;
        int $i$f$getClassId = 0;
        Intrinsics.checkNotNullParameter((Object)$this$classId, (String)"$this$classId");
        FirAnnotationCall $this$coneClassLikeType$iv = $this$classId;
        boolean $i$f$getConeClassLikeType = false;
        FirTypeRef firTypeRef = $this$coneClassLikeType$iv.getAnnotationTypeRef();
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (object = (ConeClassLikeType)coneKotlinType) != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final <T> FirExpression buildConstOrErrorExpression(@Nullable FirSourceElement source, @NotNull FirConstKind<T> kind, @Nullable T value2, @NotNull ConeDiagnostic diagnostic) {
        FirExpression firExpression2;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Object object = value2;
        if (object != null) {
            T t = object;
            bl2 = false;
            bl = false;
            T it = t;
            boolean bl3 = false;
            object = FirConstExpressionBuilderKt.buildConstExpression$default(source, kind, it, null, 8, null);
            if (object != null) {
                firExpression2 = (FirExpression)object;
                return firExpression2;
            }
        }
        boolean $i$f$buildErrorExpression = false;
        bl2 = false;
        FirErrorExpressionBuilder firErrorExpressionBuilder = new FirErrorExpressionBuilder();
        bl = false;
        boolean bl4 = false;
        FirErrorExpressionBuilder $this$buildErrorExpression = firErrorExpressionBuilder;
        boolean bl5 = false;
        $this$buildErrorExpression.setSource(source);
        $this$buildErrorExpression.setDiagnostic(diagnostic);
        firExpression2 = firErrorExpressionBuilder.build();
        return firExpression2;
    }

    @NotNull
    public static final List<FirExpression> getArguments(@NotNull FirCall $this$arguments) {
        int $i$f$getArguments = 0;
        Intrinsics.checkNotNullParameter((Object)$this$arguments, (String)"$this$arguments");
        return $this$arguments.getArgumentList().getArguments();
    }

    @NotNull
    public static final FirExpression getArgument(@NotNull FirCall $this$argument) {
        int $i$f$getArgument = 0;
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"$this$argument");
        return (FirExpression)CollectionsKt.first($this$argument.getArgumentList().getArguments());
    }

    @Nullable
    public static final Map<FirExpression, FirValueParameter> getArgumentMapping(@NotNull FirCall $this$argumentMapping) {
        int $i$f$getArgumentMapping = 0;
        Intrinsics.checkNotNullParameter((Object)$this$argumentMapping, (String)"$this$argumentMapping");
        FirArgumentList firArgumentList = $this$argumentMapping.getArgumentList();
        if (!(firArgumentList instanceof FirResolvedArgumentList)) {
            firArgumentList = null;
        }
        FirResolvedArgumentList firResolvedArgumentList = (FirResolvedArgumentList)firArgumentList;
        return firResolvedArgumentList != null ? firResolvedArgumentList.getMapping() : null;
    }

    @Nullable
    public static final FirResolvedNamedReference toResolvedCallableReference(@NotNull FirExpression $this$toResolvedCallableReference) {
        Intrinsics.checkNotNullParameter((Object)$this$toResolvedCallableReference, (String)"$this$toResolvedCallableReference");
        FirExpression firExpression2 = $this$toResolvedCallableReference;
        if (!(firExpression2 instanceof FirResolvable)) {
            firExpression2 = null;
        }
        FirResolvable firResolvable = (FirResolvable)((Object)firExpression2);
        FirReference firReference = firResolvable != null ? firResolvable.getCalleeReference() : null;
        if (!(firReference instanceof FirResolvedNamedReference)) {
            firReference = null;
        }
        return (FirResolvedNamedReference)firReference;
    }

    @Nullable
    public static final FirCallableSymbol<?> toResolvedCallableSymbol(@NotNull FirExpression $this$toResolvedCallableSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$toResolvedCallableSymbol, (String)"$this$toResolvedCallableSymbol");
        FirResolvedNamedReference firResolvedNamedReference = FirExpressionUtilKt.toResolvedCallableReference($this$toResolvedCallableSymbol);
        return (FirCallableSymbol)(firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null);
    }

    @NotNull
    public static final FirErrorLoop buildErrorLoop(@Nullable FirSourceElement source, @NotNull ConeDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        boolean $i$f$buildErrorLoop = false;
        boolean bl = false;
        FirErrorLoopBuilder firErrorLoopBuilder = new FirErrorLoopBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirErrorLoopBuilder $this$buildErrorLoop = firErrorLoopBuilder;
        boolean bl4 = false;
        $this$buildErrorLoop.setSource(source);
        $this$buildErrorLoop.setDiagnostic(diagnostic);
        return firErrorLoopBuilder.build();
    }

    @NotNull
    public static final FirErrorExpression buildErrorExpression(@Nullable FirSourceElement source, @NotNull ConeDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        boolean $i$f$buildErrorExpression = false;
        boolean bl = false;
        FirErrorExpressionBuilder firErrorExpressionBuilder = new FirErrorExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirErrorExpressionBuilder $this$buildErrorExpression = firErrorExpressionBuilder;
        boolean bl4 = false;
        $this$buildErrorExpression.setSource(source);
        $this$buildErrorExpression.setDiagnostic(diagnostic);
        return firErrorExpressionBuilder.build();
    }

    @NotNull
    public static final <D> FirBlock transformStatementsIndexed(@NotNull FirBlock $this$transformStatementsIndexed, @NotNull FirTransformer<? super D> transformer2, @NotNull Function1<? super Integer, ? extends TransformData<? extends D>> dataProducer) {
        block6: {
            TransformData.Data data;
            FirBlock firBlock;
            block5: {
                Intrinsics.checkNotNullParameter((Object)$this$transformStatementsIndexed, (String)"$this$transformStatementsIndexed");
                Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
                Intrinsics.checkNotNullParameter(dataProducer, (String)"dataProducer");
                firBlock = $this$transformStatementsIndexed;
                if (!(firBlock instanceof FirBlockImpl)) break block5;
                List<FirStatement> $this$transformInplace$iv = ((FirBlockImpl)$this$transformStatementsIndexed).getStatements();
                boolean $i$f$transformInplace = false;
                ListIterator<FirStatement> iterator$iv = $this$transformInplace$iv.listIterator();
                int index$iv = 0;
                while (iterator$iv.hasNext()) {
                    FirStatement firStatement = iterator$iv.next();
                    if (firStatement == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirPureAbstractElement");
                    }
                    FirPureAbstractElement next$iv = (FirPureAbstractElement)((Object)firStatement);
                    Integer n = index$iv;
                    ++index$iv;
                    TransformData data$iv = (TransformData)dataProducer.invoke((Object)n);
                    if (!(data$iv instanceof TransformData.Data)) {
                        if (Intrinsics.areEqual((Object)data$iv, (Object)TransformData.Nothing.INSTANCE)) continue;
                        throw new NoWhenBranchMatchedException();
                    }
                    Object data$iv2 = ((TransformData.Data)data$iv).getValue();
                    FirElement result$iv = (FirElement)next$iv.transform(transformer2, data$iv2).getSingle();
                    iterator$iv.set((FirStatement)result$iv);
                }
                break block6;
            }
            if (!(firBlock instanceof FirSingleExpressionBlock)) break block6;
            Object object = dataProducer.invoke((Object)0);
            if (!(object instanceof TransformData.Data)) {
                object = null;
            }
            if ((data = (TransformData.Data)object) != null && (data = data.getValue()) != null) {
                TransformData.Data data2 = data;
                boolean bl = false;
                boolean bl2 = false;
                TransformData.Data it = data2;
                boolean bl3 = false;
                $this$transformStatementsIndexed.transformStatements(transformer2, it);
            }
        }
        return $this$transformStatementsIndexed;
    }

    @NotNull
    public static final <D> FirBlock transformAllStatementsExceptLast(@NotNull FirBlock $this$transformAllStatementsExceptLast, @NotNull FirTransformer<? super D> transformer2, D data) {
        Intrinsics.checkNotNullParameter((Object)$this$transformAllStatementsExceptLast, (String)"$this$transformAllStatementsExceptLast");
        Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
        int threshold = $this$transformAllStatementsExceptLast.getStatements().size() - 1;
        return FirExpressionUtilKt.transformStatementsIndexed($this$transformAllStatementsExceptLast, transformer2, (Function1)new Function1<Integer, TransformData<? extends D>>(threshold, data){
            final /* synthetic */ int $threshold;
            final /* synthetic */ Object $data;

            @NotNull
            public final TransformData<D> invoke(int index2) {
                return index2 < this.$threshold ? (TransformData)new TransformData.Data<Object>(this.$data) : (TransformData)TransformData.Nothing.INSTANCE;
            }
            {
                this.$threshold = n;
                this.$data = object;
                super(1);
            }
        });
    }

    @NotNull
    public static final FirStatement replaceFirstStatement(@NotNull FirBlock $this$replaceFirstStatement, @NotNull FirStatement statement2) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceFirstStatement, (String)"$this$replaceFirstStatement");
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        boolean bl = $this$replaceFirstStatement instanceof FirBlockImpl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "replaceFirstStatement should not be called for " + Reflection.getOrCreateKotlinClass($this$replaceFirstStatement.getClass()).getSimpleName();
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        FirStatement existed = ((FirBlockImpl)$this$replaceFirstStatement).getStatements().get(0);
        ((FirBlockImpl)$this$replaceFirstStatement).getStatements().set(0, statement2);
        return existed;
    }
}

