/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadActionProcessor;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbAware;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.roots.PackageIndex;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwnerEx;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.JavaFileManager;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTreeLoader;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiClassUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class PsiElementFinderImpl
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;
    private final JavaFileManager myFileManager;

    public PsiElementFinderImpl(Project project) {
        this.myProject = project;
        this.myFileManager = JavaFileManager.getInstance(project);
    }

    @Deprecated
    public PsiElementFinderImpl(Project project, JavaFileManager javaFileManager) {
        this.myProject = project;
        this.myFileManager = javaFileManager;
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(0);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(1);
        }
        return this.myFileManager.findClass(qualifiedName, scope2);
    }

    @Override
    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(2);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(3);
        }
        PsiClass[] psiClassArray = this.myFileManager.findClasses(qualifiedName, scope2);
        if (psiClassArray == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(5);
        }
        return this.myFileManager.findPackage(qualifiedName);
    }

    @Override
    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(6);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(7);
        }
        HashMap<String, PsiPackage> packagesMap = new HashMap<String, PsiPackage>();
        String qualifiedName = psiPackage.getQualifiedName();
        for (PsiDirectory dir : psiPackage.getDirectories(scope2)) {
            PsiDirectory[] subDirs;
            for (PsiDirectory subDir : subDirs = dir.getSubdirectories()) {
                String subQualifiedName;
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subDir);
                if (aPackage == null || !(subQualifiedName = aPackage.getQualifiedName()).startsWith(qualifiedName) || packagesMap.containsKey(subQualifiedName)) continue;
                packagesMap.put(aPackage.getQualifiedName(), aPackage);
            }
        }
        packagesMap.remove(qualifiedName);
        PsiPackage[] psiPackageArray = packagesMap.values().toArray(PsiPackage.EMPTY_ARRAY);
        if (psiPackageArray == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(8);
        }
        return psiPackageArray;
    }

    @Override
    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(9);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(10);
        }
        PsiClass[] psiClassArray = this.getClasses(null, psiPackage, scope2);
        if (psiClassArray == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    @Override
    public PsiClass @NotNull [] getClasses(@Nullable String shortName, @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(12);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(13);
        }
        ArrayList<PsiClass> list2 = null;
        String packageName = psiPackage.getQualifiedName();
        for (PsiDirectory dir : psiPackage.getDirectories(scope2)) {
            PsiClass[] classes2 = JavaDirectoryService.getInstance().getClasses(dir);
            if (classes2.length == 0) continue;
            if (list2 == null) {
                list2 = new ArrayList<PsiClass>();
            }
            for (PsiClass aClass2 : classes2) {
                String qualifiedName = aClass2.getQualifiedName();
                if (qualifiedName != null) {
                    qualifiedName = StringUtil.getPackageName(qualifiedName);
                }
                if (!Comparing.strEqual(qualifiedName, packageName) || shortName != null && !shortName.equals(aClass2.getName())) continue;
                list2.add(aClass2);
            }
        }
        if (list2 == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiElementFinderImpl.$$$reportNull$$$0(14);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (list2.size() > 1) {
            ContainerUtil.quickSort(list2, PsiClassUtil.createScopeComparator(scope2));
        }
        PsiClass[] psiClassArray = list2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(15);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(16);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(17);
        }
        HashSet<String> names2 = null;
        FileIndexFacade facade = FileIndexFacade.getInstance(this.myProject);
        for (PsiDirectory dir : psiPackage.getDirectories(scope2)) {
            for (PsiFile file2 : dir.getFiles()) {
                Set<String> inFile;
                VirtualFile vFile;
                if (!(file2 instanceof PsiClassOwner) || file2.getViewProvider().getLanguages().size() != 1 || (vFile = file2.getVirtualFile()) != null && !(file2 instanceof PsiCompiledElement) && !facade.isInSourceContent(vFile) && (!scope2.isForceSearchingInLibrarySources() || !StubTreeLoader.getInstance().canHaveStub(vFile))) continue;
                Set<String> set = inFile = file2 instanceof PsiClassOwnerEx ? ((PsiClassOwnerEx)file2).getClassNames() : PsiElementFinderImpl.getClassNames(((PsiClassOwner)file2).getClasses());
                if (inFile.isEmpty()) continue;
                if (names2 == null) {
                    names2 = new HashSet<String>();
                }
                names2.addAll(inFile);
            }
        }
        Set<String> set = names2 == null ? Collections.emptySet() : names2;
        if (set == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(18);
        }
        return set;
    }

    @Override
    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope2, final @NotNull Processor<? super PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(19);
        }
        if (scope2 == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            PsiElementFinderImpl.$$$reportNull$$$0(21);
        }
        final PsiManager psiManager = PsiManager.getInstance(this.myProject);
        return PackageIndex.getInstance(this.myProject).getDirsByPackageName(psiPackage.getQualifiedName(), includeLibrarySources).forEach((Processor<VirtualFile>)new ReadActionProcessor<VirtualFile>(){

            @Override
            public boolean processInReadAction(VirtualFile dir) {
                if (!scope2.contains(dir)) {
                    return true;
                }
                PsiDirectory psiDir = psiManager.findDirectory(dir);
                return psiDir == null || consumer.process(psiDir);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFinderImpl";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFinderImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDirectories";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

