/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.PropertyResourceBundleFallbackCharset;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshotContext;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.UnionResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.ZipEntryContext;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileAwareClasspathResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileAwareClasspathResourceHasher.class);
    private final ResourceHasher delegate;
    private final Map<PathMatcher, ResourceEntryFilter> propertiesFileFilters;
    private final List<String> propertiesFilePatterns;

    public PropertiesFileAwareClasspathResourceHasher(ResourceHasher delegate, Map<String, ResourceEntryFilter> propertiesFileFilters) {
        this.delegate = delegate;
        ImmutableList.Builder patterns = ImmutableList.builder();
        ImmutableMap.Builder filters = ImmutableMap.builder();
        propertiesFileFilters.forEach((pattern, resourceEntryFilter) -> {
            filters.put((Object)PatternMatcherFactory.compile((boolean)false, (String)pattern), resourceEntryFilter);
            patterns.add(pattern);
        });
        this.propertiesFileFilters = filters.build();
        this.propertiesFilePatterns = patterns.build();
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.propertiesFilePatterns.forEach(arg_0 -> ((Hasher)hasher).putString(arg_0));
        this.propertiesFileFilters.values().forEach(resourceEntryFilter -> resourceEntryFilter.appendConfigurationToHasher(hasher));
    }

    @Override
    @Nullable
    public HashCode hash(RegularFileSnapshotContext snapshotContext) {
        HashCode hashCode;
        ResourceEntryFilter resourceEntryFilter = this.matchingFiltersFor(snapshotContext.getRelativePathSegments());
        if (resourceEntryFilter == null) {
            return this.delegate.hash(snapshotContext);
        }
        FileInputStream propertiesFileInputStream = new FileInputStream(snapshotContext.getSnapshot().getAbsolutePath());
        try {
            hashCode = this.hashProperties(propertiesFileInputStream, resourceEntryFilter);
        }
        catch (Throwable throwable) {
            try {
                try {
                    propertiesFileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.debug("Could not load fingerprint for " + snapshotContext.getSnapshot().getAbsolutePath() + ". Falling back to full entry fingerprinting", (Throwable)e);
                return this.delegate.hash(snapshotContext);
            }
        }
        propertiesFileInputStream.close();
        return hashCode;
    }

    @Override
    @Nullable
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        ResourceEntryFilter resourceEntryFilter = this.matchingFiltersFor(zipEntryContext.getRelativePathSegments());
        if (resourceEntryFilter == null) {
            return this.delegate.hash(zipEntryContext);
        }
        try {
            return this.hashProperties(zipEntryContext.getEntry().getInputStream(), resourceEntryFilter);
        }
        catch (Exception e) {
            LOGGER.debug("Could not load fingerprint for " + zipEntryContext.getRootParentName() + "!" + zipEntryContext.getFullName() + ". Falling back to full entry fingerprinting", (Throwable)e);
            return this.delegate.hash(zipEntryContext);
        }
    }

    @Nullable
    private ResourceEntryFilter matchingFiltersFor(Supplier<String[]> relativePathSegments) {
        List<ResourceEntryFilter> matchingFilters = this.propertiesFileFilters.entrySet().stream().filter(entry -> ((PathMatcher)entry.getKey()).matches((String[])relativePathSegments.get(), 0)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (matchingFilters.size() == 0) {
            return null;
        }
        if (matchingFilters.size() == 1) {
            return (ResourceEntryFilter)matchingFilters.get(0);
        }
        return new UnionResourceEntryFilter(matchingFilters);
    }

    private HashCode hashProperties(InputStream inputStream, ResourceEntryFilter propertyResourceFilter) throws IOException {
        Hasher hasher = Hashing.newHasher();
        Properties properties = new Properties();
        properties.load(new InputStreamReader(inputStream, new PropertyResourceBundleFallbackCharset()));
        ImmutableMap entries = Maps.fromProperties((Properties)properties);
        entries.entrySet().stream().filter(entry -> !propertyResourceFilter.shouldBeIgnored((String)entry.getKey())).sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            hasher.putString((CharSequence)entry.getKey());
            hasher.putString((CharSequence)entry.getValue());
        });
        return hasher.hash();
    }
}

