/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001fH\u0016R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SingletonReferencesLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "constructingEnums", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "Lkotlin/collections/ArrayList;", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isVisitingSuperConstructor", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "thisOfClass", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "declaration", "allowConstructorReceiver", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitGetEnumValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "backend.jvm"})
final class SingletonReferencesLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    private final ArrayList<IrDeclarationParent> constructingEnums;
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        UtilsKt.push(this.constructingEnums, ((IrConstructor)expression2.getSymbol().getOwner()).getParent());
        IrExpression call2 = super.visitEnumConstructorCall(expression2);
        UtilsKt.pop(this.constructingEnums);
        return call2;
    }

    @Override
    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrDeclarationReference irDeclarationReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClass candidate2 = ((IrEnumEntry)expression2.getSymbol().getOwner()).getCorrespondingClass();
        IrValueParameter appropriateThis = SingletonReferencesLowering.thisOfClass$default(this, candidate2, false, 2, null);
        if (candidate2 != null && appropriateThis != null && !this.isVisitingSuperConstructor(candidate2)) {
            irDeclarationReference = new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), appropriateThis.getSymbol(), null, 16, null);
        } else {
            IrField entrySymbol = this.context.getCachedDeclarations$backend_jvm().getFieldForEnumEntry((IrEnumEntry)expression2.getSymbol().getOwner());
            irDeclarationReference = new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), (IrFieldSymbol)entrySymbol.getSymbol(), expression2.getType(), null, null, 48, null);
        }
        return irDeclarationReference;
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueParameter irValueParameter = this.thisOfClass((IrClass)expression2.getSymbol().getOwner(), false);
            if (irValueParameter != null) {
                IrValueParameter irValueParameter2 = irValueParameter;
                boolean bl2 = false;
                boolean bl3 = false;
                IrValueParameter it = irValueParameter2;
                boolean bl4 = false;
                return new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getSymbol(), null, 8, null);
            }
            Iterable $this$any$iv = this.getAllScopes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScopeWithIr it = (ScopeWithIr)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it.getIrElement(), (Object)((IrClass)expression2.getSymbol().getOwner()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        IrField instanceField = bl ? this.context.getCachedDeclarations$backend_jvm().getPrivateFieldForObjectInstance((IrClass)expression2.getSymbol().getOwner()) : this.context.getCachedDeclarations$backend_jvm().getFieldForObjectInstance((IrClass)expression2.getSymbol().getOwner());
        return new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), (IrFieldSymbol)instanceField.getSymbol(), expression2.getType(), null, null, 48, null);
    }

    private final IrValueParameter thisOfClass(IrClass declaration2, boolean allowConstructorReceiver) {
        if (declaration2 == null) {
            return null;
        }
        for (ScopeWithIr scope2 : CollectionsKt.reversed((Iterable)this.getAllScopes())) {
            IrElement element = scope2.getIrElement();
            if (element instanceof IrFunction) {
                IrValueParameter irValueParameter;
                if (((IrFunction)element).getDispatchReceiverParameter() == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                IrValueParameter it = irValueParameter;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)IrTypesKt.getClassOrNull(it.getType()), (Object)((IrClassSymbol)declaration2.getSymbol()))) continue;
                return it;
            }
            if (!(element instanceof IrClass) || !allowConstructorReceiver || !Intrinsics.areEqual((Object)element, (Object)declaration2)) continue;
            return ((IrClass)element).getThisReceiver();
        }
        return null;
    }

    static /* synthetic */ IrValueParameter thisOfClass$default(SingletonReferencesLowering singletonReferencesLowering, IrClass irClass2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return singletonReferencesLowering.thisOfClass(irClass2, bl);
    }

    private final boolean isVisitingSuperConstructor(IrClass irClass2) {
        return Intrinsics.areEqual((Object)irClass2.getParent(), (Object)((IrDeclarationParent)CollectionsKt.lastOrNull((List)this.constructingEnums)));
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public SingletonReferencesLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        boolean bl = false;
        this.constructingEnums = new ArrayList();
    }
}

