/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal.autoapply;

import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.invocation.Gradle;
import org.gradle.plugin.management.internal.DefaultPluginRequest;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedGradleEnterprisePlugin;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginRegistry;

public class DefaultAutoAppliedPluginRegistry
implements AutoAppliedPluginRegistry {
    private static final PluginRequests GRADLE_ENTERPRISE_PLUGIN_REQUEST = PluginRequests.of((PluginRequestInternal)DefaultAutoAppliedPluginRegistry.createGradleEnterprisePluginRequest());
    private final BuildDefinition buildDefinition;

    public DefaultAutoAppliedPluginRegistry(BuildDefinition buildDefinition) {
        this.buildDefinition = buildDefinition;
    }

    public PluginRequests getAutoAppliedPlugins(Project target) {
        return PluginRequests.EMPTY;
    }

    public PluginRequests getAutoAppliedPlugins(Settings target) {
        if (((StartParameterInternal)target.getStartParameter()).isUseEmptySettingsWithoutDeprecationWarning()) {
            return PluginRequests.EMPTY;
        }
        PluginRequests injectedPluginRequests = this.buildDefinition.getInjectedPluginRequests();
        if (this.shouldApplyGradleEnterprisePlugin(target)) {
            return injectedPluginRequests.mergeWith(GRADLE_ENTERPRISE_PLUGIN_REQUEST);
        }
        return injectedPluginRequests;
    }

    private boolean shouldApplyGradleEnterprisePlugin(Settings settings) {
        Gradle gradle = settings.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        return startParameter.isBuildScan() && gradle.getParent() == null;
    }

    private static PluginRequestInternal createGradleEnterprisePluginRequest() {
        ModuleIdentifier moduleIdentifier = DefaultModuleIdentifier.newId((String)"com.gradle", (String)"gradle-enterprise-gradle-plugin");
        ModuleVersionSelector artifact = DefaultModuleVersionSelector.newSelector((ModuleIdentifier)moduleIdentifier, (String)"3.5");
        return new DefaultPluginRequest(AutoAppliedGradleEnterprisePlugin.ID, "3.5", true, null, DefaultAutoAppliedPluginRegistry.getScriptDisplayName(), artifact);
    }

    private static String getScriptDisplayName() {
        return String.format("auto-applied by using --%s", "scan");
    }
}

