/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class JUnitPlatformTestExecutionListener
implements TestExecutionListener {
    private static final String DISPLAY_NAME = "org.junit.jupiter.api.DisplayName";
    private final ConcurrentMap<String, TestDescriptorInternal> descriptorsByUniqueId = new ConcurrentHashMap<String, TestDescriptorInternal>();
    private final TestResultProcessor resultProcessor;
    private final Clock clock;
    private final IdGenerator<?> idGenerator;
    private TestPlan currentTestPlan;

    public JUnitPlatformTestExecutionListener(TestResultProcessor resultProcessor, Clock clock, IdGenerator<?> idGenerator) {
        this.resultProcessor = resultProcessor;
        this.clock = clock;
        this.idGenerator = idGenerator;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.currentTestPlan = testPlan;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.currentTestPlan = null;
        this.descriptorsByUniqueId.clear();
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.executionSkipped(testIdentifier);
    }

    private void executionSkipped(TestIdentifier testIdentifier) {
        this.executionStarted(testIdentifier);
        this.reportSkipped(testIdentifier);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest() || JUnitPlatformTestExecutionListener.isClass(testIdentifier)) {
            this.reportStartedUnlessAlreadyStarted(testIdentifier);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
            this.reportSkipped(testIdentifier);
            return;
        }
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
            this.reportStartedUnlessAlreadyStarted(testIdentifier);
            Throwable failure = testExecutionResult.getThrowable().orElseGet(() -> new AssertionError((Object)"test failed but did not report an exception"));
            if (testIdentifier.isTest()) {
                this.resultProcessor.failure(this.getId(testIdentifier), failure);
            } else {
                TestDescriptorInternal syntheticTestDescriptor = this.createSyntheticTestDescriptorForContainer(testIdentifier);
                this.resultProcessor.started(syntheticTestDescriptor, this.startEvent(this.getId(testIdentifier)));
                this.resultProcessor.failure(syntheticTestDescriptor.getId(), failure);
                this.resultProcessor.completed(syntheticTestDescriptor.getId(), this.completeEvent());
            }
        }
        if (this.wasStarted(testIdentifier)) {
            this.resultProcessor.completed(this.getId(testIdentifier), this.completeEvent());
        }
    }

    private void reportStartedUnlessAlreadyStarted(TestIdentifier testIdentifier) {
        boolean wasNotAlreadyStarted = this.createDescriptorIfAbsent(testIdentifier);
        if (wasNotAlreadyStarted) {
            TestDescriptorInternal descriptor = (TestDescriptorInternal)this.descriptorsByUniqueId.get(testIdentifier.getUniqueId());
            this.resultProcessor.started(descriptor, this.startEvent(testIdentifier));
        }
    }

    private void reportSkipped(TestIdentifier testIdentifier) {
        this.currentTestPlan.getChildren(testIdentifier).stream().filter(child -> !this.wasStarted((TestIdentifier)child)).forEach(child -> this.executionSkipped((TestIdentifier)child));
        if (testIdentifier.isTest()) {
            this.resultProcessor.completed(this.getId(testIdentifier), this.completeEvent(TestResult.ResultType.SKIPPED));
        } else if (JUnitPlatformTestExecutionListener.isClass(testIdentifier)) {
            this.resultProcessor.completed(this.getId(testIdentifier), this.completeEvent());
        }
    }

    private TestStartEvent startEvent(TestIdentifier testIdentifier) {
        Object idOfClosestStartedAncestor = this.getAncestors(testIdentifier).stream().map(TestIdentifier::getUniqueId).filter(this.descriptorsByUniqueId::containsKey).findFirst().map(this.descriptorsByUniqueId::get).map(TestDescriptorInternal::getId).orElse(null);
        return this.startEvent((Object)idOfClosestStartedAncestor);
    }

    private TestStartEvent startEvent(Object parentId) {
        return new TestStartEvent(this.clock.getCurrentTime(), parentId);
    }

    private TestCompleteEvent completeEvent() {
        return this.completeEvent(null);
    }

    private TestCompleteEvent completeEvent(TestResult.ResultType resultType) {
        return new TestCompleteEvent(this.clock.getCurrentTime(), resultType);
    }

    private boolean wasStarted(TestIdentifier testIdentifier) {
        return this.descriptorsByUniqueId.containsKey(testIdentifier.getUniqueId());
    }

    private boolean createDescriptorIfAbsent(TestIdentifier node) {
        MutableBoolean wasCreated = new MutableBoolean(false);
        this.descriptorsByUniqueId.computeIfAbsent(node.getUniqueId(), uniqueId -> {
            wasCreated.set(true);
            if (node.getType() == TestDescriptor.Type.CONTAINER || JUnitPlatformTestExecutionListener.isClass(node) && !this.hasSameSourceAsAncestor(node)) {
                TestIdentifier classIdentifier = this.findClassSource(node);
                String className = this.className(classIdentifier);
                boolean hasDisplayNameAnnotation = this.hasDisplayNameAnnotation(classIdentifier);
                String classDisplayName = hasDisplayNameAnnotation ? this.classDisplayName(classIdentifier) : (String)JUnitPlatformTestExecutionListener.innerClassName(classIdentifier).orElse(null);
                return new DefaultTestClassDescriptor(this.idGenerator.generateId(), className, classDisplayName);
            }
            return this.createTestDescriptor(node, node.getLegacyReportingName(), node.getDisplayName());
        });
        return wasCreated.get();
    }

    private static Optional<String> innerClassName(TestIdentifier classIdentifier) {
        ClassSource classSource;
        Class javaClass;
        if (classIdentifier != null && JUnitPlatformTestExecutionListener.isClass(classIdentifier) && (javaClass = (classSource = JUnitPlatformTestExecutionListener.classSourceFor(classIdentifier)).getJavaClass()) != null && javaClass.getEnclosingClass() != null) {
            return Optional.of(javaClass.getSimpleName());
        }
        return Optional.empty();
    }

    private TestDescriptorInternal createSyntheticTestDescriptorForContainer(TestIdentifier node) {
        boolean testsStarted = this.currentTestPlan.getDescendants(node).stream().anyMatch(this::wasStarted);
        String name = testsStarted ? "executionError" : "initializationError";
        return this.createTestDescriptor(node, name, name);
    }

    private TestDescriptorInternal createTestDescriptor(TestIdentifier test, String name, String displayName) {
        TestIdentifier classIdentifier = this.findClassSource(test);
        String className = this.className(classIdentifier);
        boolean hasDisplayNameAnnotation = this.hasDisplayNameAnnotation(classIdentifier);
        String classDisplayName = hasDisplayNameAnnotation ? this.classDisplayName(classIdentifier) : null;
        return new DefaultTestDescriptor(this.idGenerator.generateId(), className, name, classDisplayName, displayName);
    }

    private Object getId(TestIdentifier testIdentifier) {
        return ((TestDescriptorInternal)this.descriptorsByUniqueId.get(testIdentifier.getUniqueId())).getId();
    }

    private Set<TestIdentifier> getAncestors(TestIdentifier testIdentifier) {
        LinkedHashSet<TestIdentifier> result = new LinkedHashSet<TestIdentifier>();
        Optional parentId = testIdentifier.getParentId();
        while (parentId.isPresent()) {
            TestIdentifier parent = this.currentTestPlan.getTestIdentifier((String)parentId.get());
            result.add(parent);
            parentId = parent.getParentId();
        }
        return result;
    }

    private static boolean isClass(TestIdentifier test) {
        return test.getSource().isPresent() && test.getSource().get() instanceof ClassSource;
    }

    private boolean hasSameSourceAsAncestor(TestIdentifier node) {
        Optional parent = this.currentTestPlan.getParent(node);
        while (parent.isPresent()) {
            if (Objects.equals(((TestIdentifier)parent.get()).getSource(), node.getSource())) {
                return true;
            }
            parent = this.currentTestPlan.getParent((TestIdentifier)parent.get());
        }
        return false;
    }

    private TestIdentifier findClassSource(TestIdentifier testIdentifier) {
        TestIdentifier current = testIdentifier;
        while (current != null) {
            if (JUnitPlatformTestExecutionListener.isClass(current)) {
                return current;
            }
            current = current.getParentId().map(arg_0 -> ((TestPlan)this.currentTestPlan).getTestIdentifier(arg_0)).orElse(null);
        }
        return null;
    }

    private String className(TestIdentifier testClassIdentifier) {
        if (testClassIdentifier != null && JUnitPlatformTestExecutionListener.isClass(testClassIdentifier)) {
            return JUnitPlatformTestExecutionListener.classSourceFor(testClassIdentifier).getClassName();
        }
        return "UnknownClass";
    }

    private static ClassSource classSourceFor(TestIdentifier testClassIdentifier) {
        return (ClassSource)testClassIdentifier.getSource().get();
    }

    private String classDisplayName(TestIdentifier testClassIdentifier) {
        if (testClassIdentifier != null) {
            return testClassIdentifier.getDisplayName();
        }
        return "UnknownClass";
    }

    private boolean hasDisplayNameAnnotation(TestIdentifier testClassIdentifier) {
        if (testClassIdentifier != null && JUnitPlatformTestExecutionListener.isClass(testClassIdentifier)) {
            Annotation[] annotations;
            Class javaClass = JUnitPlatformTestExecutionListener.classSourceFor(testClassIdentifier).getJavaClass();
            for (Annotation annotation : annotations = javaClass.getAnnotations()) {
                if (!DISPLAY_NAME.equals(annotation.annotationType().getName())) continue;
                return true;
            }
        }
        return false;
    }
}

