/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;

public class CompositeFileSystemSnapshot
implements FileSystemSnapshot {
    private final ImmutableList<FileSystemSnapshot> snapshots;

    private CompositeFileSystemSnapshot(Collection<FileSystemSnapshot> snapshots) {
        this.snapshots = ImmutableList.copyOf(snapshots);
    }

    public static FileSystemSnapshot of(Collection<FileSystemSnapshot> snapshots) {
        if (snapshots.isEmpty()) {
            return EMPTY;
        }
        return new CompositeFileSystemSnapshot(snapshots);
    }

    @Override
    public void accept(FileSystemSnapshotVisitor visitor) {
        for (FileSystemSnapshot snapshot : this.snapshots) {
            snapshot.accept(visitor);
        }
    }
}

