/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Collections;
import org.gradle.api.tasks.testing.TestExecutionException;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionException;
import org.gradle.tooling.internal.provider.TestExecutionRequestAction;
import org.gradle.tooling.internal.provider.runner.TestExecutionBuildConfigurationAction;
import org.gradle.tooling.internal.provider.runner.TestExecutionResultEvaluator;

public class TestExecutionRequestActionRunner
implements BuildActionRunner {
    private final BuildOperationListenerManager buildOperationListenerManager;

    public TestExecutionRequestActionRunner(BuildOperationListenerManager buildOperationListenerManager) {
        this.buildOperationListenerManager = buildOperationListenerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildActionRunner.Result run(BuildAction action, BuildController buildController) {
        if (!(action instanceof TestExecutionRequestAction)) {
            return BuildActionRunner.Result.nothing();
        }
        try {
            TestExecutionRequestAction testExecutionRequestAction = (TestExecutionRequestAction)action;
            TestExecutionResultEvaluator testExecutionResultEvaluator = new TestExecutionResultEvaluator(testExecutionRequestAction);
            this.buildOperationListenerManager.addListener((BuildOperationListener)testExecutionResultEvaluator);
            try {
                this.doRun(testExecutionRequestAction, buildController);
            }
            finally {
                this.buildOperationListenerManager.removeListener((BuildOperationListener)testExecutionResultEvaluator);
            }
            testExecutionResultEvaluator.evaluate();
        }
        catch (RuntimeException e) {
            Throwable throwable = this.findRootCause(e);
            if (throwable instanceof TestExecutionException) {
                return BuildActionRunner.Result.failed((Throwable)e, (RuntimeException)new InternalTestExecutionException("Error while running test(s)", throwable));
            }
            return BuildActionRunner.Result.failed((Throwable)e);
        }
        return BuildActionRunner.Result.of(null);
    }

    private void doRun(TestExecutionRequestAction action, BuildController buildController) {
        TestExecutionBuildConfigurationAction testTasksConfigurationAction = new TestExecutionBuildConfigurationAction(action, buildController.getGradle());
        ((BuildConfigurationActionExecuter)buildController.getGradle().getServices().get(BuildConfigurationActionExecuter.class)).setTaskSelectors(Collections.singletonList(testTasksConfigurationAction));
        buildController.run();
    }

    private Throwable findRootCause(Exception tex) {
        Throwable t = tex;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }
}

