/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.io.ReadWriteDirectBufferWrapper;

public abstract class ByteBufferWrapper {
    protected final File myFile;
    protected final long myPosition;
    protected final long myLength;
    protected volatile boolean myDirty;

    protected ByteBufferWrapper(File file2, long offset2, long length) {
        this.myFile = file2;
        this.myPosition = offset2;
        this.myLength = length;
    }

    @Nullable
    public abstract ByteBuffer getCachedBuffer();

    public final void markDirty() {
        if (!this.myDirty) {
            this.myDirty = true;
        }
    }

    public final boolean isDirty() {
        return this.myDirty;
    }

    public abstract ByteBuffer getBuffer() throws IOException;

    public abstract void unmap();

    public abstract void flush();

    public void dispose() {
        this.unmap();
    }

    public static ByteBufferWrapper readWriteDirect(File file2, long offset2, int length) {
        return new ReadWriteDirectBufferWrapper(file2, offset2, length);
    }

    public String toString() {
        return "Buffer for " + this.myFile + ", offset:" + this.myPosition + ", size: " + this.myLength;
    }
}

