/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ComponentMetadataListerDetails;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenRepositoryContentDescriptor;
import org.gradle.api.artifacts.repositories.RepositoryContentDescriptor;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.GradleModuleMetadataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.repositories.AbstractAuthenticationSupportedRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenRepositoryContentDescriptor;
import org.gradle.api.internal.artifacts.repositories.DefaultUrlArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.internal.artifacts.repositories.RepositoryContentDescriptorInternal;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.descriptor.MavenRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.maven.MavenMetadataLoader;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultArtifactMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultGradleModuleMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultMavenPomMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.ImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.RedirectingGradleMetadataModuleMetadataSource;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionLister;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.caching.ImplicitInputsCapturingInstantiator;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

public class DefaultMavenArtifactRepository
extends AbstractAuthenticationSupportedRepository
implements MavenArtifactRepository,
ResolutionAwareRepository,
PublicationAwareRepository {
    private static final DefaultMavenPomMetadataSource.MavenMetadataValidator NO_OP_VALIDATION_SERVICES = (repoName, metadata, artifactResolver) -> true;
    private final Transformer<String, MavenArtifactRepository> describer;
    private final FileResolver fileResolver;
    private final RepositoryTransportFactory transportFactory;
    private final DefaultUrlArtifactRepository urlArtifactRepository;
    private List<Object> additionalUrls = new ArrayList<Object>();
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final MetaDataParser<MutableMavenModuleResolveMetadata> pomParser;
    private final GradleModuleMetadataParser metadataParser;
    private final FileStore<String> resourcesFileStore;
    private final FileResourceRepository fileResourceRepository;
    private final MavenMutableModuleMetadataFactory metadataFactory;
    private final IsolatableFactory isolatableFactory;
    private final ChecksumService checksumService;
    private final MavenMetadataSources metadataSources = new MavenMetadataSources();
    private final InstantiatorFactory instantiatorFactory;

    public DefaultMavenArtifactRepository(FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, InstantiatorFactory instantiatorFactory, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, MetaDataParser<MutableMavenModuleResolveMetadata> pomParser, GradleModuleMetadataParser metadataParser, AuthenticationContainer authenticationContainer, FileStore<String> resourcesFileStore, FileResourceRepository fileResourceRepository, MavenMutableModuleMetadataFactory metadataFactory, IsolatableFactory isolatableFactory, ObjectFactory objectFactory, DefaultUrlArtifactRepository.Factory urlArtifactRepositoryFactory, ChecksumService checksumService) {
        this(new DefaultDescriber(), fileResolver, transportFactory, locallyAvailableResourceFinder, instantiatorFactory, artifactFileStore, pomParser, metadataParser, authenticationContainer, resourcesFileStore, fileResourceRepository, metadataFactory, isolatableFactory, objectFactory, urlArtifactRepositoryFactory, checksumService);
    }

    public DefaultMavenArtifactRepository(Transformer<String, MavenArtifactRepository> describer, FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, InstantiatorFactory instantiatorFactory, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, MetaDataParser<MutableMavenModuleResolveMetadata> pomParser, GradleModuleMetadataParser metadataParser, AuthenticationContainer authenticationContainer, FileStore<String> resourcesFileStore, FileResourceRepository fileResourceRepository, MavenMutableModuleMetadataFactory metadataFactory, IsolatableFactory isolatableFactory, ObjectFactory objectFactory, DefaultUrlArtifactRepository.Factory urlArtifactRepositoryFactory, ChecksumService checksumService) {
        super((Instantiator)instantiatorFactory.decorateLenient(), authenticationContainer, objectFactory);
        this.describer = describer;
        this.fileResolver = fileResolver;
        this.urlArtifactRepository = urlArtifactRepositoryFactory.create("Maven", this::getDisplayName);
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.pomParser = pomParser;
        this.metadataParser = metadataParser;
        this.resourcesFileStore = resourcesFileStore;
        this.fileResourceRepository = fileResourceRepository;
        this.metadataFactory = metadataFactory;
        this.isolatableFactory = isolatableFactory;
        this.checksumService = checksumService;
        this.metadataSources.setDefaults();
        this.instantiatorFactory = instantiatorFactory;
    }

    @Override
    public String getDisplayName() {
        return (String)this.describer.transform((Object)this);
    }

    public URI getUrl() {
        return this.urlArtifactRepository.getUrl();
    }

    public void setUrl(URI url) {
        this.invalidateDescriptor();
        this.urlArtifactRepository.setUrl(url);
    }

    public void setUrl(Object url) {
        this.invalidateDescriptor();
        this.urlArtifactRepository.setUrl(url);
    }

    public void setAllowInsecureProtocol(boolean allowInsecureProtocol) {
        this.invalidateDescriptor();
        this.urlArtifactRepository.setAllowInsecureProtocol(allowInsecureProtocol);
    }

    public boolean isAllowInsecureProtocol() {
        return this.urlArtifactRepository.isAllowInsecureProtocol();
    }

    public Set<URI> getArtifactUrls() {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        for (Object additionalUrl : this.additionalUrls) {
            result.add(this.fileResolver.resolveUri(additionalUrl));
        }
        return result;
    }

    public void artifactUrls(Object ... urls) {
        this.invalidateDescriptor();
        this.additionalUrls.addAll(Lists.newArrayList((Object[])urls));
    }

    public void setArtifactUrls(Set<URI> urls) {
        this.invalidateDescriptor();
        this.setArtifactUrls((Iterable<?>)urls);
    }

    public void setArtifactUrls(Iterable<?> urls) {
        this.invalidateDescriptor();
        this.additionalUrls = Lists.newArrayList(urls);
    }

    @Override
    public ModuleVersionPublisher createPublisher() {
        return this.createRealResolver();
    }

    @Override
    public ConfiguredModuleComponentRepository createResolver() {
        return this.createRealResolver();
    }

    @Override
    protected RepositoryDescriptor createDescriptor() {
        URI rootUri = this.validateUrl();
        return ((MavenRepositoryDescriptor.Builder)((MavenRepositoryDescriptor.Builder)((MavenRepositoryDescriptor.Builder)new MavenRepositoryDescriptor.Builder(this.getName(), rootUri).setAuthenticated(this.getConfiguredCredentials() != null)).setAuthenticationSchemes((List)this.getAuthenticationSchemes())).setMetadataSources((List)this.metadataSources.asList())).setArtifactUrls(Sets.newHashSet(this.getArtifactUrls())).create();
    }

    @Override
    protected Collection<URI> getRepositoryUrls() {
        ImmutableList.Builder builder = ImmutableList.builder();
        URI root = this.getUrl();
        if (root != null) {
            builder.add((Object)root);
        }
        builder.addAll(this.getArtifactUrls());
        return builder.build();
    }

    @Nonnull
    protected URI validateUrl() {
        return this.urlArtifactRepository.validateUrl();
    }

    protected MavenResolver createRealResolver() {
        URI rootUrl = this.validateUrl();
        MavenResolver resolver = this.createResolver(rootUrl);
        for (URI repoUrl : this.getArtifactUrls()) {
            resolver.addArtifactLocation(repoUrl);
        }
        return resolver;
    }

    private MavenResolver createResolver(URI rootUri) {
        RepositoryTransport transport = this.getTransport(rootUri.getScheme());
        MavenMetadataLoader mavenMetadataLoader = new MavenMetadataLoader(transport.getResourceAccessor(), this.resourcesFileStore);
        ImmutableMetadataSources metadataSources = this.createMetadataSources(mavenMetadataLoader);
        ImplicitInputsCapturingInstantiator injector = this.createInjectorForMetadataSuppliers(transport, this.instantiatorFactory, this.getUrl(), this.resourcesFileStore);
        InstantiatingAction<ComponentMetadataSupplierDetails> supplier = this.createComponentMetadataSupplierFactory(injector, this.isolatableFactory);
        InstantiatingAction<ComponentMetadataListerDetails> lister = this.createComponentMetadataVersionLister(injector, this.isolatableFactory);
        return new MavenResolver(this.getName(), rootUri, transport, this.locallyAvailableResourceFinder, this.artifactFileStore, metadataSources, MavenMetadataArtifactProvider.INSTANCE, mavenMetadataLoader, supplier, lister, (Instantiator)injector, this.checksumService);
    }

    public void metadataSources(Action<? super MavenArtifactRepository.MetadataSources> configureAction) {
        this.invalidateDescriptor();
        this.metadataSources.reset();
        configureAction.execute((Object)this.metadataSources);
    }

    public MavenArtifactRepository.MetadataSources getMetadataSources() {
        return this.metadataSources;
    }

    public void mavenContent(Action<? super MavenRepositoryContentDescriptor> configureAction) {
        this.content((Action<? super RepositoryContentDescriptor>)((Action)Cast.uncheckedCast(configureAction)));
    }

    ImmutableMetadataSources createMetadataSources(MavenMetadataLoader mavenMetadataLoader) {
        ImmutableList.Builder sources = ImmutableList.builder();
        boolean listVersionsForGradleMetadata = !this.metadataSources.mavenPom;
        MavenSnapshotDecoratingSource gradleModuleMetadataSource = new MavenSnapshotDecoratingSource(new DefaultGradleModuleMetadataSource(this.getMetadataParser(), this.metadataFactory, listVersionsForGradleMetadata, this.checksumService));
        if (this.metadataSources.gradleMetadata) {
            sources.add((Object)gradleModuleMetadataSource);
        }
        if (this.metadataSources.mavenPom) {
            DefaultMavenPomMetadataSource pomMetadataSource = this.createPomMetadataSource(mavenMetadataLoader, this.fileResourceRepository);
            if (this.metadataSources.ignoreGradleMetadataRedirection) {
                sources.add((Object)pomMetadataSource);
            } else {
                sources.add((Object)new RedirectingGradleMetadataModuleMetadataSource(pomMetadataSource, gradleModuleMetadataSource));
            }
        }
        if (this.metadataSources.artifact) {
            sources.add((Object)new DefaultArtifactMetadataSource(this.metadataFactory));
        }
        return new DefaultImmutableMetadataSources((Iterable<MetadataSource<?>>)sources.build());
    }

    protected DefaultMavenPomMetadataSource createPomMetadataSource(MavenMetadataLoader mavenMetadataLoader, FileResourceRepository fileResourceRepository) {
        return new DefaultMavenPomMetadataSource(MavenMetadataArtifactProvider.INSTANCE, this.getPomParser(), fileResourceRepository, this.getMetadataValidationServices(), mavenMetadataLoader, this.checksumService);
    }

    protected DefaultMavenPomMetadataSource.MavenMetadataValidator getMetadataValidationServices() {
        return NO_OP_VALIDATION_SERVICES;
    }

    MetaDataParser<MutableMavenModuleResolveMetadata> getPomParser() {
        return this.pomParser;
    }

    private GradleModuleMetadataParser getMetadataParser() {
        return this.metadataParser;
    }

    FileStore<ModuleComponentArtifactIdentifier> getArtifactFileStore() {
        return this.artifactFileStore;
    }

    FileStore<String> getResourcesFileStore() {
        return this.resourcesFileStore;
    }

    public RepositoryTransport getTransport(String scheme) {
        return this.transportFactory.createTransport(scheme, this.getName(), this.getConfiguredAuthentication(), this.urlArtifactRepository.createRedirectVerifier());
    }

    protected LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> getLocallyAvailableResourceFinder() {
        return this.locallyAvailableResourceFinder;
    }

    protected InstantiatorFactory getInstantiatorFactory() {
        return this.instantiatorFactory;
    }

    @Override
    protected RepositoryContentDescriptorInternal createRepositoryDescriptor() {
        return new DefaultMavenRepositoryContentDescriptor(this::getDisplayName);
    }

    private static class MavenSnapshotDecoratingSource
    implements MetadataSource<MutableModuleComponentResolveMetadata> {
        private static final int HASH_ID = 30155977;
        private final MetadataSource<MutableModuleComponentResolveMetadata> delegate;

        private MavenSnapshotDecoratingSource(MetadataSource<MutableModuleComponentResolveMetadata> delegate) {
            this.delegate = delegate;
        }

        @Override
        public MutableModuleComponentResolveMetadata create(String repositoryName, ComponentResolvers componentResolvers, ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata prescribedMetaData, ExternalResourceArtifactResolver artifactResolver, BuildableModuleComponentMetaDataResolveResult result) {
            MutableModuleComponentResolveMetadata metadata = this.delegate.create(repositoryName, componentResolvers, moduleComponentIdentifier, prescribedMetaData, artifactResolver, result);
            if (metadata != null) {
                return MavenResolver.processMetaData((MutableMavenModuleResolveMetadata)metadata);
            }
            return null;
        }

        @Override
        public void listModuleVersions(ModuleDependencyMetadata dependency, ModuleIdentifier module, List<ResourcePattern> ivyPatterns, List<ResourcePattern> artifactPatterns, VersionLister versionLister, BuildableModuleVersionListingResolveResult result) {
            this.delegate.listModuleVersions(dependency, module, ivyPatterns, artifactPatterns, versionLister, result);
        }

        @Override
        public void appendId(Hasher hasher) {
            hasher.putInt(30155977);
            this.delegate.appendId(hasher);
        }
    }

    private static class MavenMetadataSources
    implements MavenArtifactRepository.MetadataSources {
        boolean gradleMetadata;
        boolean mavenPom;
        boolean artifact;
        boolean ignoreGradleMetadataRedirection;

        private MavenMetadataSources() {
        }

        void setDefaults() {
            this.mavenPom();
            this.ignoreGradleMetadataRedirection = false;
        }

        void reset() {
            this.gradleMetadata = false;
            this.mavenPom = false;
            this.artifact = false;
            this.ignoreGradleMetadataRedirection = false;
        }

        List<String> asList() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.gradleMetadata) {
                list.add("gradleMetadata");
            }
            if (this.mavenPom) {
                list.add("mavenPom");
            }
            if (this.artifact) {
                list.add("artifact");
            }
            if (this.ignoreGradleMetadataRedirection) {
                list.add("ignoreGradleMetadataRedirection");
            }
            return list;
        }

        public void gradleMetadata() {
            this.gradleMetadata = true;
        }

        public void mavenPom() {
            this.mavenPom = true;
        }

        public void artifact() {
            this.artifact = true;
        }

        public void ignoreGradleMetadataRedirection() {
            this.ignoreGradleMetadataRedirection = true;
        }

        public boolean isGradleMetadataEnabled() {
            return this.gradleMetadata;
        }

        public boolean isMavenPomEnabled() {
            return this.mavenPom;
        }

        public boolean isArtifactEnabled() {
            return this.artifact;
        }

        public boolean isIgnoreGradleMetadataRedirectionEnabled() {
            return this.ignoreGradleMetadataRedirection;
        }
    }

    private static class DefaultDescriber
    implements Transformer<String, MavenArtifactRepository> {
        private DefaultDescriber() {
        }

        public String transform(MavenArtifactRepository repository) {
            URI url = repository.getUrl();
            if (url == null) {
                return repository.getName();
            }
            return repository.getName() + '(' + url + ')';
        }
    }
}

