/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.ClassloaderBackedPluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.InvalidPluginException;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.internal.classpath.BuildLogicTransformStrategy;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.PluginResolutionStrategyInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.PluginRepositoriesProvider;
import org.gradle.plugin.use.internal.PluginRequestApplicator;
import org.gradle.plugin.use.internal.PluginResolverFactory;
import org.gradle.plugin.use.resolve.internal.AlreadyOnClasspathPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolveContext;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.util.CollectionUtils;
import org.gradle.util.TextUtil;

public class DefaultPluginRequestApplicator
implements PluginRequestApplicator {
    private final PluginRegistry pluginRegistry;
    private final PluginResolverFactory pluginResolverFactory;
    private final PluginRepositoriesProvider pluginRepositoriesProvider;
    private final PluginResolutionStrategyInternal pluginResolutionStrategy;
    private final PluginInspector pluginInspector;
    private final CachedClasspathTransformer cachedClasspathTransformer;
    private final BuildLogicTransformStrategy transformStrategy;

    public DefaultPluginRequestApplicator(PluginRegistry pluginRegistry, PluginResolverFactory pluginResolver, PluginRepositoriesProvider pluginRepositoriesProvider, PluginResolutionStrategyInternal pluginResolutionStrategy, PluginInspector pluginInspector, CachedClasspathTransformer cachedClasspathTransformer, BuildLogicTransformStrategy transformStrategy) {
        this.pluginRegistry = pluginRegistry;
        this.pluginResolverFactory = pluginResolver;
        this.pluginRepositoriesProvider = pluginRepositoriesProvider;
        this.pluginResolutionStrategy = pluginResolutionStrategy;
        this.pluginInspector = pluginInspector;
        this.cachedClasspathTransformer = cachedClasspathTransformer;
        this.transformStrategy = transformStrategy;
    }

    public void applyPlugins(PluginRequests requests, final ScriptHandlerInternal scriptHandler, @Nullable PluginManagerInternal target, ClassLoaderScope classLoaderScope) {
        if (target == null || requests.isEmpty()) {
            this.defineScriptHandlerClassScope(scriptHandler, classLoaderScope, Collections.emptyList());
            return;
        }
        PluginResolver effectivePluginResolver = this.wrapInAlreadyInClasspathResolver(classLoaderScope);
        if (!requests.isEmpty()) {
            this.addPluginArtifactRepositories(scriptHandler.getRepositories());
        }
        List<Result> results = this.resolvePluginRequests(requests, effectivePluginResolver);
        final LinkedHashMap legacyActualPluginIds = Maps.newLinkedHashMap();
        final LinkedHashMap pluginImpls = Maps.newLinkedHashMap();
        final LinkedHashMap pluginImplsFromOtherLoaders = Maps.newLinkedHashMap();
        if (!results.isEmpty()) {
            for (final Result result : results) {
                this.applyPlugin(result.request, result.found.getPluginId(), new Runnable(){

                    @Override
                    public void run() {
                        result.found.execute(new PluginResolveContext(){

                            @Override
                            public void addLegacy(PluginId pluginId, Object dependencyNotation) {
                                legacyActualPluginIds.put(result, pluginId);
                                scriptHandler.addScriptClassPathDependency(dependencyNotation);
                            }

                            @Override
                            public void add(PluginImplementation<?> plugin) {
                                pluginImpls.put(result, plugin);
                            }

                            @Override
                            public void addFromDifferentLoader(PluginImplementation<?> plugin) {
                                pluginImpls.put(result, plugin);
                                pluginImplsFromOtherLoaders.put(result, plugin);
                            }
                        });
                    }
                });
            }
        }
        this.defineScriptHandlerClassScope(scriptHandler, classLoaderScope, pluginImplsFromOtherLoaders.values());
        this.applyLegacyPlugins(target, legacyActualPluginIds);
        this.applyPlugins(target, pluginImpls);
    }

    private void applyPlugins(PluginManagerInternal target, Map<Result, PluginImplementation<?>> regularPlugins) {
        regularPlugins.forEach((result, impl) -> this.applyPlugin(((Result)result).request, ((Result)result).found.getPluginId(), () -> {
            if (((Result)result).request.isApply()) {
                target.apply(impl);
            }
        }));
    }

    private void applyLegacyPlugins(@Nullable PluginManagerInternal target, Map<Result, PluginId> legacyActualPluginIds) {
        legacyActualPluginIds.forEach((result, id) -> this.applyPlugin(((Result)result).request, (PluginId)id, () -> {
            if (((Result)result).request.isApply()) {
                target.apply(id.toString());
            }
        }));
    }

    private List<Result> resolvePluginRequests(PluginRequests requests, PluginResolver effectivePluginResolver) {
        return CollectionUtils.collect((Iterable)requests, request -> {
            PluginRequestInternal configuredRequest = this.pluginResolutionStrategy.applyTo(request);
            return this.resolveToFoundResult(effectivePluginResolver, configuredRequest);
        });
    }

    private void addPluginArtifactRepositories(RepositoryHandler repositories) {
        repositories.addAll(this.pluginRepositoriesProvider.getPluginRepositories());
    }

    private void defineScriptHandlerClassScope(ScriptHandlerInternal scriptHandler, ClassLoaderScope classLoaderScope, Iterable<PluginImplementation<?>> pluginsFromOtherLoaders) {
        ClassPath classPath = scriptHandler.getScriptClassPath();
        ClassPath cachedClassPath = this.cachedClasspathTransformer.transform(classPath, this.transformStrategy.transformToApplyToBuildLogic());
        classLoaderScope.export(cachedClassPath);
        for (PluginImplementation<?> pluginImplementation : pluginsFromOtherLoaders) {
            classLoaderScope.export(pluginImplementation.asClass().getClassLoader());
        }
        classLoaderScope.lock();
    }

    private PluginResolver wrapInAlreadyInClasspathResolver(ClassLoaderScope classLoaderScope) {
        ClassLoaderScope parentLoaderScope = classLoaderScope.getParent();
        ClassloaderBackedPluginDescriptorLocator scriptClasspathPluginDescriptorLocator = new ClassloaderBackedPluginDescriptorLocator(parentLoaderScope.getExportClassLoader());
        PluginResolver pluginResolver = this.pluginResolverFactory.create();
        return new AlreadyOnClasspathPluginResolver(pluginResolver, this.pluginRegistry, parentLoaderScope, (PluginDescriptorLocator)scriptClasspathPluginDescriptorLocator, this.pluginInspector);
    }

    private void applyPlugin(PluginRequestInternal request, PluginId id, Runnable applicator) {
        try {
            try {
                applicator.run();
            }
            catch (UnknownPluginException e) {
                throw this.couldNotApply(request, id, e);
            }
            catch (Exception e) {
                throw this.exceptionOccurred(request, e);
            }
        }
        catch (Exception e) {
            throw new LocationAwareException((Throwable)e, request.getScriptDisplayName(), request.getLineNumber());
        }
    }

    private InvalidPluginException couldNotApply(PluginRequestInternal request, PluginId id, UnknownPluginException cause) {
        return new InvalidPluginException(String.format("Could not apply requested plugin %s as it does not provide a plugin with id '%s'. This is caused by an incorrect plugin implementation. Please contact the plugin author(s).", request, id), (Throwable)cause);
    }

    private InvalidPluginException exceptionOccurred(PluginRequestInternal request, Exception e) {
        return new InvalidPluginException(String.format("An exception occurred applying plugin request %s", request), (Throwable)e);
    }

    private Result resolveToFoundResult(PluginResolver effectivePluginResolver, PluginRequestInternal request) {
        Result result = new Result(request);
        try {
            effectivePluginResolver.resolve(request, result);
        }
        catch (Exception e) {
            throw new LocationAwareException((Throwable)new GradleException(String.format("Error resolving plugin %s", request.getDisplayName()), (Throwable)e), request.getScriptDisplayName(), request.getLineNumber());
        }
        if (!result.isFound()) {
            String message = this.buildNotFoundMessage(request, result);
            UnknownPluginException exception = new UnknownPluginException(message);
            throw new LocationAwareException((Throwable)exception, request.getScriptDisplayName(), request.getLineNumber());
        }
        return result;
    }

    private String buildNotFoundMessage(PluginRequestInternal pluginRequest, Result result) {
        if (result.notFoundList.isEmpty()) {
            return String.format("Plugin %s was not found", pluginRequest.getDisplayName());
        }
        Formatter sb = new Formatter();
        sb.format("Plugin %s was not found in any of the following sources:%n", pluginRequest.getDisplayName());
        for (NotFound notFound : result.notFoundList) {
            sb.format("%n- %s (%s)", notFound.source, notFound.message);
            if (notFound.detail == null) continue;
            sb.format("%n%s", TextUtil.indent((String)notFound.detail, (String)"  "));
        }
        return sb.toString();
    }

    private static class Result
    implements PluginResolutionResult {
        private final List<NotFound> notFoundList = new LinkedList<NotFound>();
        private final PluginRequestInternal request;
        private PluginResolution found;

        public Result(PluginRequestInternal request) {
            this.request = request;
        }

        @Override
        public void notFound(String sourceDescription, String notFoundMessage) {
            this.notFoundList.add(new NotFound(sourceDescription, notFoundMessage, null));
        }

        @Override
        public void notFound(String sourceDescription, String notFoundMessage, String notFoundDetail) {
            this.notFoundList.add(new NotFound(sourceDescription, notFoundMessage, notFoundDetail));
        }

        @Override
        public void found(String sourceDescription, PluginResolution pluginResolution) {
            this.found = pluginResolution;
        }

        @Override
        public boolean isFound() {
            return this.found != null;
        }
    }

    private static class NotFound {
        private final String source;
        private final String message;
        private final String detail;

        private NotFound(String source, String message, String detail) {
            this.source = source;
            this.message = message;
            this.detail = detail;
        }
    }
}

