/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.quality.CodeNarc;
import org.gradle.api.plugins.quality.CodeNarcExtension;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.metaobject.DynamicObject;

public class CodeNarcPlugin
extends AbstractCodeQualityPlugin<CodeNarc> {
    public static final String DEFAULT_CODENARC_VERSION = "1.5";
    private CodeNarcExtension extension;

    @Override
    protected String getToolName() {
        return "CodeNarc";
    }

    @Override
    protected Class<CodeNarc> getTaskType() {
        return CodeNarc.class;
    }

    @Override
    protected Class<? extends Plugin> getBasePlugin() {
        return GroovyBasePlugin.class;
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = (CodeNarcExtension)this.project.getExtensions().create("codenarc", CodeNarcExtension.class, new Object[]{this.project});
        this.extension.setToolVersion(DEFAULT_CODENARC_VERSION);
        this.extension.setConfig(this.project.getResources().getText().fromFile((Object)this.project.getRootProject().file((Object)"config/codenarc/codenarc.xml")));
        this.extension.setMaxPriority1Violations(0);
        this.extension.setMaxPriority2Violations(0);
        this.extension.setMaxPriority3Violations(0);
        this.extension.setReportFormat("html");
        return this.extension;
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected void configureTaskDefaults(CodeNarc task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies(dependencies -> dependencies.add((Object)this.project.getDependencies().create((Object)("org.codenarc:CodeNarc:" + this.extension.getToolVersion()))));
    }

    private void configureTaskConventionMapping(Configuration configuration, CodeNarc task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("codenarcClasspath", () -> configuration);
        taskMapping.map("config", () -> this.extension.getConfig());
        taskMapping.map("maxPriority1Violations", () -> this.extension.getMaxPriority1Violations());
        taskMapping.map("maxPriority2Violations", () -> this.extension.getMaxPriority2Violations());
        taskMapping.map("maxPriority3Violations", () -> this.extension.getMaxPriority3Violations());
        taskMapping.map("ignoreFailures", () -> this.extension.isIgnoreFailures());
    }

    private void configureReportsConventionMapping(CodeNarc task, String baseName) {
        task.getReports().all(report -> {
            report.getRequired().convention(this.project.getProviders().provider(() -> report.getName().equals(this.extension.getReportFormat())));
            report.getOutputLocation().convention(this.project.getLayout().getProjectDirectory().file(this.project.provider(() -> {
                String fileSuffix = report.getName().equals("text") ? "txt" : report.getName();
                return new File(this.extension.getReportsDir(), baseName + "." + fileSuffix).getAbsolutePath();
            })));
        });
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, CodeNarc task) {
        task.setDescription("Run CodeNarc analysis for " + sourceSet.getName() + " classes");
        DynamicObject dynamicObject = new DslObject((Object)sourceSet).getAsDynamicObject();
        task.setSource(dynamicObject.getProperty("allGroovy"));
    }
}

