/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.vfs.impl;

import com.google.common.collect.EnumMultiset;
import com.google.common.collect.Multiset;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.gradle.internal.file.DefaultFileHierarchySet;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.CompleteDirectorySnapshot;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.vfs.impl.AbstractVirtualFileSystem;
import org.gradle.internal.vfs.impl.SnapshotCollectingDiffListener;
import org.gradle.internal.watch.WatchingNotSupportedException;
import org.gradle.internal.watch.registry.FileWatcherRegistry;
import org.gradle.internal.watch.registry.FileWatcherRegistryFactory;
import org.gradle.internal.watch.vfs.WatchingAwareVirtualFileSystem;
import org.gradle.internal.watch.vfs.impl.AbstractDelegatingVirtualFileSystem;
import org.gradle.internal.watch.vfs.impl.DelegatingDiffCapturingUpdateFunctionDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchingVirtualFileSystem
extends AbstractDelegatingVirtualFileSystem
implements WatchingAwareVirtualFileSystem,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchingVirtualFileSystem.class);
    private final FileWatcherRegistryFactory watcherRegistryFactory;
    private final DelegatingDiffCapturingUpdateFunctionDecorator delegatingUpdateFunctionDecorator;
    private final AtomicReference<FileHierarchySet> producedByCurrentBuild = new AtomicReference<FileHierarchySet>(DefaultFileHierarchySet.of());
    private final Predicate<String> watchFilter;
    private FileWatcherRegistry watchRegistry;
    private final SnapshotHierarchy.SnapshotDiffListener snapshotDiffListener = (removedSnapshots, addedSnapshots) -> {
        if (this.watchRegistry != null) {
            this.watchRegistry.getFileWatcherUpdater().changed(removedSnapshots, addedSnapshots);
        }
    };
    private volatile boolean buildRunning;

    public WatchingVirtualFileSystem(FileWatcherRegistryFactory watcherRegistryFactory, AbstractVirtualFileSystem delegate, DelegatingDiffCapturingUpdateFunctionDecorator delegatingUpdateFunctionDecorator, Predicate<String> watchFilter) {
        super(delegate);
        this.watcherRegistryFactory = watcherRegistryFactory;
        this.delegatingUpdateFunctionDecorator = delegatingUpdateFunctionDecorator;
        this.watchFilter = watchFilter;
    }

    @Override
    public void afterBuildStarted(boolean watchingEnabled) {
        this.getRoot().update(currentRoot -> {
            if (watchingEnabled) {
                SnapshotHierarchy newRoot = this.handleWatcherRegistryEvents(currentRoot, "since last build");
                newRoot = this.startWatching(newRoot);
                WatchingVirtualFileSystem.printStatistics(newRoot, "retained", "since last build");
                this.producedByCurrentBuild.set(DefaultFileHierarchySet.of());
                this.buildRunning = true;
                return newRoot;
            }
            return this.stopWatchingAndInvalidateHierarchy(currentRoot);
        });
    }

    private void updateWatchRegistry(Consumer<FileWatcherRegistry> updateFunction) {
        this.updateWatchRegistry(updateFunction, () -> {});
    }

    private void updateWatchRegistry(Consumer<FileWatcherRegistry> updateFunction, Runnable noWatchRegistry) {
        this.getRoot().update(currentRoot -> {
            if (this.watchRegistry == null) {
                noWatchRegistry.run();
                return currentRoot;
            }
            return this.handleWatcherChangeErrors(currentRoot, () -> updateFunction.accept(this.watchRegistry));
        });
    }

    @Override
    public void updateProjectRootDirectory(File projectRootDirectory) {
        this.updateWatchRegistry(watchRegistry -> watchRegistry.getFileWatcherUpdater().updateProjectRootDirectory(projectRootDirectory));
    }

    @Override
    public void beforeBuildFinished(boolean watchingEnabled) {
        if (watchingEnabled) {
            this.getRoot().update(currentRoot -> {
                this.buildRunning = false;
                this.producedByCurrentBuild.set(DefaultFileHierarchySet.of());
                SnapshotHierarchy newRoot = this.removeSymbolicLinks(currentRoot);
                newRoot = this.handleWatcherRegistryEvents(newRoot, "for current build");
                WatchingVirtualFileSystem.printStatistics(newRoot, "retains", "till next build");
                return newRoot;
            });
        } else {
            this.invalidateAll();
        }
    }

    private SnapshotHierarchy removeSymbolicLinks(SnapshotHierarchy currentRoot) {
        SymlinkRemovingFileSystemSnapshotVisitor symlinkRemovingFileSystemSnapshotVisitor = new SymlinkRemovingFileSystemSnapshotVisitor(currentRoot);
        currentRoot.visitSnapshotRoots(snapshotRoot -> snapshotRoot.accept((FileSystemSnapshotVisitor)symlinkRemovingFileSystemSnapshotVisitor));
        return symlinkRemovingFileSystemSnapshotVisitor.getRootWithSymlinksRemoved();
    }

    private SnapshotHierarchy startWatching(SnapshotHierarchy currentRoot) {
        if (this.watchRegistry != null) {
            return currentRoot;
        }
        try {
            long startTime = System.currentTimeMillis();
            this.watchRegistry = this.watcherRegistryFactory.createFileWatcherRegistry(new FileWatcherRegistry.ChangeHandler(){

                @Override
                public void handleChange(FileWatcherRegistry.Type type, Path path) {
                    try {
                        LOGGER.debug("Handling VFS change {} {}", (Object)type, (Object)path);
                        String absolutePath = path.toString();
                        if (!WatchingVirtualFileSystem.this.buildRunning || !((FileHierarchySet)WatchingVirtualFileSystem.this.producedByCurrentBuild.get()).contains(absolutePath)) {
                            WatchingVirtualFileSystem.this.getRoot().update(root -> {
                                SnapshotCollectingDiffListener diffListener = new SnapshotCollectingDiffListener(WatchingVirtualFileSystem.this.watchFilter);
                                SnapshotHierarchy newRoot = root.invalidate(absolutePath, (SnapshotHierarchy.NodeDiffListener)diffListener);
                                return WatchingVirtualFileSystem.this.handleWatcherChangeErrors(newRoot, () -> diffListener.publishSnapshotDiff(WatchingVirtualFileSystem.this.snapshotDiffListener));
                            });
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while processing file events", (Throwable)e);
                        WatchingVirtualFileSystem.this.stopWatchingAndInvalidateHierarchy();
                    }
                }

                @Override
                public void handleLostState() {
                    LOGGER.warn("Dropped VFS state due to lost state");
                    WatchingVirtualFileSystem.this.stopWatchingAndInvalidateHierarchy();
                }
            });
            this.delegatingUpdateFunctionDecorator.setSnapshotDiffListener(this.snapshotDiffListener, this::handleWatcherChangeErrors);
            long endTime = System.currentTimeMillis() - startTime;
            LOGGER.warn("Spent {} ms registering watches for file system events", (Object)endTime);
            return currentRoot.empty();
        }
        catch (Exception ex) {
            LOGGER.error("Couldn't create watch service, not tracking changes between builds", (Throwable)ex);
            this.closeUnderLock();
            return currentRoot.empty();
        }
    }

    private SnapshotHierarchy handleWatcherChangeErrors(SnapshotHierarchy currentRoot, Runnable runnable) {
        try {
            runnable.run();
            return currentRoot;
        }
        catch (WatchingNotSupportedException ex) {
            LOGGER.warn("Watching not supported, not tracking changes between builds: {}", (Object)ex.getMessage());
            return this.stopWatchingAndInvalidateHierarchy(currentRoot);
        }
        catch (Exception ex) {
            LOGGER.error("Couldn't update watches, not watching anymore", (Throwable)ex);
            return this.stopWatchingAndInvalidateHierarchy(currentRoot);
        }
    }

    private void stopWatchingAndInvalidateHierarchy() {
        this.getRoot().update(this::stopWatchingAndInvalidateHierarchy);
    }

    private SnapshotHierarchy stopWatchingAndInvalidateHierarchy(SnapshotHierarchy currentRoot) {
        if (this.watchRegistry != null) {
            try {
                FileWatcherRegistry toBeClosed = this.watchRegistry;
                this.watchRegistry = null;
                this.delegatingUpdateFunctionDecorator.stopListening();
                toBeClosed.close();
            }
            catch (IOException ex) {
                LOGGER.error("Couldn't fetch file changes, dropping VFS state", (Throwable)ex);
            }
        }
        return currentRoot.empty();
    }

    private SnapshotHierarchy handleWatcherRegistryEvents(SnapshotHierarchy currentRoot, String eventsFor) {
        if (this.watchRegistry == null) {
            return currentRoot.empty();
        }
        FileWatcherRegistry.FileWatchingStatistics statistics = this.watchRegistry.getAndResetStatistics();
        LOGGER.warn("Received {} file system events {}", (Object)statistics.getNumberOfReceivedEvents(), (Object)eventsFor);
        if (statistics.isUnknownEventEncountered()) {
            LOGGER.warn("Dropped VFS state due to lost state");
            return this.stopWatchingAndInvalidateHierarchy(currentRoot);
        }
        if (statistics.getErrorWhileReceivingFileChanges().isPresent()) {
            LOGGER.warn("Dropped VFS state due to error while receiving file changes", statistics.getErrorWhileReceivingFileChanges().get());
            return this.stopWatchingAndInvalidateHierarchy(currentRoot);
        }
        return currentRoot;
    }

    private static void printStatistics(SnapshotHierarchy root, String verb, String statisticsFor) {
        VirtualFileSystemStatistics statistics = WatchingVirtualFileSystem.getStatistics(root);
        LOGGER.warn("Virtual file system {} information about {} files, {} directories and {} missing files {}", new Object[]{verb, statistics.getRetained(FileType.RegularFile), statistics.getRetained(FileType.Directory), statistics.getRetained(FileType.Missing), statisticsFor});
    }

    private static VirtualFileSystemStatistics getStatistics(SnapshotHierarchy root) {
        final EnumMultiset retained = EnumMultiset.create(FileType.class);
        root.visitSnapshotRoots(snapshot -> snapshot.accept(new FileSystemSnapshotVisitor(){

            public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
                retained.add((Object)directorySnapshot.getType());
                return true;
            }

            public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
                retained.add((Object)fileSnapshot.getType());
            }

            public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            }
        }));
        return new VirtualFileSystemStatistics((Multiset<FileType>)retained);
    }

    @Override
    public void update(Iterable<String> locations, Runnable action) {
        if (this.buildRunning) {
            this.producedByCurrentBuild.updateAndGet(currentValue -> {
                FileHierarchySet newValue = currentValue;
                for (String location : locations) {
                    newValue = newValue.plus(new File(location));
                }
                return newValue;
            });
        }
        super.update(locations, action);
    }

    @Override
    public void close() {
        this.getRoot().update(currentRoot -> {
            this.closeUnderLock();
            return currentRoot.empty();
        });
    }

    private void closeUnderLock() {
        this.producedByCurrentBuild.set(DefaultFileHierarchySet.of());
        if (this.watchRegistry != null) {
            try {
                this.watchRegistry.close();
            }
            catch (IOException ex) {
                LOGGER.error("Couldn't close watch service", (Throwable)ex);
            }
            finally {
                this.watchRegistry = null;
            }
        }
    }

    private class SymlinkRemovingFileSystemSnapshotVisitor
    implements FileSystemSnapshotVisitor {
        private SnapshotHierarchy root;

        public SymlinkRemovingFileSystemSnapshotVisitor(SnapshotHierarchy root) {
            this.root = root;
        }

        public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            boolean accessedViaSymlink;
            boolean bl = accessedViaSymlink = directorySnapshot.getAccessType() == FileMetadata.AccessType.VIA_SYMLINK;
            if (accessedViaSymlink) {
                this.invalidateSymlink((CompleteFileSystemLocationSnapshot)directorySnapshot);
            }
            return !accessedViaSymlink;
        }

        public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
            if (fileSnapshot.getAccessType() == FileMetadata.AccessType.VIA_SYMLINK) {
                this.invalidateSymlink(fileSnapshot);
            }
        }

        public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
        }

        private void invalidateSymlink(CompleteFileSystemLocationSnapshot snapshot) {
            this.root = WatchingVirtualFileSystem.this.delegatingUpdateFunctionDecorator.decorate((root, diffListener) -> root.invalidate(snapshot.getAbsolutePath(), diffListener)).updateRoot(this.root);
        }

        public SnapshotHierarchy getRootWithSymlinksRemoved() {
            return this.root;
        }
    }

    private static class VirtualFileSystemStatistics {
        private final Multiset<FileType> retained;

        public VirtualFileSystemStatistics(Multiset<FileType> retained) {
            this.retained = retained;
        }

        public int getRetained(FileType fileType) {
            return this.retained.count((Object)fileType);
        }
    }
}

