/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

class OrElseProvider<T>
extends AbstractMinimalProvider<T> {
    private final ProviderInternal<T> left;
    private final ProviderInternal<? extends T> right;

    public OrElseProvider(ProviderInternal<T> left, ProviderInternal<? extends T> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.left.getType();
    }

    @Override
    public boolean isValueProducedByTask() {
        return this.left.isValueProducedByTask() || this.right.isValueProducedByTask();
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        if (this.left.isValueProducedByTask() && !this.left.maybeVisitBuildDependencies(context)) {
            return false;
        }
        if (!this.left.isValueProducedByTask() && this.left.isPresent()) {
            return this.left.maybeVisitBuildDependencies(context);
        }
        return this.right.maybeVisitBuildDependencies(context);
    }

    @Override
    public boolean isPresent() {
        return this.left.isPresent() || this.right.isPresent();
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue() {
        ValueSupplier.Value<T> leftValue = this.left.calculateValue();
        if (!leftValue.isMissing()) {
            return leftValue;
        }
        ValueSupplier.Value<T> rightValue = this.right.calculateValue();
        if (!rightValue.isMissing()) {
            return rightValue;
        }
        return leftValue.addPathsFrom(rightValue);
    }
}

