/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuardImpl;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.SimpleModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;

public class PsiModificationTrackerImpl
implements PsiTreeChangePreprocessor,
PsiModificationTracker {
    private final SimpleModificationTracker myModificationCount;
    private final SimpleModificationTracker myOutOfCodeBlockModificationTracker;
    private final SimpleModificationTracker myJavaStructureModificationTracker;
    private final Map<Language, ModificationTracker> myLanguageTrackers;
    private final PsiModificationTracker.Listener myPublisher;

    public PsiModificationTrackerImpl(Project project) {
        this.myOutOfCodeBlockModificationTracker = this.myModificationCount = new SimpleModificationTracker();
        this.myJavaStructureModificationTracker = this.myModificationCount;
        this.myLanguageTrackers = ConcurrentFactoryMap.createMap(language -> new SimpleModificationTracker());
        MessageBus bus = project.getMessageBus();
        this.myPublisher = (PsiModificationTracker.Listener)bus.syncPublisher(TOPIC);
        bus.connect().subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            private void doIncCounter() {
                ApplicationManager.getApplication().runWriteAction(() -> PsiModificationTrackerImpl.this.incCounter());
            }

            public void enteredDumbMode() {
                this.doIncCounter();
            }

            public void exitDumbMode() {
                this.doIncCounter();
            }
        });
    }

    public void incCounter() {
        this.incCountersInner(7);
    }

    public void incOutOfCodeBlockModificationCounter() {
        this.incCountersInner(3);
    }

    private void fireEvent() {
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myPublisher.modificationCountChanged();
    }

    private void incCountersInner(int bits) {
        if ((bits & 1) != 0) {
            this.myModificationCount.incModificationCount();
        }
        if ((bits & 2) != 0) {
            this.myOutOfCodeBlockModificationTracker.incModificationCount();
        }
        if ((bits & 4) != 0) {
            this.myJavaStructureModificationTracker.incModificationCount();
        }
        this.fireEvent();
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(0);
        }
        if (!PsiModificationTrackerImpl.canAffectPsi(event)) {
            return;
        }
        this.incLanguageTrackers(event);
        PsiTreeChangeEventImpl.PsiEventType code = event.getCode();
        boolean outOfCodeBlock = code == PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED ? event.getPropertyName() == "propUnloadedPsi" || event.getPropertyName() == "roots" : (code == PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED ? event.getOldParent() instanceof PsiDirectory || event.getNewParent() instanceof PsiDirectory : event.getParent() instanceof PsiDirectory);
        this.incCountersInner(outOfCodeBlock ? 7 : 1);
    }

    public static boolean canAffectPsi(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(1);
        }
        return !"writable".equals(event.getPropertyName());
    }

    protected void incLanguageTrackers(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(2);
        }
        this.incLanguageModificationCount(Language.ANY);
        PsiElement[] elements = new PsiElement[]{event.getFile(), event.getParent(), event.getOldParent(), event.getNewParent(), event.getElement(), event.getChild(), event.getOldChild(), event.getNewChild()};
        HashSet<Language> languages = new HashSet<Language>(elements.length);
        languages.add(Language.ANY);
        for (PsiElement o : elements) {
            PsiFile file2;
            PsiFile psiFile = file2 = o instanceof PsiFile ? (PsiFile)o : null;
            if (file2 == null) {
                try {
                    IElementType type2 = PsiUtilCore.getElementType(o);
                    Language language = type2 != null ? type2.getLanguage() : (o != null ? o.getLanguage() : null);
                    ContainerUtil.addIfNotNull(languages, language);
                }
                catch (PsiInvalidElementAccessException e) {
                    PsiDocumentManagerBase.LOG.warn(e);
                }
                continue;
            }
            for (Language language : file2.getViewProvider().getLanguages()) {
                ContainerUtil.addIfNotNull(languages, language);
            }
        }
        for (Language language : languages) {
            this.incLanguageModificationCount(language);
        }
    }

    @Override
    public long getModificationCount() {
        return this.myModificationCount.getModificationCount();
    }

    @Override
    public long getOutOfCodeBlockModificationCount() {
        return this.myOutOfCodeBlockModificationTracker.getModificationCount();
    }

    @Override
    public long getJavaStructureModificationCount() {
        return this.myJavaStructureModificationTracker.getModificationCount();
    }

    @Override
    @NotNull
    public ModificationTracker getOutOfCodeBlockModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myOutOfCodeBlockModificationTracker;
        if (simpleModificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(3);
        }
        return simpleModificationTracker;
    }

    @Override
    @NotNull
    public ModificationTracker getJavaStructureModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myJavaStructureModificationTracker;
        if (simpleModificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(4);
        }
        return simpleModificationTracker;
    }

    @ApiStatus.Experimental
    public void incLanguageModificationCount(@Nullable Language language) {
        if (language == null) {
            return;
        }
        ((SimpleModificationTracker)this.myLanguageTrackers.get(language)).incModificationCount();
    }

    @ApiStatus.Experimental
    @NotNull
    public ModificationTracker forLanguage(@NotNull Language language) {
        if (language == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(5);
        }
        ModificationTracker modificationTracker2 = this.myLanguageTrackers.get(language);
        if (modificationTracker2 == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(6);
        }
        return modificationTracker2;
    }

    @ApiStatus.Experimental
    @NotNull
    public ModificationTracker forLanguages(@NotNull Condition<? super Language> condition) {
        if (condition == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(7);
        }
        ModificationTracker modificationTracker2 = () -> {
            long result2 = 0L;
            for (Language l : this.myLanguageTrackers.keySet()) {
                if (!condition.value(l)) continue;
                result2 += this.myLanguageTrackers.get(l).getModificationCount();
            }
            return result2;
        };
        if (modificationTracker2 == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(8);
        }
        return modificationTracker2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiModificationTrackerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiModificationTrackerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutOfCodeBlockModificationTracker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaStructureModificationTracker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "treeChanged";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canAffectPsi";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "incLanguageTrackers";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forLanguages";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

