/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class DefaultBasePluginConvention
extends BasePluginConvention
implements HasPublicType {
    private final DirectoryProperty buildDirectory;
    private final DirectoryProperty distsDirectory;
    private final DirectoryProperty libsDirectory;
    private ProjectInternal project;
    private String distsDirName;
    private String libsDirName;
    private String archivesBaseName;

    public DefaultBasePluginConvention(Project project) {
        this.project = (ProjectInternal)project;
        this.buildDirectory = project.getLayout().getBuildDirectory();
        this.archivesBaseName = project.getName();
        this.distsDirName = "distributions";
        this.distsDirectory = project.getObjects().directoryProperty();
        this.distsDirectory.convention(this.buildDirectory.dir(this.distsDirName));
        this.libsDirName = "libs";
        this.libsDirectory = project.getObjects().directoryProperty();
        this.libsDirectory.convention(this.buildDirectory.dir(this.libsDirName));
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(BasePluginConvention.class);
    }

    @Override
    @Deprecated
    public File getDistsDir() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(Project.class, (String)"distsDir").replaceWith((Object)"distsDirectory")).withDslReference().nagUser();
        return ((Directory)this.getDistsDirectory().get()).getAsFile();
    }

    @Override
    public DirectoryProperty getDistsDirectory() {
        return this.distsDirectory;
    }

    @Override
    @Deprecated
    public File getLibsDir() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(Project.class, (String)"libsDir").replaceWith((Object)"libsDirectory")).withDslReference().nagUser();
        return ((Directory)this.getLibsDirectory().get()).getAsFile();
    }

    @Override
    public DirectoryProperty getLibsDirectory() {
        return this.libsDirectory;
    }

    @Override
    public ProjectInternal getProject() {
        DeprecationLogger.deprecateMethod(BasePluginConvention.class, (String)"getProject()").withUpgradeGuideSection(6, "discontinued_methods").nagUser();
        return this.project;
    }

    @Override
    public void setProject(ProjectInternal project) {
        DeprecationLogger.deprecateMethod(BasePluginConvention.class, (String)"setProject()").withUpgradeGuideSection(6, "discontinued_methods").nagUser();
        this.project = project;
    }

    @Override
    public String getDistsDirName() {
        return this.distsDirName;
    }

    @Override
    public void setDistsDirName(String distsDirName) {
        this.distsDirName = distsDirName;
        this.distsDirectory.set(this.buildDirectory.dir(distsDirName));
    }

    @Override
    public String getLibsDirName() {
        return this.libsDirName;
    }

    @Override
    public void setLibsDirName(String libsDirName) {
        this.libsDirName = libsDirName;
        this.libsDirectory.set(this.buildDirectory.dir(libsDirName));
    }

    @Override
    public String getArchivesBaseName() {
        return this.archivesBaseName;
    }

    @Override
    public void setArchivesBaseName(String archivesBaseName) {
        this.archivesBaseName = archivesBaseName;
    }
}

