/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;

public class VersionConflictResolutionDetails
implements Describable {
    private final Collection<? extends ComponentResolutionState> candidates;
    private final int hashCode;

    public VersionConflictResolutionDetails(Collection<? extends ComponentResolutionState> candidates) {
        this.candidates = candidates;
        this.hashCode = candidates.hashCode();
    }

    public Collection<? extends ComponentResolutionState> getCandidates() {
        return this.candidates;
    }

    public String getDisplayName() {
        StringBuilder sb = new StringBuilder(16 + 16 * this.candidates.size());
        sb.append("between versions ");
        Iterator<? extends ComponentResolutionState> it = this.candidates.iterator();
        boolean more = false;
        while (it.hasNext()) {
            ComponentResolutionState next = it.next();
            if (more) {
                if (it.hasNext()) {
                    sb.append(", ");
                } else {
                    sb.append(" and ");
                }
            }
            more = true;
            sb.append(next.getId().getVersion());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionConflictResolutionDetails that = (VersionConflictResolutionDetails)o;
        return Objects.equal(this.candidates, that.candidates);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static List<ComponentSelectionDescriptorInternal> mergeCauses(List<ComponentSelectionDescriptorInternal> descriptors) {
        List<VersionConflictResolutionDetails> byVersionConflictResolution = VersionConflictResolutionDetails.collectVersionConflictCandidates(descriptors);
        if (byVersionConflictResolution != null && byVersionConflictResolution.size() > 1) {
            Set<ComponentResolutionState> allCandidates = VersionConflictResolutionDetails.mergeAllCandidates(byVersionConflictResolution);
            ArrayList merged = Lists.newArrayListWithCapacity((int)(descriptors.size() - 1));
            boolean added = false;
            for (ComponentSelectionDescriptorInternal descriptor : descriptors) {
                if (VersionConflictResolutionDetails.isByVersionConflict(descriptor)) {
                    if (!added) {
                        merged.add(ComponentSelectionReasons.CONFLICT_RESOLUTION.withDescription(new VersionConflictResolutionDetails(allCandidates)));
                    }
                    added = true;
                    continue;
                }
                merged.add(descriptor);
            }
            return merged;
        }
        return descriptors;
    }

    private static Set<ComponentResolutionState> mergeAllCandidates(List<VersionConflictResolutionDetails> byVersionConflictResolution) {
        LinkedHashSet allCandidates = Sets.newLinkedHashSet();
        for (VersionConflictResolutionDetails versionConflictResolutionDetails : byVersionConflictResolution) {
            allCandidates.addAll(versionConflictResolutionDetails.getCandidates());
        }
        return allCandidates;
    }

    private static List<VersionConflictResolutionDetails> collectVersionConflictCandidates(List<ComponentSelectionDescriptorInternal> descriptors) {
        ArrayList byVersionConflictResolution = null;
        for (ComponentSelectionDescriptorInternal descriptor : descriptors) {
            if (!VersionConflictResolutionDetails.isByVersionConflict(descriptor)) continue;
            if (byVersionConflictResolution == null) {
                byVersionConflictResolution = Lists.newArrayListWithCapacity((int)descriptors.size());
            }
            byVersionConflictResolution.add((VersionConflictResolutionDetails)descriptor.getDescribable());
        }
        return byVersionConflictResolution;
    }

    private static boolean isByVersionConflict(ComponentSelectionDescriptorInternal descriptor) {
        return descriptor.getCause() == ComponentSelectionCause.CONFLICT_RESOLUTION && descriptor.getDescribable() instanceof VersionConflictResolutionDetails;
    }
}

