/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.normalization.internal;

import com.google.common.collect.ImmutableSet;
import org.gradle.api.GradleException;
import org.gradle.api.internal.changedetection.state.IgnoringResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.normalization.internal.RuntimeClasspathNormalizationInternal;

public class DefaultRuntimeClasspathNormalization
implements RuntimeClasspathNormalizationInternal {
    private final ImmutableSet.Builder<String> ignoresBuilder = ImmutableSet.builder();
    private ResourceFilter resourceFilter;

    public void ignore(String pattern) {
        if (this.resourceFilter != null) {
            throw new GradleException("Cannot configure runtime classpath normalization after execution started.");
        }
        this.ignoresBuilder.add((Object)pattern);
    }

    @Override
    public ResourceFilter getResourceFilter() {
        if (this.resourceFilter == null) {
            ImmutableSet ignores = this.ignoresBuilder.build();
            this.resourceFilter = ignores.isEmpty() ? ResourceFilter.FILTER_NOTHING : new IgnoringResourceFilter((ImmutableSet<String>)ignores);
        }
        return this.resourceFilter;
    }
}

