/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.ExecOperations;

public class WorkerPublicServicesBuilder {
    private final ServiceRegistry internalServices;
    private boolean internalServicesRequired;

    WorkerPublicServicesBuilder(ServiceRegistry internalServices) {
        this.internalServices = internalServices;
    }

    WorkerPublicServicesBuilder withInternalServicesVisible(boolean canUseInternalServices) {
        this.internalServicesRequired = canUseInternalServices;
        return this;
    }

    DefaultServiceRegistry build() {
        if (this.internalServicesRequired) {
            return new DefaultServiceRegistry("unit of work services (internal)", new ServiceRegistry[]{this.internalServices});
        }
        DefaultServiceRegistry services = new DefaultServiceRegistry("unit of work services");
        services.add(ObjectFactory.class, (Object)((ObjectFactory)this.internalServices.get(ObjectFactory.class)));
        services.add(FileSystemOperations.class, (Object)((FileSystemOperations)this.internalServices.get(FileSystemOperations.class)));
        services.add(ExecOperations.class, (Object)((ExecOperations)this.internalServices.get(ExecOperations.class)));
        services.add(ProviderFactory.class, (Object)((ProviderFactory)this.internalServices.get(ProviderFactory.class)));
        return services;
    }
}

