/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.util;

import java.util.List;
import org.gradle.internal.os.OperatingSystem;

public class LongCommandLineDetectionUtil {
    public static final int MAX_COMMAND_LINE_LENGTH_WINDOWS = Short.MAX_VALUE;
    public static final int MAX_COMMAND_LINE_LENGTH_NIX = 0x200000;
    private static final String WINDOWS_LONG_COMMAND_EXCEPTION_MESSAGE = "The filename or extension is too long";
    private static final String NIX_LONG_COMMAND_EXCEPTION_MESSAGE = "error=7, Argument list too long";

    public static boolean hasCommandLineExceedMaxLength(String command, List<String> arguments) {
        int commandLineLength = command.length() + arguments.stream().map(String::length).reduce(Integer::sum).orElse(0) + arguments.size();
        return commandLineLength > LongCommandLineDetectionUtil.getMaxCommandLineLength();
    }

    private static int getMaxCommandLineLength() {
        int defaultMax = 0x200000;
        if (OperatingSystem.current().isWindows()) {
            defaultMax = Short.MAX_VALUE;
        }
        return Integer.getInteger("org.gradle.internal.cmdline.max.length", defaultMax);
    }

    public static boolean hasCommandLineExceedMaxLengthException(Throwable failureCause) {
        Throwable cause = failureCause;
        do {
            if (!cause.getMessage().contains(WINDOWS_LONG_COMMAND_EXCEPTION_MESSAGE) && !cause.getMessage().contains(NIX_LONG_COMMAND_EXCEPTION_MESSAGE)) continue;
            return true;
        } while ((cause = cause.getCause()) != null);
        return false;
    }
}

