/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.ISettingsFinder;
import org.gradle.initialization.ProjectSpec;
import org.gradle.initialization.ProjectSpecs;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.util.Path;

public class DefaultSettingsLoader
implements SettingsLoader {
    public static final String BUILD_SRC_PROJECT_PATH = ":buildSrc";
    private ISettingsFinder settingsFinder;
    private SettingsProcessor settingsProcessor;

    public DefaultSettingsLoader(ISettingsFinder settingsFinder, SettingsProcessor settingsProcessor) {
        this.settingsFinder = settingsFinder;
        this.settingsProcessor = settingsProcessor;
    }

    @Override
    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        SettingsInternal settings;
        StartParameter startParameter = gradle.getStartParameter();
        ProjectSpec spec = ProjectSpecs.forStartParameter(startParameter, settings = this.findSettingsAndLoadIfAppropriate(gradle, startParameter, gradle.getClassLoaderScope()));
        if (this.useEmptySettings(spec, settings, startParameter)) {
            settings = this.createEmptySettings(gradle, startParameter, settings.getClassLoaderScope());
        }
        this.setDefaultProject(spec, settings);
        return settings;
    }

    private boolean useEmptySettings(ProjectSpec spec, SettingsInternal loadedSettings, StartParameter startParameter) {
        if (startParameter.getSettingsFile() != null) {
            return false;
        }
        if (spec.containsProject(loadedSettings.getProjectRegistry())) {
            return false;
        }
        return startParameter.getProjectDir() != null && loadedSettings.getSettingsDir().equals(startParameter.getProjectDir());
    }

    private SettingsInternal createEmptySettings(GradleInternal gradle, StartParameter startParameter, ClassLoaderScope classLoaderScope) {
        StartParameter noSearchParameter = startParameter.newInstance();
        ((StartParameterInternal)noSearchParameter).useEmptySettingsWithoutDeprecationWarning();
        SettingsInternal settings = this.findSettingsAndLoadIfAppropriate(gradle, noSearchParameter, classLoaderScope);
        if (noSearchParameter.getBuildFile() != null) {
            ProjectDescriptor rootProject = settings.getRootProject();
            rootProject.setBuildFileName(noSearchParameter.getBuildFile().getName());
        }
        return settings;
    }

    private void setDefaultProject(ProjectSpec spec, SettingsInternal settings) {
        settings.setDefaultProject(spec.selectProject(settings.getSettingsScript().getDisplayName(), settings.getProjectRegistry()));
    }

    private SettingsInternal findSettingsAndLoadIfAppropriate(GradleInternal gradle, StartParameter startParameter, ClassLoaderScope classLoaderScope) {
        SettingsLocation settingsLocation = this.findSettings(startParameter);
        SettingsInternal settings = this.settingsProcessor.process(gradle, settingsLocation, classLoaderScope, startParameter);
        this.validate(settings);
        return settings;
    }

    private void validate(SettingsInternal settings) {
        settings.getProjectRegistry().getAllProjects().forEach(project -> {
            if (project.getPath().equals(BUILD_SRC_PROJECT_PATH)) {
                Path buildPath = settings.getGradle().getIdentityPath();
                String suffix = buildPath == Path.ROOT ? "" : " (in build " + buildPath + ")";
                throw new GradleException("'buildSrc' cannot be used as a project name as it is a reserved name" + suffix);
            }
        });
    }

    private SettingsLocation findSettings(StartParameter startParameter) {
        return this.settingsFinder.find(startParameter);
    }
}

