/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.CacheVersion;
import org.gradle.cache.internal.VersionStrategy;
import org.gradle.internal.vfs.AdditiveCache;

public class DefaultArtifactCacheMetadata
implements ArtifactCacheMetadata,
AdditiveCache {
    public static final CacheVersion CACHE_LAYOUT_VERSION = CacheLayout.META_DATA.getVersion();
    private final File cacheDir;
    private final File transformsDir;

    public DefaultArtifactCacheMetadata(CacheScopeMapping cacheScopeMapping) {
        this.cacheDir = cacheScopeMapping.getBaseDirectory(null, CacheLayout.ROOT.getKey(), VersionStrategy.SharedCache);
        this.transformsDir = cacheScopeMapping.getBaseDirectory(null, CacheLayout.TRANSFORMS.getKey(), VersionStrategy.SharedCache);
    }

    @Override
    public File getCacheDir() {
        return this.cacheDir;
    }

    @Override
    public File getTransformsStoreDirectory() {
        return this.transformsDir;
    }

    public List<File> getAdditiveCacheRoots() {
        return Arrays.asList(this.getFileStoreDirectory(), this.getTransformsStoreDirectory());
    }

    @Override
    public File getFileStoreDirectory() {
        return this.createCacheRelativeDir(CacheLayout.FILE_STORE);
    }

    @Override
    public File getExternalResourcesStoreDirectory() {
        return this.createCacheRelativeDir(CacheLayout.RESOURCES);
    }

    @Override
    public File getMetaDataStoreDirectory() {
        return new File(this.createCacheRelativeDir(CacheLayout.META_DATA), "descriptors");
    }

    private File createCacheRelativeDir(CacheLayout cacheLayout) {
        return cacheLayout.getPath(this.getCacheDir());
    }
}

