/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import java.util.Iterator;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AbstractFilteringTrace;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class ExpressionTypingServices {
    private final ExpressionTypingFacade expressionTypingFacade;
    private final ExpressionTypingComponents expressionTypingComponents;
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final StatementFilter statementFilter;

    public ExpressionTypingServices(@NotNull ExpressionTypingComponents components, @NotNull AnnotationChecker annotationChecker, @NotNull StatementFilter statementFilter, @NotNull ExpressionTypingVisitorDispatcher.ForDeclarations facade) {
        if (components == null) {
            ExpressionTypingServices.$$$reportNull$$$0(0);
        }
        if (annotationChecker == null) {
            ExpressionTypingServices.$$$reportNull$$$0(1);
        }
        if (statementFilter == null) {
            ExpressionTypingServices.$$$reportNull$$$0(2);
        }
        if (facade == null) {
            ExpressionTypingServices.$$$reportNull$$$0(3);
        }
        this.expressionTypingComponents = components;
        this.annotationChecker = annotationChecker;
        this.statementFilter = statementFilter;
        this.expressionTypingFacade = facade;
    }

    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        LanguageVersionSettings languageVersionSettings = this.expressionTypingComponents.languageVersionSettings;
        if (languageVersionSettings == null) {
            ExpressionTypingServices.$$$reportNull$$$0(4);
        }
        return languageVersionSettings;
    }

    @NotNull
    public StatementFilter getStatementFilter() {
        StatementFilter statementFilter = this.statementFilter;
        if (statementFilter == null) {
            ExpressionTypingServices.$$$reportNull$$$0(5);
        }
        return statementFilter;
    }

    @NotNull
    public KotlinType safeGetType(@NotNull LexicalScope scope, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace) {
        KotlinType type2;
        if (scope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(6);
        }
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(7);
        }
        if (expectedType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(8);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(9);
        }
        if (inferenceSession == null) {
            ExpressionTypingServices.$$$reportNull$$$0(10);
        }
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(11);
        }
        KotlinType kotlinType2 = (type2 = this.getType(scope, expression2, expectedType, dataFlowInfo, inferenceSession, trace)) != null ? type2 : ErrorUtils.createErrorType("Type for " + expression2.getText());
        if (kotlinType2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(12);
        }
        return kotlinType2;
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull LexicalScope scope, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace, boolean isStatement) {
        if (scope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(13);
        }
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(14);
        }
        if (expectedType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(15);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(16);
        }
        if (inferenceSession == null) {
            ExpressionTypingServices.$$$reportNull$$$0(17);
        }
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(18);
        }
        KotlinTypeInfo kotlinTypeInfo = this.getTypeInfo(scope, expression2, expectedType, dataFlowInfo, inferenceSession, trace, isStatement, expression2, ContextDependency.INDEPENDENT);
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(19);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull LexicalScope scope, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace, boolean isStatement, @NotNull KtExpression contextExpression, @NotNull ContextDependency contextDependency) {
        if (scope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(20);
        }
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(21);
        }
        if (expectedType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(22);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(23);
        }
        if (inferenceSession == null) {
            ExpressionTypingServices.$$$reportNull$$$0(24);
        }
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(25);
        }
        if (contextExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(26);
        }
        if (contextDependency == null) {
            ExpressionTypingServices.$$$reportNull$$$0(27);
        }
        ExpressionTypingContext context2 = ExpressionTypingContext.newContext(trace, scope, dataFlowInfo, expectedType, contextDependency, this.statementFilter, this.getLanguageVersionSettings(), this.expressionTypingComponents.dataFlowValueFactory, inferenceSession);
        if (contextExpression != expression2) {
            context2 = (ExpressionTypingContext)context2.replaceExpressionContextProvider((Function1<KtExpression, KtExpression>)((Function1)arg -> arg == expression2 ? contextExpression : null));
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingFacade.getTypeInfo(expression2, context2, isStatement);
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(28);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull KtExpression expression2, @NotNull ResolutionContext resolutionContext) {
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(29);
        }
        if (resolutionContext == null) {
            ExpressionTypingServices.$$$reportNull$$$0(30);
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingFacade.getTypeInfo(expression2, ExpressionTypingContext.newContext(resolutionContext));
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(31);
        }
        return kotlinTypeInfo;
    }

    @Nullable
    public KotlinType getType(@NotNull LexicalScope scope, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace) {
        if (scope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(32);
        }
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(33);
        }
        if (expectedType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(34);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(35);
        }
        if (inferenceSession == null) {
            ExpressionTypingServices.$$$reportNull$$$0(36);
        }
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(37);
        }
        return this.getTypeInfo(scope, expression2, expectedType, dataFlowInfo, inferenceSession, trace, false).getType();
    }

    public void checkFunctionReturnType(@NotNull LexicalScope functionInnerScope, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull DataFlowInfo dataFlowInfo, @Nullable KotlinType expectedReturnType, BindingTrace trace) {
        if (functionInnerScope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(38);
        }
        if (function2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(39);
        }
        if (functionDescriptor == null) {
            ExpressionTypingServices.$$$reportNull$$$0(40);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(41);
        }
        if (expectedReturnType == null) {
            expectedReturnType = functionDescriptor.getReturnType();
            if (!function2.hasBlockBody() && !function2.hasDeclaredReturnType()) {
                expectedReturnType = TypeUtils.NO_EXPECTED_TYPE;
            }
        }
        this.checkFunctionReturnType(function2, ExpressionTypingContext.newContext(trace, functionInnerScope, dataFlowInfo, expectedReturnType != null ? expectedReturnType : TypeUtils.NO_EXPECTED_TYPE, this.getLanguageVersionSettings(), this.expressionTypingComponents.dataFlowValueFactory));
    }

    void checkFunctionReturnType(KtDeclarationWithBody function2, ExpressionTypingContext context2) {
        KtExpression bodyExpression = function2.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        boolean blockBody = function2.hasBlockBody();
        ExpressionTypingContext newContext = blockBody ? (ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE) : context2;
        this.expressionTypingFacade.getTypeInfo(bodyExpression, newContext, blockBody);
    }

    @NotNull
    public KotlinTypeInfo getBlockReturnedType(KtBlockExpression expression2, ExpressionTypingContext context2, boolean isStatement) {
        KotlinTypeInfo kotlinTypeInfo = this.getBlockReturnedType(expression2, isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION, context2);
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(42);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getBlockReturnedType(@NotNull KtBlockExpression expression2, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context2) {
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(43);
        }
        if (coercionStrategyForLastExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(44);
        }
        if (context2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(45);
        }
        List<KtExpression> block = StatementFilterKt.filterStatements(this.statementFilter, expression2);
        DeclarationDescriptor containingDescriptor = context2.scope.getOwnerDescriptor();
        TraceBasedLocalRedeclarationChecker redeclarationChecker = new TraceBasedLocalRedeclarationChecker(context2.trace, this.expressionTypingComponents.overloadChecker);
        LexicalWritableScope scope = new LexicalWritableScope(context2.scope, containingDescriptor, false, redeclarationChecker, LexicalScopeKind.CODE_BLOCK);
        KotlinTypeInfo r = block.isEmpty() ? this.expressionTypingComponents.dataFlowAnalyzer.createCheckedTypeInfo(this.expressionTypingComponents.builtIns.getUnitType(), context2, expression2) : this.getBlockReturnedTypeWithWritableScope(scope, block, coercionStrategyForLastExpression, (ExpressionTypingContext)context2.replaceStatementFilter(this.statementFilter));
        scope.freeze();
        if (containingDescriptor instanceof ScriptDescriptor) {
            context2.trace.record(BindingContext.SCRIPT_SCOPE, (ScriptDescriptor)containingDescriptor, scope);
        }
        KotlinTypeInfo kotlinTypeInfo = r;
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(46);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinType getBodyExpressionType(@NotNull BindingTrace trace, @NotNull LexicalScope outerScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor) {
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(47);
        }
        if (outerScope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(48);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(49);
        }
        if (function2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(50);
        }
        if (functionDescriptor == null) {
            ExpressionTypingServices.$$$reportNull$$$0(51);
        }
        KtExpression bodyExpression = function2.getBodyExpression();
        assert (bodyExpression != null);
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(outerScope, functionDescriptor, trace, this.expressionTypingComponents.overloadChecker);
        ExpressionTypingContext context2 = ExpressionTypingContext.newContext(trace, functionInnerScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.getLanguageVersionSettings(), this.expressionTypingComponents.dataFlowValueFactory);
        KotlinTypeInfo typeInfo = this.expressionTypingFacade.getTypeInfo(bodyExpression, context2, function2.hasBlockBody());
        KotlinType type2 = typeInfo.getType();
        if (type2 != null) {
            KotlinType kotlinType2 = type2;
            if (kotlinType2 == null) {
                ExpressionTypingServices.$$$reportNull$$$0(52);
            }
            return kotlinType2;
        }
        SimpleType simpleType2 = ErrorUtils.createErrorType("Error function type");
        if (simpleType2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(53);
        }
        return simpleType2;
    }

    KotlinTypeInfo getBlockReturnedTypeWithWritableScope(@NotNull LexicalWritableScope scope, @NotNull List<? extends KtElement> block, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context2) {
        if (scope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(54);
        }
        if (block == null) {
            ExpressionTypingServices.$$$reportNull$$$0(55);
        }
        if (coercionStrategyForLastExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(56);
        }
        if (context2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(57);
        }
        if (block.isEmpty()) {
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)this.expressionTypingComponents.builtIns.getUnitType(), context2);
        }
        ExpressionTypingVisitorDispatcher.ForBlock blockLevelVisitor = new ExpressionTypingVisitorDispatcher.ForBlock(this.expressionTypingComponents, this.annotationChecker, scope);
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(scope)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KotlinTypeInfo result2 = TypeInfoFactoryKt.noTypeInfo(context2);
        DataFlowInfo beforeJumpInfo = newContext.dataFlowInfo;
        boolean jumpOutPossible = false;
        boolean isFirstStatement = true;
        Iterator<? extends KtElement> iterator2 = block.iterator();
        while (iterator2.hasNext()) {
            EffectsFilteringTrace traceForSingleStatement = new EffectsFilteringTrace(context2.trace);
            newContext = (ExpressionTypingContext)newContext.replaceBindingTrace(traceForSingleStatement);
            KtElement statement2 = iterator2.next();
            if (!(statement2 instanceof KtExpression)) continue;
            KtExpression statementExpression = (KtExpression)statement2;
            if (!iterator2.hasNext()) {
                result2 = this.getTypeOfLastExpressionInBlock(statementExpression, (ExpressionTypingContext)newContext.replaceExpectedType(context2.expectedType), coercionStrategyForLastExpression, blockLevelVisitor);
                if (result2.getType() != null && statementExpression.getParent() instanceof KtBlockExpression) {
                    DataFlowValue lastExpressionValue = this.expressionTypingComponents.dataFlowValueFactory.createDataFlowValue(statementExpression, result2.getType(), context2);
                    DataFlowValue blockExpressionValue = this.expressionTypingComponents.dataFlowValueFactory.createDataFlowValue((KtBlockExpression)statementExpression.getParent(), result2.getType(), context2);
                    result2 = result2.replaceDataFlowInfo(result2.getDataFlowInfo().assign(blockExpressionValue, lastExpressionValue, this.expressionTypingComponents.languageVersionSettings));
                }
            } else {
                result2 = blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)newContext.replaceContextDependency(ContextDependency.INDEPENDENT), true);
            }
            DataFlowInfo newDataFlowInfo = result2.getDataFlowInfo();
            if (!jumpOutPossible) {
                beforeJumpInfo = result2.getJumpFlowInfo();
                jumpOutPossible = result2.getJumpOutPossible();
            }
            if (newDataFlowInfo != newContext.dataFlowInfo) {
                newContext = (ExpressionTypingContext)newContext.replaceDataFlowInfo(newDataFlowInfo);
            }
            blockLevelVisitor = new ExpressionTypingVisitorDispatcher.ForBlock(this.expressionTypingComponents, this.annotationChecker, scope);
            if (!isFirstStatement) continue;
            this.expressionTypingComponents.contractParsingServices.checkContractAndRecordIfPresent(statementExpression, context2.trace, scope);
            isFirstStatement = false;
        }
        return result2.replaceJumpOutPossible(jumpOutPossible).replaceJumpFlowInfo(beforeJumpInfo);
    }

    private KotlinTypeInfo getTypeOfLastExpressionInBlock(@NotNull KtExpression statementExpression, @NotNull ExpressionTypingContext context2, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingInternals blockLevelVisitor) {
        KtFunctionLiteral parent2;
        if (statementExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(58);
        }
        if (context2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(59);
        }
        if (coercionStrategyForLastExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(60);
        }
        if (blockLevelVisitor == null) {
            ExpressionTypingServices.$$$reportNull$$$0(61);
        }
        if (context2.expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            KotlinType expectedType = context2.expectedType == TypeUtils.UNIT_EXPECTED_TYPE || coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT && KotlinBuiltIns.isUnit(context2.expectedType) ? TypeUtils.UNIT_EXPECTED_TYPE : context2.expectedType;
            ContextDependency dependency = context2.contextDependency;
            if (this.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
                dependency = ContextDependency.INDEPENDENT;
            }
            return blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(expectedType)).replaceContextDependency(dependency), true);
        }
        if (context2.languageVersionSettings.supportsFeature(LanguageFeature.NewInference) && statementExpression instanceof KtLambdaExpression && (parent2 = PsiUtilsKt.getNonStrictParentOfType(statementExpression, KtFunctionLiteral.class)) != null) {
            KtFunctionLiteral functionLiteral = parent2;
            KotlinResolutionCallbacksImpl.LambdaInfo info2 = context2.trace.getBindingContext().get(BindingContext.NEW_INFERENCE_LAMBDA_INFO, functionLiteral);
            if (info2 != null) {
                info2.getLastExpressionInfo().setLexicalScope(context2.scope);
                info2.getLastExpressionInfo().setTrace(context2.trace);
                return new KotlinTypeInfo(TypeUtils.DONT_CARE, context2.dataFlowInfo);
            }
        }
        KotlinTypeInfo result2 = blockLevelVisitor.getTypeInfo(statementExpression, context2, true);
        if (coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT) {
            KtBinaryExpression binaryExpression;
            IElementType operationType;
            boolean mightBeUnit = false;
            if (statementExpression instanceof KtDeclaration && (!(statementExpression instanceof KtNamedFunction) || statementExpression.getName() != null)) {
                mightBeUnit = true;
            }
            if (statementExpression instanceof KtBinaryExpression && ((operationType = (binaryExpression = (KtBinaryExpression)statementExpression).getOperationToken()) == KtTokens.EQ || OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType))) {
                mightBeUnit = true;
            }
            if (mightBeUnit) {
                assert (result2.getType() == null || KotlinBuiltIns.isUnit(result2.getType()));
                result2 = result2.replaceType(this.expressionTypingComponents.builtIns.getUnitType());
            }
        }
        return result2;
    }

    public LocalRedeclarationChecker createLocalRedeclarationChecker(BindingTrace trace) {
        return new TraceBasedLocalRedeclarationChecker(trace, this.expressionTypingComponents.overloadChecker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 19: 
            case 28: 
            case 31: 
            case 42: 
            case 46: 
            case 52: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 19: 
            case 28: 
            case 31: 
            case 42: 
            case 46: 
            case 52: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationChecker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 19: 
            case 28: 
            case 31: 
            case 42: 
            case 46: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices";
                break;
            }
            case 6: 
            case 13: 
            case 20: 
            case 32: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 14: 
            case 21: 
            case 29: 
            case 33: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: 
            case 15: 
            case 22: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 9: 
            case 16: 
            case 23: 
            case 35: 
            case 41: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfo";
                break;
            }
            case 10: 
            case 17: 
            case 24: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferenceSession";
                break;
            }
            case 11: 
            case 18: 
            case 25: 
            case 37: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextExpression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDependency";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolutionContext";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionInnerScope";
                break;
            }
            case 39: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 40: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 44: 
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coercionStrategyForLastExpression";
                break;
            }
            case 45: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerScope";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementExpression";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockLevelVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageVersionSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementFilter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "safeGetType";
                break;
            }
            case 19: 
            case 28: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfo";
                break;
            }
            case 42: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockReturnedType";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getBodyExpressionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 19: 
            case 28: 
            case 31: 
            case 42: 
            case 46: 
            case 52: 
            case 53: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "safeGetType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInfo";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionReturnType";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getBlockReturnedType";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getBodyExpressionType";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getBlockReturnedTypeWithWritableScope";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfLastExpressionInBlock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 19: 
            case 28: 
            case 31: 
            case 42: 
            case 46: 
            case 52: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EffectsFilteringTrace
    extends AbstractFilteringTrace {
        public EffectsFilteringTrace(BindingTrace parentTrace) {
            super(parentTrace, "Effects filtering trace");
        }

        @Override
        protected <K, V> boolean shouldBeHiddenFromParent(@NotNull WritableSlice<K, V> slice, K key) {
            if (slice == null) {
                EffectsFilteringTrace.$$$reportNull$$$0(0);
            }
            return slice == BindingContext.EXPRESSION_EFFECTS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices$EffectsFilteringTrace", "shouldBeHiddenFromParent"));
        }
    }
}

