/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import org.gradle.api.internal.tasks.scala.AnalysisStoreProvider;
import org.gradle.api.internal.tasks.scala.SbtLoggerAdapter;
import org.gradle.api.internal.tasks.scala.ZincScalaCompiler;
import org.gradle.api.logging.Logging;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import sbt.internal.inc.AnalyzingCompiler$;
import sbt.internal.inc.RawCompiler;
import sbt.internal.inc.ScalaInstance;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import xsbti.Logger;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.ClasspathOptionsUtil;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.ZincCompilerUtil;

public class ZincScalaCompilerFactory {
    private static final org.gradle.api.logging.Logger LOGGER = Logging.getLogger(ZincScalaCompilerFactory.class);

    static ZincScalaCompiler getCompiler(CacheRepository cacheRepository, java.lang.Iterable<File> scalaClasspath) {
        ScalaInstance scalaInstance = ZincScalaCompilerFactory.getScalaInstance(scalaClasspath);
        String zincVersion = ZincCompilerUtil.class.getPackage().getImplementationVersion();
        String scalaVersion = scalaInstance.actualVersion();
        String javaVersion = Jvm.current().getJavaVersion().getMajorVersion();
        String zincCacheKey = String.format("zinc-%s_%s_%s", zincVersion, scalaVersion, javaVersion);
        String zincCacheName = String.format("%s compiler cache", zincCacheKey);
        PersistentCache zincCache = cacheRepository.cache(zincCacheKey).withDisplayName(zincCacheName).withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
        File compilerBridgeSourceJar = ZincScalaCompilerFactory.findFile("compiler-bridge", scalaClasspath);
        File bridgeJar = ZincScalaCompilerFactory.getBridgeJar(zincCache, scalaInstance, compilerBridgeSourceJar, sbt.util.Logger.xlog2Log((Logger)new SbtLoggerAdapter()));
        ScalaCompiler scalaCompiler = ZincCompilerUtil.scalaCompiler((xsbti.compile.ScalaInstance)scalaInstance, (File)bridgeJar, (ClasspathOptions)ClasspathOptionsUtil.auto());
        return new ZincScalaCompiler(scalaInstance, scalaCompiler, new AnalysisStoreProvider());
    }

    private static ClassLoader getClassLoader(java.lang.Iterable<File> classpath) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (File file : classpath) {
                urls.add(file.toURI().toURL());
            }
            return new URLClassLoader(urls.toArray(new URL[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ScalaInstance getScalaInstance(java.lang.Iterable<File> scalaClasspath) {
        ClassLoader scalaClassLoader = ZincScalaCompilerFactory.getClassLoader(scalaClasspath);
        String scalaVersion = ZincScalaCompilerFactory.getScalaVersion(scalaClassLoader);
        File libraryJar = ZincScalaCompilerFactory.findFile("scala-library", scalaClasspath);
        File compilerJar = ZincScalaCompilerFactory.findFile("scala-compiler", scalaClasspath);
        return new ScalaInstance(scalaVersion, scalaClassLoader, ZincScalaCompilerFactory.getClassLoader(Arrays.asList(libraryJar)), libraryJar, compilerJar, (File[])Iterables.toArray(scalaClasspath, File.class), Option.empty());
    }

    private static File getBridgeJar(PersistentCache zincCache, ScalaInstance scalaInstance, File compilerBridgeSourceJar, sbt.util.Logger logger) {
        return (File)zincCache.useCache(() -> {
            File bridgeJar = new File(zincCache.getBaseDir(), "compiler-bridge.jar");
            if (bridgeJar.exists()) {
                return bridgeJar;
            }
            Timer timer = Time.startTimer();
            RawCompiler rawCompiler = new RawCompiler((xsbti.compile.ScalaInstance)scalaInstance, ClasspathOptionsUtil.manual(), logger);
            Iterable sourceJars = JavaConverters.collectionAsScalaIterable(Collections.singletonList(compilerBridgeSourceJar));
            Iterable xsbtiJars = JavaConverters.collectionAsScalaIterable(Arrays.asList(scalaInstance.allJars()));
            AnalyzingCompiler$.MODULE$.compileSources(sourceJars, bridgeJar, xsbtiJars, "compiler-bridge", rawCompiler, logger);
            String interfaceCompletedMessage = String.format("Scala Compiler interface compilation took %s", timer.getElapsed());
            if (timer.getElapsedMillis() > 30000L) {
                LOGGER.warn(interfaceCompletedMessage);
            } else {
                LOGGER.debug(interfaceCompletedMessage);
            }
            return bridgeJar;
        });
    }

    private static File findFile(String prefix, java.lang.Iterable<File> files) {
        for (File f : files) {
            if (!f.getName().startsWith(prefix)) continue;
            return f;
        }
        throw new IllegalStateException(String.format("Cannot find any files starting with %s in %s", prefix, files));
    }

    private static String getScalaVersion(ClassLoader scalaClassLoader) {
        try {
            Properties props = new Properties();
            props.load(scalaClassLoader.getResourceAsStream("library.properties"));
            return props.getProperty("version.number");
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to determine scala version");
        }
    }
}

