/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.injected.editor.VirtualFileWindow;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageExtension;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.LanguageSubstitutor;
import org.jetbrains.kotlin.com.intellij.util.FileContentUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class LanguageSubstitutors
extends LanguageExtension<LanguageSubstitutor> {
    public static final LanguageSubstitutors INSTANCE = new LanguageSubstitutors();
    private static final Logger LOG = Logger.getInstance(LanguageSubstitutors.class);
    private static final Key<Key<Language>> PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY = Key.create("PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY");
    private static final AtomicBoolean REQUESTS_DRAIN_NEEDED = new AtomicBoolean(true);
    private static final ConcurrentMap<VirtualFile, SubstitutionInfo> ourReparsingRequests = ContainerUtil.newConcurrentMap();

    private LanguageSubstitutors() {
        super("org.jetbrains.kotlin.com.intellij.lang.substitutor");
    }

    @NotNull
    public Language substituteLanguage(@NotNull Language lang, @NotNull VirtualFile file2, @NotNull Project project) {
        if (lang == null) {
            LanguageSubstitutors.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            LanguageSubstitutors.$$$reportNull$$$0(1);
        }
        if (project == null) {
            LanguageSubstitutors.$$$reportNull$$$0(2);
        }
        for (LanguageSubstitutor substitutor2 : this.forKey(lang)) {
            Language language = substitutor2.getLanguage(file2, project);
            if (language == null) continue;
            LanguageSubstitutors.processLanguageSubstitution(file2, lang, language, project);
            Language language2 = language;
            if (language2 == null) {
                LanguageSubstitutors.$$$reportNull$$$0(3);
            }
            return language2;
        }
        Language language = lang;
        if (language == null) {
            LanguageSubstitutors.$$$reportNull$$$0(4);
        }
        return language;
    }

    private static void processLanguageSubstitution(@NotNull VirtualFile file2, @NotNull Language originalLang, @NotNull Language substitutedLang, @NotNull Project project) {
        if (file2 == null) {
            LanguageSubstitutors.$$$reportNull$$$0(5);
        }
        if (originalLang == null) {
            LanguageSubstitutors.$$$reportNull$$$0(6);
        }
        if (substitutedLang == null) {
            LanguageSubstitutors.$$$reportNull$$$0(7);
        }
        if (project == null) {
            LanguageSubstitutors.$$$reportNull$$$0(8);
        }
        if (file2 instanceof VirtualFileWindow) {
            return;
        }
        Key<Language> projectKey = LanguageSubstitutors.getOrCreateProjectKey(project);
        Language prevSubstitutedLang = projectKey.get(file2);
        Language prevLang = ObjectUtils.notNull(prevSubstitutedLang, originalLang);
        if (!prevLang.is(substitutedLang) && file2.replace(projectKey, prevSubstitutedLang, substitutedLang)) {
            if (prevSubstitutedLang == null) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            LanguageSubstitutors.requestReparsing(file2, prevLang, substitutedLang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Key<Language> getOrCreateProjectKey(@NotNull Project project) {
        Key<Language> key;
        if (project == null) {
            LanguageSubstitutors.$$$reportNull$$$0(9);
        }
        if ((key = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.get(project)) == null) {
            Key<Key<Language>> key2 = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY;
            synchronized (key2) {
                key = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.get(project);
                if (key == null) {
                    key = new Key("Substituted lang key for " + project.getName());
                    PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.set(project, key);
                }
            }
        }
        Key<Language> key3 = key;
        if (key3 == null) {
            LanguageSubstitutors.$$$reportNull$$$0(10);
        }
        return key3;
    }

    private static void requestReparsing(@NotNull VirtualFile file2, @NotNull Language prevLang, @NotNull Language substitutedLang) {
        if (file2 == null) {
            LanguageSubstitutors.$$$reportNull$$$0(11);
        }
        if (prevLang == null) {
            LanguageSubstitutors.$$$reportNull$$$0(12);
        }
        if (substitutedLang == null) {
            LanguageSubstitutors.$$$reportNull$$$0(13);
        }
        ourReparsingRequests.put(file2, new SubstitutionInfo(prevLang, substitutedLang));
        if (REQUESTS_DRAIN_NEEDED.compareAndSet(true, false)) {
            TransactionGuard.getInstance().submitTransactionLater(ApplicationManager.getApplication(), () -> {
                REQUESTS_DRAIN_NEEDED.set(true);
                ArrayList set = ContainerUtil.newArrayList(ourReparsingRequests.entrySet());
                ArrayList files2 = ContainerUtil.newArrayListWithCapacity(set.size());
                int id = 1;
                for (Map.Entry entry : set) {
                    VirtualFile f = (VirtualFile)entry.getKey();
                    SubstitutionInfo info2 = (SubstitutionInfo)entry.getValue();
                    ourReparsingRequests.remove(f);
                    if (!f.isValid()) continue;
                    LOG.info("Reparsing " + f.getPath() + " because of language substitution " + info2.myPrevLang.getID() + "->" + info2.mySubstitutedLang.getID() + ", #" + id++);
                    files2.add(f);
                }
                if (files2.size() > 0) {
                    FileContentUtilCore.reparseFiles(files2);
                }
            });
        }
    }

    public static void cancelReparsing(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LanguageSubstitutors.$$$reportNull$$$0(14);
        }
        ourReparsingRequests.remove(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalLang";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutedLang";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevLang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProjectKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "substituteLanguage";
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processLanguageSubstitution";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateProjectKey";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "requestReparsing";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cancelReparsing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SubstitutionInfo {
        private final Language myPrevLang;
        private final Language mySubstitutedLang;

        SubstitutionInfo(@NotNull Language prevLang, @NotNull Language substitutedLang) {
            if (prevLang == null) {
                SubstitutionInfo.$$$reportNull$$$0(0);
            }
            if (substitutedLang == null) {
                SubstitutionInfo.$$$reportNull$$$0(1);
            }
            this.myPrevLang = prevLang;
            this.mySubstitutedLang = substitutedLang;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prevLang";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitutedLang";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors$SubstitutionInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

