/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.transform.DefaultTransformationWorkspace;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceIdentity;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceProvider;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Try;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.file.ReservedFileSystemLocation;

@NotThreadSafe
public class MutableTransformationWorkspaceProvider
implements TransformationWorkspaceProvider,
ReservedFileSystemLocation {
    private final Provider<Directory> baseDirectory;
    private final ExecutionHistoryStore executionHistoryStore;

    public MutableTransformationWorkspaceProvider(Provider<Directory> baseDirectory, ExecutionHistoryStore executionHistoryStore) {
        this.baseDirectory = baseDirectory;
        this.executionHistoryStore = executionHistoryStore;
    }

    @Override
    public ExecutionHistoryStore getExecutionHistoryStore() {
        return this.executionHistoryStore;
    }

    @Override
    public Try<ImmutableList<File>> withWorkspace(TransformationWorkspaceIdentity identity, TransformationWorkspaceProvider.TransformationWorkspaceAction workspaceAction) {
        String workspacePath = identity.getIdentity();
        DefaultTransformationWorkspace workspace = new DefaultTransformationWorkspace(new File(((Directory)this.baseDirectory.get()).getAsFile(), workspacePath));
        return workspaceAction.useWorkspace(workspacePath, workspace);
    }

    public Provider<? extends FileSystemLocation> getReservedFileSystemLocation() {
        return this.baseDirectory;
    }
}

