/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.intrinsics.KClassJavaProperty;
import org.jetbrains.kotlin.backend.jvm.lower.AnnotationLowering;
import org.jetbrains.kotlin.backend.jvm.lower.AnnotationLoweringKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetterCallImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\r\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AnnotationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "javaClassArrayType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "typeArguments", "", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "javaClassType", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "lowerAnnotationField", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isGetJava", "", "backend.jvm"})
final class AnnotationLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        if (!IrUtilsKt.isAnnotationClass(irClass)) {
            return super.visitClass(irClass);
        }
        irClass.getDeclarations().removeIf(visitClass.1.INSTANCE);
        for (IrDeclaration declaration2 : irClass.getDeclarations()) {
            if (!(declaration2 instanceof IrSimpleFunction)) continue;
            this.lowerAnnotationField((IrSimpleFunction)declaration2);
        }
        return irClass;
    }

    private final void lowerAnnotationField(IrSimpleFunction declaration2) {
        IrType irType;
        Object object = declaration2.getCorrespondingPropertySymbol();
        if (object == null || (object = (IrProperty)object.getOwner()) == null) {
            return;
        }
        Object property2 = object;
        IrField irField = property2.getBackingField();
        if (irField == null) {
            return;
        }
        IrField field2 = irField;
        if (IrTypeUtilsKt.isKClass(field2.getType())) {
            IrType irType2 = field2.getType();
            if (irType2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            }
            irType = this.javaClassType(((IrSimpleType)irType2).getArguments());
        } else if (AnnotationLoweringKt.access$isKClassArray(field2.getType())) {
            IrType irType3 = AnnotationLoweringKt.access$getSingleTypeProjectionOrNull$p(field2.getType());
            if (irType3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrTypeProjection");
            }
            IrTypeProjection projection = (IrTypeProjection)((Object)irType3);
            IrType irType4 = projection.getType();
            if (irType4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            }
            irType = this.javaClassArrayType(projection.getVariance(), ((IrSimpleType)irType4).getArguments());
        } else {
            return;
        }
        IrType newType = irType;
        boolean $i$f$buildField = false;
        IrFieldBuilder irFieldBuilder = new IrFieldBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFieldBuilder $this$run$iv = irFieldBuilder;
        boolean bl3 = false;
        IrFieldBuilder $this$buildField = $this$run$iv;
        boolean bl4 = false;
        $this$buildField.updateFrom(field2);
        $this$buildField.setName(field2.getName());
        $this$buildField.setType(newType);
        IrField newField = DeclarationBuildersKt.buildField($this$run$iv);
        newField.setCorrespondingPropertySymbol(property2.getSymbol());
        newField.setInitializer(field2.getInitializer());
        property2.setBackingField(newField);
        declaration2.setReturnType(newType);
        declaration2.setBody(null);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrSimpleFunction irSimpleFunction;
        boolean wrapIntoArray;
        IrGetterCallImpl receiver2;
        boolean wrapIntoKClass;
        block14: {
            block13: {
                IrExpression irExpression;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                wrapIntoKClass = true;
                IrExpression subject = expression2;
                if (this.isGetJava(expression2)) {
                    IrExpression irExpression2 = expression2.getExtensionReceiver();
                    if (irExpression2 == null) {
                        Intrinsics.throwNpe();
                    }
                    subject = irExpression2;
                    wrapIntoKClass = false;
                }
                if (!((irExpression = subject) instanceof IrGetterCallImpl)) {
                    irExpression = null;
                }
                IrGetterCallImpl irGetterCallImpl = (IrGetterCallImpl)irExpression;
                if (irGetterCallImpl == null) {
                    return super.visitCall(expression2);
                }
                receiver2 = irGetterCallImpl;
                wrapIntoArray = AnnotationLoweringKt.access$isKClassArray(receiver2.getType());
                if (!wrapIntoArray && !IrTypeUtilsKt.isKClass(receiver2.getType())) {
                    return super.visitCall(expression2);
                }
                IrFunction irFunction = receiver2.getSymbol().getOwner();
                if (!(irFunction instanceof IrSimpleFunction)) {
                    irFunction = null;
                }
                if ((irSimpleFunction = (IrSimpleFunction)irFunction) == null) break block13;
                IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
                boolean bl = false;
                boolean bl2 = false;
                IrSimpleFunction it = irSimpleFunction2;
                boolean bl3 = false;
                IrDeclarationParent irDeclarationParent = it.getParent();
                if (!(irDeclarationParent instanceof IrClass)) {
                    irDeclarationParent = null;
                }
                IrClass irClass = (IrClass)irDeclarationParent;
                irSimpleFunction = (irClass != null ? IrUtilsKt.isAnnotationClass(irClass) : false) ? irSimpleFunction2 : null;
                if (irSimpleFunction != null) break block14;
            }
            return super.visitCall(expression2);
        }
        IrSimpleFunction function2 = irSimpleFunction;
        Object object = function2.getCorrespondingPropertySymbol();
        if (object == null || (object = (IrProperty)object.getOwner()) == null || (object = object.getBackingField()) == null) {
            return super.visitCall(expression2);
        }
        Object field2 = object;
        DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder(this.context, function2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        IrBuilderWithScope irBuilderWithScope = irBuilder;
        IrType irType = field2.getType();
        IrExpression irExpression = receiver2.getDispatchReceiver();
        if (irExpression == null) {
            Intrinsics.throwNpe();
        }
        IrCall getField = ExpressionHelpersKt.irGet(irBuilderWithScope, irType, irExpression, receiver2.getSymbol());
        if (!wrapIntoKClass) {
            return getField;
        }
        IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)irBuilder, wrapIntoArray ? this.context.getIr().getSymbols().getGetOrCreateKotlinClasses() : this.context.getIr().getSymbols().getGetOrCreateKotlinClass());
        boolean bl = false;
        boolean bl4 = false;
        IrCall $this$apply = irCall;
        boolean bl5 = false;
        $this$apply.putValueArgument(0, getField);
        return irCall;
    }

    private final IrType javaClassType(List<? extends IrTypeArgument> typeArguments2) {
        return IrTypesKt.createType(this.context.getIr().getSymbols().getJavaLangClass(), false, typeArguments2);
    }

    private final IrType javaClassArrayType(Variance variance, List<? extends IrTypeArgument> typeArguments2) {
        IrTypeProjection argument = IrSimpleTypeImplKt.makeTypeProjection(this.javaClassType(typeArguments2), variance);
        return IrTypesKt.createType(this.context.getIrBuiltIns().getArrayClass(), false, CollectionsKt.listOf((Object)argument));
    }

    private final boolean isGetJava(@NotNull IrCall $this$isGetJava) {
        return this.context.getIrIntrinsics().getIntrinsic($this$isGetJava.getSymbol()) instanceof KClassJavaProperty;
    }

    public AnnotationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

