/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.tower.TowerLevelsKt;
import org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.CaptureKind;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BindingContextUtils {
    private BindingContextUtils() {
    }

    @Nullable
    public static VariableDescriptor extractVariableFromResolvedCall(@NotNull BindingContext bindingContext, @Nullable KtElement callElement) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        if (bindingContext == null) {
            BindingContextUtils.$$$reportNull$$$0(0);
        }
        if ((resolvedCall2 = CallUtilKt.getResolvedCall(callElement, bindingContext)) == null || !(resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor)) {
            return null;
        }
        return (VariableDescriptor)resolvedCall2.getResultingDescriptor();
    }

    @Nullable
    public static VariableDescriptor variableDescriptorForDeclaration(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof VariableDescriptor) {
            return (VariableDescriptor)descriptor2;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            return TowerLevelsKt.getFakeDescriptorForObject((ClassDescriptor)descriptor2);
        }
        return null;
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorFromReference(@NotNull BindingContext bindingContext, @Nullable KtElement element) {
        if (bindingContext == null) {
            BindingContextUtils.$$$reportNull$$$0(1);
        }
        if (element instanceof KtSimpleNameExpression) {
            return BindingContextUtils.variableDescriptorForDeclaration(bindingContext.get(BindingContext.REFERENCE_TARGET, (KtSimpleNameExpression)element));
        }
        if (element instanceof KtQualifiedExpression) {
            return BindingContextUtils.extractVariableDescriptorFromReference(bindingContext, ((KtQualifiedExpression)element).getSelectorExpression());
        }
        return null;
    }

    public static void recordFunctionDeclarationToDescriptor(@NotNull BindingTrace trace, @NotNull PsiElement psiElement, @NotNull SimpleFunctionDescriptor function2) {
        if (trace == null) {
            BindingContextUtils.$$$reportNull$$$0(2);
        }
        if (psiElement == null) {
            BindingContextUtils.$$$reportNull$$$0(3);
        }
        if (function2 == null) {
            BindingContextUtils.$$$reportNull$$$0(4);
        }
        trace.record(BindingContext.FUNCTION, psiElement, function2);
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key) {
        if (bindingContext == null) {
            BindingContextUtils.$$$reportNull$$$0(5);
        }
        if (slice == null) {
            BindingContextUtils.$$$reportNull$$$0(6);
        }
        if (key == null) {
            BindingContextUtils.$$$reportNull$$$0(7);
        }
        V v2 = BindingContextUtils.getNotNull(bindingContext, slice, key, "Value at " + slice + " must not be null for " + key);
        if (v2 == null) {
            BindingContextUtils.$$$reportNull$$$0(8);
        }
        return v2;
    }

    @NotNull
    public static KotlinType getTypeNotNull(@NotNull BindingContext bindingContext, @NotNull KtExpression expression2) {
        KotlinType result2;
        if (bindingContext == null) {
            BindingContextUtils.$$$reportNull$$$0(9);
        }
        if (expression2 == null) {
            BindingContextUtils.$$$reportNull$$$0(10);
        }
        if ((result2 = bindingContext.getType(expression2)) == null) {
            throw new IllegalStateException("Type must be not null for " + expression2);
        }
        KotlinType kotlinType2 = result2;
        if (kotlinType2 == null) {
            BindingContextUtils.$$$reportNull$$$0(11);
        }
        return kotlinType2;
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key, @NotNull String messageIfNull) {
        V value;
        if (bindingContext == null) {
            BindingContextUtils.$$$reportNull$$$0(12);
        }
        if (slice == null) {
            BindingContextUtils.$$$reportNull$$$0(13);
        }
        if (key == null) {
            BindingContextUtils.$$$reportNull$$$0(14);
        }
        if (messageIfNull == null) {
            BindingContextUtils.$$$reportNull$$$0(15);
        }
        if ((value = bindingContext.get(slice, key)) == null) {
            throw new IllegalStateException(messageIfNull);
        }
        V v2 = value;
        if (v2 == null) {
            BindingContextUtils.$$$reportNull$$$0(16);
        }
        return v2;
    }

    @NotNull
    public static DeclarationDescriptor getEnclosingDescriptor(@NotNull BindingContext context, @NotNull KtElement element) {
        KtNamedDeclaration declaration;
        if (context == null) {
            BindingContextUtils.$$$reportNull$$$0(17);
        }
        if (element == null) {
            BindingContextUtils.$$$reportNull$$$0(18);
        }
        if ((declaration = PsiTreeUtil.getParentOfType((PsiElement)element, KtNamedDeclaration.class)) instanceof KtFunctionLiteral) {
            DeclarationDescriptor declarationDescriptor = BindingContextUtils.getEnclosingDescriptor(context, declaration);
            if (declarationDescriptor == null) {
                BindingContextUtils.$$$reportNull$$$0(19);
            }
            return declarationDescriptor;
        }
        DeclarationDescriptor descriptor2 = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
        assert (descriptor2 != null) : "No descriptor for named declaration: " + declaration.getText() + "\n(of type " + declaration.getClass() + ")";
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor == null) {
            BindingContextUtils.$$$reportNull$$$0(20);
        }
        return declarationDescriptor;
    }

    @Nullable
    public static FunctionDescriptor getEnclosingFunctionDescriptor(@NotNull BindingContext context, @NotNull KtElement element) {
        if (context == null) {
            BindingContextUtils.$$$reportNull$$$0(21);
        }
        if (element == null) {
            BindingContextUtils.$$$reportNull$$$0(22);
        }
        KtElement functionOrClass = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)element, KtFunction.class, KtClassOrObject.class);
        DeclarationDescriptor descriptor2 = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionOrClass);
        if (functionOrClass instanceof KtFunction) {
            if (descriptor2 instanceof FunctionDescriptor) {
                return (FunctionDescriptor)descriptor2;
            }
            return null;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            return ((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor();
        }
        return null;
    }

    public static void reportAmbiguousLabel(@NotNull BindingTrace trace, @NotNull KtSimpleNameExpression targetLabel, @NotNull Collection<DeclarationDescriptor> declarationsByLabel) {
        if (trace == null) {
            BindingContextUtils.$$$reportNull$$$0(23);
        }
        if (targetLabel == null) {
            BindingContextUtils.$$$reportNull$$$0(24);
        }
        if (declarationsByLabel == null) {
            BindingContextUtils.$$$reportNull$$$0(25);
        }
        ArrayList<PsiElement> targets = Lists.newArrayList();
        for (DeclarationDescriptor descriptor2 : declarationsByLabel) {
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            assert (element != null) : "Label can only point to something in the same lexical scope";
            targets.add(element);
        }
        if (!targets.isEmpty()) {
            trace.record(BindingContext.AMBIGUOUS_LABEL_TARGET, targetLabel, targets);
        }
        trace.report(Errors.AMBIGUOUS_LABEL.on(targetLabel));
    }

    @Nullable
    public static KotlinType updateRecordedType(@Nullable KotlinType type2, @NotNull KtExpression expression2, @NotNull BindingTrace trace, boolean shouldBeMadeNullable) {
        if (expression2 == null) {
            BindingContextUtils.$$$reportNull$$$0(26);
        }
        if (trace == null) {
            BindingContextUtils.$$$reportNull$$$0(27);
        }
        if (type2 == null) {
            return null;
        }
        if (shouldBeMadeNullable) {
            type2 = TypeUtils.makeNullable(type2);
        }
        trace.recordType(expression2, type2);
        return type2;
    }

    @Nullable
    public static KotlinTypeInfo getRecordedTypeInfo(@NotNull KtExpression expression2, @NotNull BindingContext context) {
        if (expression2 == null) {
            BindingContextUtils.$$$reportNull$$$0(28);
        }
        if (context == null) {
            BindingContextUtils.$$$reportNull$$$0(29);
        }
        if (context.get(BindingContext.PROCESSED, expression2) != Boolean.TRUE) {
            return null;
        }
        KotlinTypeInfo result2 = context.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        return result2 != null ? result2 : TypeInfoFactoryKt.noTypeInfo(DataFlowInfoFactory.EMPTY);
    }

    public static boolean isExpressionWithValidReference(@NotNull KtExpression expression2, @NotNull BindingContext context) {
        if (expression2 == null) {
            BindingContextUtils.$$$reportNull$$$0(30);
        }
        if (context == null) {
            BindingContextUtils.$$$reportNull$$$0(31);
        }
        if (expression2 instanceof KtCallExpression) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, context);
            return resolvedCall2 instanceof VariableAsFunctionResolvedCall;
        }
        return expression2 instanceof KtReferenceExpression;
    }

    public static boolean isCapturedInClosure(BindingContext bindingContext, DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof VariableDescriptor) || descriptor2 instanceof PropertyDescriptor) {
            return false;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
        return bindingContext.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) != null;
    }

    public static boolean isCapturedInClosureWithExactlyOnceEffect(BindingContext bindingContext, DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof VariableDescriptor) || descriptor2 instanceof PropertyDescriptor) {
            return false;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
        return bindingContext.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) == CaptureKind.EXACTLY_ONCE_EFFECT;
    }

    public static boolean isBoxedLocalCapturedInClosure(BindingContext bindingContext, DeclarationDescriptor descriptor2) {
        return BindingContextUtils.isCapturedInClosure(bindingContext, descriptor2) && ((VariableDescriptor)descriptor2).isVar() || BindingContextUtils.isCapturedInClosureWithExactlyOnceEffect(bindingContext, descriptor2);
    }

    @NotNull
    public static Pair<FunctionDescriptor, PsiElement> getContainingFunctionSkipFunctionLiterals(@Nullable DeclarationDescriptor startDescriptor, boolean strict) {
        PsiElement containingFunction;
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(startDescriptor, FunctionDescriptor.class, strict);
        PsiElement psiElement = containingFunction = containingFunctionDescriptor != null ? DescriptorToSourceUtils.getSourceFromDescriptor(containingFunctionDescriptor) : null;
        while (containingFunction instanceof KtFunctionLiteral) {
            containingFunction = (containingFunctionDescriptor = DescriptorUtils.getParentOfType(containingFunctionDescriptor, FunctionDescriptor.class)) != null ? DescriptorToSourceUtils.getSourceFromDescriptor(containingFunctionDescriptor) : null;
        }
        Pair<FunctionDescriptor, PsiElement> pair = new Pair<FunctionDescriptor, PsiElement>(containingFunctionDescriptor, containingFunction);
        if (pair == null) {
            BindingContextUtils.$$$reportNull$$$0(32);
        }
        return pair;
    }

    @Nullable
    public static ResolvedCall<ConstructorDescriptor> getDelegationConstructorCall(@NotNull BindingContext bindingContext, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (bindingContext == null) {
            BindingContextUtils.$$$reportNull$$$0(33);
        }
        if (constructorDescriptor == null) {
            BindingContextUtils.$$$reportNull$$$0(34);
        }
        return bindingContext.get(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructorDescriptor);
    }

    static void addOwnDataTo(@NotNull BindingTrace trace, @Nullable TraceEntryFilter filter2, boolean commitDiagnostics, @NotNull MutableSlicedMap map2, MutableDiagnosticsWithSuppression diagnostics2) {
        if (trace == null) {
            BindingContextUtils.$$$reportNull$$$0(35);
        }
        if (map2 == null) {
            BindingContextUtils.$$$reportNull$$$0(36);
        }
        map2.forEach((Function3<WritableSlice, Object, Object, Void>)((Function3)(slice, key, value) -> {
            if (filter2 == null || filter2.accept((WritableSlice<?, ?>)slice, key)) {
                trace.record(slice, key, value);
            }
            return null;
        }));
        if (!commitDiagnostics) {
            return;
        }
        for (Diagnostic diagnostic : diagnostics2.getOwnDiagnostics()) {
            if (filter2 != null && !filter2.accept(null, diagnostic.getPsiElement())) continue;
            trace.report(diagnostic);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 19: 
            case 20: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 19: 
            case 20: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 2: 
            case 23: 
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slice";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 19: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/BindingContextUtils";
                break;
            }
            case 10: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageIfNull";
                break;
            }
            case 17: 
            case 21: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLabel";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationsByLabel";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorDescriptor";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/BindingContextUtils";
                break;
            }
            case 8: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNull";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNotNull";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnclosingDescriptor";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFunctionSkipFunctionLiterals";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractVariableFromResolvedCall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractVariableDescriptorFromReference";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recordFunctionDeclarationToDescriptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNotNull";
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 19: 
            case 20: 
            case 32: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeNotNull";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingDescriptor";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingFunctionDescriptor";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "reportAmbiguousLabel";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateRecordedType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRecordedTypeInfo";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isExpressionWithValidReference";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDelegationConstructorCall";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addOwnDataTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 19: 
            case 20: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

