/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.MixInLegacyTypesClassLoader;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.HierarchicalClassLoaderStructure;

public class ClassLoaderStructureProvider {
    private final ClassLoaderRegistry classLoaderRegistry;
    private final Cache<Iterable<File>, ClassLoaderStructure> knownClassLoaderStructures;

    public ClassLoaderStructureProvider(ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
        this.knownClassLoaderStructures = CacheBuilder.newBuilder().softValues().build();
    }

    public ClassLoaderStructure getWorkerProcessClassLoaderStructure(final Iterable<File> userClasspathFiles) {
        try {
            return (ClassLoaderStructure)this.knownClassLoaderStructures.get(userClasspathFiles, (Callable)new Callable<ClassLoaderStructure>(){

                @Override
                public ClassLoaderStructure call() throws Exception {
                    MixInLegacyTypesClassLoader.Spec workerExtensionSpec = ClassLoaderStructureProvider.this.classLoaderRegistry.getGradleWorkerExtensionSpec();
                    FilteringClassLoader.Spec gradleApiFilter = ClassLoaderStructureProvider.this.classLoaderRegistry.getGradleApiFilterSpec();
                    VisitableURLClassLoader.Spec userSpec = new VisitableURLClassLoader.Spec("worker-loader", DefaultClassPath.of((Iterable)userClasspathFiles).getAsURLs());
                    return new HierarchicalClassLoaderStructure((ClassLoaderSpec)workerExtensionSpec).withChild((ClassLoaderSpec)gradleApiFilter).withChild((ClassLoaderSpec)userSpec);
                }
            });
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public ClassLoaderStructure getInProcessClassLoaderStructure(final Iterable<File> userClasspathFiles) {
        try {
            return (ClassLoaderStructure)this.knownClassLoaderStructures.get(userClasspathFiles, (Callable)new Callable<ClassLoaderStructure>(){

                @Override
                public ClassLoaderStructure call() throws Exception {
                    FilteringClassLoader.Spec gradleApiFilter = ClassLoaderStructureProvider.this.classLoaderRegistry.getGradleApiFilterSpec();
                    VisitableURLClassLoader.Spec userSpec = new VisitableURLClassLoader.Spec("worker-loader", DefaultClassPath.of((Iterable)userClasspathFiles).getAsURLs());
                    return new HierarchicalClassLoaderStructure((ClassLoaderSpec)gradleApiFilter).withChild((ClassLoaderSpec)userSpec);
                }
            });
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

